/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.tabcontrol.tabbedpane;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.netbeans.core.windows.view.ui.tabcontrol.tabbedpane.CloseableTabComponent;
import org.netbeans.core.windows.view.ui.tabcontrol.tabbedpane.NBTabbedPane;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.customtabs.TabbedType;
import org.netbeans.swing.tabcontrol.event.ArrayDiff;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.event.VeryComplexListDataEvent;
import org.openide.windows.TopComponent;

public class NBTabbedPaneController {
    protected ComplexListDataListener modelListener = null;
    private NBTabbedPane container;
    protected final Controller controller;

    public NBTabbedPaneController(final NBTabbedPane nBTabbedPane) {
        this.container = nBTabbedPane;
        this.modelListener = new ComplexListDataListener(){

            public void indicesAdded(ComplexListDataEvent complexListDataEvent) {
                int[] nArray = complexListDataEvent.getIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    NBTabbedPaneController.this.addToContainer(nBTabbedPane.getDataModel().getTab(nArray[i]), 0);
                }
            }

            public void indicesRemoved(ComplexListDataEvent complexListDataEvent) {
                int[] nArray = complexListDataEvent.getIndices();
                TabData[] tabDataArray = complexListDataEvent.getAffectedItems();
                for (int i = 0; i < nArray.length; ++i) {
                    Component component = NBTabbedPaneController.this.toComp(tabDataArray[i]);
                    nBTabbedPane.remove(component);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void indicesChanged(ComplexListDataEvent complexListDataEvent) {
                if (complexListDataEvent instanceof VeryComplexListDataEvent) {
                    int n;
                    ArrayDiff arrayDiff = ((VeryComplexListDataEvent)complexListDataEvent).getDiff();
                    Set set = arrayDiff.getDeletedIndices();
                    Set set2 = arrayDiff.getAddedIndices();
                    TabData[] tabDataArray = arrayDiff.getOldData();
                    TabData[] tabDataArray2 = arrayDiff.getNewData();
                    HashSet<Component> hashSet = new HashSet<Component>();
                    for (n = 0; n < tabDataArray2.length; ++n) {
                        hashSet.add(NBTabbedPaneController.this.toComp(tabDataArray2[n]));
                    }
                    n = 0;
                    Object object = nBTabbedPane.getTreeLock();
                    synchronized (object) {
                        TabData tabData;
                        if (set2.isEmpty() && set.isEmpty() && !arrayDiff.getMovedIndices().isEmpty()) {
                            for (int i = 0; i < nBTabbedPane.getTabCount(); ++i) {
                                set2.add(i);
                                set.add(i);
                            }
                            hashSet.clear();
                        }
                        if (!set.isEmpty()) {
                            for (Integer n2 : set) {
                                tabData = tabDataArray[n2];
                                if (hashSet.contains(NBTabbedPaneController.this.toComp(tabData))) continue;
                                nBTabbedPane.remove(NBTabbedPaneController.this.toComp(tabData));
                                n = 1;
                            }
                        }
                        if (!set2.isEmpty()) {
                            for (Integer n2 : set2) {
                                tabData = tabDataArray2[n2];
                                if (nBTabbedPane.isAncestorOf(NBTabbedPaneController.this.toComp(tabData))) continue;
                                NBTabbedPaneController.this.addToContainer(tabData, n2);
                                n = 1;
                            }
                        }
                    }
                    if (n != 0) {
                        nBTabbedPane.revalidate();
                        nBTabbedPane.repaint();
                    }
                }
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                Component component = null;
                for (int i = listDataEvent.getIndex0(); i <= listDataEvent.getIndex1(); ++i) {
                    component = NBTabbedPaneController.this.toComp(nBTabbedPane.getDataModel().getTab(i));
                    NBTabbedPaneController.this.addToContainer(nBTabbedPane.getDataModel().getTab(i), 0);
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                ComplexListDataEvent complexListDataEvent = (ComplexListDataEvent)listDataEvent;
                TabData[] tabDataArray = complexListDataEvent.getAffectedItems();
                for (int i = 0; i < tabDataArray.length; ++i) {
                    Component component = NBTabbedPaneController.this.toComp(tabDataArray[i]);
                    nBTabbedPane.remove(component);
                }
            }

            private void maybeMakeSelectedTabVisible(ComplexListDataEvent complexListDataEvent) {
                if (!nBTabbedPane.isShowing() || nBTabbedPane.getWidth() < 10) {
                    return;
                }
                if (nBTabbedPane.getType() == TabbedType.EDITOR) {
                    int n = nBTabbedPane.getModel().getSelectedIndex();
                    if (complexListDataEvent.getIndex0() == complexListDataEvent.getIndex1() && complexListDataEvent.getIndex0() == n) {
                        nBTabbedPane.setSelectedIndex(n);
                    }
                }
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                if (listDataEvent instanceof ComplexListDataEvent) {
                    ComplexListDataEvent complexListDataEvent = (ComplexListDataEvent)listDataEvent;
                    int n = complexListDataEvent.getIndex0();
                    if (complexListDataEvent.isUserObjectChanged() && n != -1) {
                        boolean bl;
                        Component component = nBTabbedPane.getComponent(n);
                        nBTabbedPane.remove(component);
                        boolean bl2 = bl = n == nBTabbedPane.getModel().getSelectedIndex();
                        if (bl) {
                            NBTabbedPaneController.this.addToContainer(nBTabbedPane.getDataModel().getTab(n), n);
                        }
                    }
                    if (complexListDataEvent.isTextChanged()) {
                        this.maybeMakeSelectedTabVisible(complexListDataEvent);
                    }
                }
            }
        };
        this.controller = new Controller();
        nBTabbedPane.addMouseListener(this.controller);
    }

    private void addToContainer(TabData tabData, int n) {
        if (n > this.container.getTabCount()) {
            n = -1;
        }
        this.container.add(tabData.getComponent(), n);
        n = this.container.indexOfComponent(tabData.getComponent());
        this.container.setTabComponentAt(n, new CloseableTabComponent(tabData.getIcon(), tabData.getText(), true, tabData.getTooltip(), this.container, this.controller));
    }

    protected final Component toComp(TabData tabData) {
        return this.container.getComponentConverter().getComponent(tabData);
    }

    public void attachModelAndSelectionListeners() {
        this.container.getDataModel().addComplexListDataListener(this.modelListener);
    }

    protected void detachModelAndSelectionListeners() {
        this.container.getDataModel().removeComplexListDataListener(this.modelListener);
    }

    protected final boolean shouldPerformAction(String string, int n, MouseEvent mouseEvent) {
        TabActionEvent tabActionEvent = new TabActionEvent((Object)this.container, string, n, mouseEvent);
        this.container.postActionEvent(tabActionEvent);
        return !tabActionEvent.isConsumed();
    }

    private void makeRollover(int n) {
        if (!(this.container.getUI() instanceof BasicTabbedPaneUI)) {
            return;
        }
        BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)this.container.getUI();
        try {
            Method method = this.container.getUI().getClass().getDeclaredMethod("setRolloverTab", Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)basicTabbedPaneUI, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected class Controller
    extends MouseAdapter
    implements MouseMotionListener {
        protected Controller() {
        }

        protected boolean shouldReact(MouseEvent mouseEvent) {
            boolean bl = SwingUtilities.isLeftMouseButton(mouseEvent);
            return bl;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            point = SwingUtilities.convertPoint(mouseEvent.getComponent(), point, NBTabbedPaneController.this.container);
            int n = NBTabbedPaneController.this.container.indexAtLocation(point.x, point.y);
            SingleSelectionModel singleSelectionModel = NBTabbedPaneController.this.container.getModel();
            if (n >= 0 && mouseEvent.getComponent() != NBTabbedPaneController.this.container) {
                CloseableTabComponent closeableTabComponent = (CloseableTabComponent)NBTabbedPaneController.this.container.getTabComponentAt(n);
                if (closeableTabComponent.isInCloseButton(mouseEvent)) {
                    return;
                }
                n = NBTabbedPaneController.this.container.indexOf(NBTabbedPaneController.this.container.getComponentAt(n));
                boolean bl = NBTabbedPaneController.this.shouldPerformAction("select", n, mouseEvent);
                if (bl) {
                    singleSelectionModel.setSelectedIndex(n);
                    Component component = NBTabbedPaneController.this.container.getDataModel().getTab(n).getComponent();
                    if (null != component && component instanceof TopComponent && !((TopComponent)component).isAncestorOf(KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner())) {
                        ((TopComponent)component).requestActive();
                    }
                }
            }
            if (mouseEvent.isPopupTrigger()) {
                NBTabbedPaneController.this.shouldPerformAction("popup", n, mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            Point point = mouseEvent.getPoint();
            point = SwingUtilities.convertPoint(mouseEvent.getComponent(), point, NBTabbedPaneController.this.container);
            int n2 = n = NBTabbedPaneController.this.container.indexAtLocation(point.x, point.y);
            if (n >= 0) {
                n2 = NBTabbedPaneController.this.container.indexOf(NBTabbedPaneController.this.container.getComponentAt(n));
            }
            if (mouseEvent.getClickCount() >= 2 && !mouseEvent.isPopupTrigger()) {
                boolean bl;
                SingleSelectionModel singleSelectionModel = NBTabbedPaneController.this.container.getModel();
                if (n >= 0 && (bl = NBTabbedPaneController.this.shouldPerformAction("select", n2, mouseEvent))) {
                    singleSelectionModel.setSelectedIndex(n);
                }
                if (n != -1 && mouseEvent.getButton() == 1) {
                    NBTabbedPaneController.this.shouldPerformAction("maximize", n2, mouseEvent);
                }
            } else if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 1 && n >= 0) {
                CloseableTabComponent closeableTabComponent = (CloseableTabComponent)NBTabbedPaneController.this.container.getTabComponentAt(n);
                if (closeableTabComponent.isInCloseButton(mouseEvent)) {
                    String string = "close";
                    if (NBTabbedPaneController.this.container.getType() == TabbedType.EDITOR) {
                        if ((mouseEvent.getModifiers() & 1) > 0) {
                            string = "closeAll";
                        } else if ((mouseEvent.getModifiers() & 8) > 0) {
                            string = "closeAllButThis";
                        }
                    }
                    NBTabbedPaneController.this.shouldPerformAction(string, n2, mouseEvent);
                }
            } else if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 2 && n >= 0) {
                CloseableTabComponent closeableTabComponent = (CloseableTabComponent)NBTabbedPaneController.this.container.getTabComponentAt(n);
                String string = "close";
                NBTabbedPaneController.this.shouldPerformAction(string, n2, mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            point = SwingUtilities.convertPoint(mouseEvent.getComponent(), point, NBTabbedPaneController.this.container);
            int n = NBTabbedPaneController.this.container.indexAtLocation(point.x, point.y);
            if (mouseEvent.isPopupTrigger()) {
                if (n >= 0) {
                    n = NBTabbedPaneController.this.container.indexOf(NBTabbedPaneController.this.container.getComponentAt(n));
                }
                NBTabbedPaneController.this.shouldPerformAction("popup", n, mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            point = SwingUtilities.convertPoint(mouseEvent.getComponent(), point, NBTabbedPaneController.this.container);
            int n = NBTabbedPaneController.this.container.indexAtLocation(point.x, point.y);
            if (n >= 0) {
                NBTabbedPaneController.this.makeRollover(n);
            }
        }
    }
}

