/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.renderable;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.batik.ext.awt.image.CompositeRule;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.SVGComposite;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.CompositeRable;
import org.apache.batik.ext.awt.image.renderable.CompositeRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.FilterResRable;
import org.apache.batik.ext.awt.image.renderable.PadRable;
import org.apache.batik.ext.awt.image.renderable.PaintRable;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.TileCacheRed;

public class FilterResRable8Bit
extends AbstractRable
implements FilterResRable,
PaintRable {
    private int filterResolutionX = -1;
    private int filterResolutionY = -1;
    Reference resRed = null;
    float resScale = 0.0f;

    public FilterResRable8Bit() {
    }

    public FilterResRable8Bit(Filter filter, int n, int n2) {
        this.init(filter, null);
        this.setFilterResolutionX(n);
        this.setFilterResolutionY(n2);
    }

    @Override
    public Filter getSource() {
        return (Filter)this.srcs.get(0);
    }

    @Override
    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    @Override
    public int getFilterResolutionX() {
        return this.filterResolutionX;
    }

    @Override
    public void setFilterResolutionX(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.filterResolutionX = n;
    }

    @Override
    public int getFilterResolutionY() {
        return this.filterResolutionY;
    }

    @Override
    public void setFilterResolutionY(int n) {
        this.touch();
        this.filterResolutionY = n;
    }

    public boolean allPaintRable(RenderableImage renderableImage) {
        if (!(renderableImage instanceof PaintRable)) {
            return false;
        }
        Vector<RenderableImage> vector = renderableImage.getSources();
        if (vector == null) {
            return true;
        }
        for (RenderableImage renderableImage2 : vector) {
            if (this.allPaintRable(renderableImage2)) continue;
            return false;
        }
        return true;
    }

    public boolean distributeAcross(RenderableImage renderableImage, Graphics2D graphics2D) {
        if (renderableImage instanceof PadRable) {
            PadRable padRable = (PadRable)renderableImage;
            Shape shape = graphics2D.getClip();
            graphics2D.clip(padRable.getPadRect());
            boolean bl = this.distributeAcross(padRable.getSource(), graphics2D);
            graphics2D.setClip(shape);
            return bl;
        }
        if (renderableImage instanceof CompositeRable) {
            CompositeRable compositeRable = (CompositeRable)renderableImage;
            if (compositeRable.getCompositeRule() != CompositeRule.OVER) {
                return false;
            }
            Vector<RenderableImage> vector = compositeRable.getSources();
            if (vector == null) {
                return true;
            }
            ListIterator listIterator = vector.listIterator(vector.size());
            while (listIterator.hasPrevious()) {
                RenderableImage renderableImage2 = (RenderableImage)listIterator.previous();
                if (this.allPaintRable(renderableImage2)) continue;
                listIterator.next();
                break;
            }
            if (!listIterator.hasPrevious()) {
                GraphicsUtil.drawImage(graphics2D, compositeRable);
                return true;
            }
            if (!listIterator.hasNext()) {
                return false;
            }
            int n = listIterator.nextIndex();
            AbstractRable abstractRable = new CompositeRable8Bit(vector.subList(0, n), compositeRable.getCompositeRule(), compositeRable.isColorSpaceLinear());
            abstractRable = new FilterResRable8Bit(abstractRable, this.getFilterResolutionX(), this.getFilterResolutionY());
            GraphicsUtil.drawImage(graphics2D, abstractRable);
            while (listIterator.hasNext()) {
                PaintRable paintRable = (PaintRable)listIterator.next();
                if (paintRable.paintRable(graphics2D)) continue;
                Filter filter = (Filter)((Object)paintRable);
                filter = new FilterResRable8Bit(filter, this.getFilterResolutionX(), this.getFilterResolutionY());
                GraphicsUtil.drawImage(graphics2D, filter);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean paintRable(Graphics2D graphics2D) {
        Composite composite = graphics2D.getComposite();
        if (!SVGComposite.OVER.equals(composite)) {
            return false;
        }
        Filter filter = this.getSource();
        return this.distributeAcross(filter, graphics2D);
    }

    private float getResScale() {
        return this.resScale;
    }

    private RenderedImage getResRed(RenderingHints renderingHints) {
        RenderedImage renderedImage;
        double d;
        Rectangle2D rectangle2D = this.getBounds2D();
        double d2 = (double)this.getFilterResolutionX() / rectangle2D.getWidth();
        float f = (float)Math.min(d2, d = (double)this.getFilterResolutionY() / rectangle2D.getHeight());
        if (f == this.resScale && (renderedImage = (RenderedImage)this.resRed.get()) != null) {
            return renderedImage;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(f, f);
        RenderContext renderContext = new RenderContext(affineTransform, null, renderingHints);
        renderedImage = this.getSource().createRendering(renderContext);
        renderedImage = new TileCacheRed(GraphicsUtil.wrap(renderedImage));
        this.resScale = f;
        this.resRed = new SoftReference<RenderedImage>(renderedImage);
        return renderedImage;
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        AffineTransform affineTransform = renderContext.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        RenderingHints renderingHints = renderContext.getRenderingHints();
        int n = this.getFilterResolutionX();
        int n2 = this.getFilterResolutionY();
        if (n <= 0 || n2 == 0) {
            return null;
        }
        Rectangle2D rectangle2D = this.getBounds2D();
        Rectangle rectangle = affineTransform.createTransformedShape(rectangle2D).getBounds();
        float f = 1.0f;
        if (n < rectangle.width) {
            f = (float)n / (float)rectangle.width;
        }
        float f2 = 1.0f;
        if (n2 < 0) {
            f2 = f;
        } else if (n2 < rectangle.height) {
            f2 = (float)n2 / (float)rectangle.height;
        }
        if (f >= 1.0f && f2 >= 1.0f) {
            return this.getSource().createRendering(renderContext);
        }
        RenderedImage renderedImage = this.getResRed(renderingHints);
        float f3 = this.getResScale();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform.getScaleX() / (double)f3, affineTransform.getShearY() / (double)f3, affineTransform.getShearX() / (double)f3, affineTransform.getScaleY() / (double)f3, affineTransform.getTranslateX(), affineTransform.getTranslateY());
        return new AffineRed(GraphicsUtil.wrap(renderedImage), affineTransform2, renderingHints);
    }
}

