/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.yield;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.yield.CallBlockNode;

@GeneratedBy(value=CallBlockNode.class)
@SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
public final class CallBlockNodeGen
extends CallBlockNode
implements SpecializedNode {
    @Node.Child
    private RubyNode block_;
    @Node.Child
    private RubyNode self_;
    @Node.Child
    private RubyNode blockArgument_;
    @Node.Child
    private RubyNode arguments0_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeCallBlockCached_;
    @Node.Child
    private BaseNode_ specialization_;

    private CallBlockNodeGen(RubyContext context, SourceSection sourceSection, DeclarationContext declarationContext, RubyNode block, RubyNode self, RubyNode blockArgument, RubyNode[] arguments) {
        super(context, sourceSection, declarationContext);
        this.block_ = block;
        this.self_ = self;
        this.blockArgument_ = blockArgument;
        this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeCallBlock(VirtualFrame frameValue, DynamicObject blockValue, Object selfValue, DynamicObject blockArgumentValue, Object[] arguments0Value) {
        return this.specialization_.execute1(frameValue, blockValue, selfValue, blockArgumentValue, arguments0Value);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static CallBlockNode create(RubyContext context, SourceSection sourceSection, DeclarationContext declarationContext, RubyNode block, RubyNode self, RubyNode blockArgument, RubyNode[] arguments) {
        return new CallBlockNodeGen(context, sourceSection, declarationContext, block, self, blockArgument, arguments);
    }

    @GeneratedBy(methodName="callBlockUncached(VirtualFrame, DynamicObject, Object, Object, Object[], IndirectCallNode)", value=CallBlockNode.class)
    private static final class CallBlockUncachedNode_
    extends BaseNode_ {
        @Node.Child
        private IndirectCallNode callNode;

        CallBlockUncachedNode_(CallBlockNodeGen root, IndirectCallNode callNode) {
            super(root, 2);
            this.callNode = callNode;
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject blockValue, Object selfValue, DynamicObject blockArgumentValue, Object[] arguments0Value) {
            return this.root.callBlockUncached(frameValue, blockValue, selfValue, blockArgumentValue, arguments0Value, this.callNode);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object blockValue, Object selfValue, Object blockArgumentValue, Object arguments0Value) {
            if (blockValue instanceof DynamicObject && arguments0Value instanceof Object[]) {
                DynamicObject blockValue_ = (DynamicObject)blockValue;
                Object[] arguments0Value_ = (Object[])arguments0Value;
                return this.root.callBlockUncached(frameValue, blockValue_, selfValue, blockArgumentValue, arguments0Value_, this.callNode);
            }
            return this.getNext().execute_(frameValue, blockValue, selfValue, blockArgumentValue, arguments0Value);
        }

        static BaseNode_ create(CallBlockNodeGen root, IndirectCallNode callNode) {
            return new CallBlockUncachedNode_(root, callNode);
        }
    }

    @GeneratedBy(methodName="callBlockCached(VirtualFrame, DynamicObject, Object, Object, Object[], CallTarget, DirectCallNode)", value=CallBlockNode.class)
    private static final class CallBlockCachedNode_
    extends BaseNode_ {
        private final CallTarget cachedCallTarget;
        @Node.Child
        private DirectCallNode callNode;

        CallBlockCachedNode_(CallBlockNodeGen root, CallTarget cachedCallTarget, DirectCallNode callNode) {
            super(root, 1);
            this.cachedCallTarget = cachedCallTarget;
            this.callNode = callNode;
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object blockValue, Object selfValue, Object blockArgumentValue, Object arguments0Value) {
            if (newNode.getClass() == CallBlockUncachedNode_.class) {
                this.removeSame("Contained by callBlockUncached(VirtualFrame, DynamicObject, Object, Object, Object[], IndirectCallNode)");
            }
            return super.merge(newNode, frameValue, blockValue, selfValue, blockArgumentValue, arguments0Value);
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object blockValue, Object selfValue, Object blockArgumentValue, Object arguments0Value) {
            DynamicObject blockValue_;
            return blockValue instanceof DynamicObject && arguments0Value instanceof Object[] && CallBlockNode.getBlockCallTarget(blockValue_ = (DynamicObject)blockValue) == this.cachedCallTarget;
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject blockValue, Object selfValue, DynamicObject blockArgumentValue, Object[] arguments0Value) {
            if (CallBlockNode.getBlockCallTarget(blockValue) == this.cachedCallTarget) {
                return this.root.callBlockCached(frameValue, blockValue, selfValue, blockArgumentValue, arguments0Value, this.cachedCallTarget, this.callNode);
            }
            return this.getNext().execute1(frameValue, blockValue, selfValue, blockArgumentValue, arguments0Value);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object blockValue, Object selfValue, Object blockArgumentValue, Object arguments0Value) {
            if (blockValue instanceof DynamicObject && arguments0Value instanceof Object[]) {
                DynamicObject blockValue_ = (DynamicObject)blockValue;
                Object[] arguments0Value_ = (Object[])arguments0Value;
                if (CallBlockNode.getBlockCallTarget(blockValue_) == this.cachedCallTarget) {
                    return this.root.callBlockCached(frameValue, blockValue_, selfValue, blockArgumentValue, arguments0Value_, this.cachedCallTarget, this.callNode);
                }
            }
            return this.getNext().execute_(frameValue, blockValue, selfValue, blockArgumentValue, arguments0Value);
        }

        static BaseNode_ create(CallBlockNodeGen root, CallTarget cachedCallTarget, DirectCallNode callNode) {
            return new CallBlockCachedNode_(root, cachedCallTarget, callNode);
        }
    }

    @GeneratedBy(value=CallBlockNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(CallBlockNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object blockValue, Object selfValue, Object blockArgumentValue, Object arguments0Value) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, blockValue, selfValue, blockArgumentValue, arguments0Value));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object blockValue, Object selfValue, Object blockArgumentValue, Object arguments0Value) {
            return this.getNext().execute_(frameValue, blockValue, selfValue, blockArgumentValue, arguments0Value);
        }

        static BaseNode_ create(CallBlockNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=CallBlockNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(CallBlockNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object blockValue, Object selfValue, Object blockArgumentValue, Object arguments0Value) {
            return this.uninitialized((Frame)frameValue, blockValue, selfValue, blockArgumentValue, arguments0Value);
        }

        static BaseNode_ create(CallBlockNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=CallBlockNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected CallBlockNodeGen root;

        BaseNode_(CallBlockNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (CallBlockNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.block_, this.root.self_, this.root.blockArgument_, this.root.arguments0_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object blockValue, Object selfValue, Object blockArgumentValue, Object arguments0Value) {
            return this.execute_((VirtualFrame)frameValue, blockValue, selfValue, blockArgumentValue, arguments0Value);
        }

        public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

        public Object execute1(VirtualFrame frameValue, DynamicObject blockValue, Object selfValue, DynamicObject blockArgumentValue, Object[] arguments0Value) {
            return this.execute_(frameValue, blockValue, selfValue, blockArgumentValue, arguments0Value);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object blockValue_ = this.root.block_.execute(frameValue);
            Object selfValue_ = this.root.self_.execute(frameValue);
            Object blockArgumentValue_ = this.root.blockArgument_.execute(frameValue);
            Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
            return this.execute_(frameValue, blockValue_, selfValue_, blockArgumentValue_, arguments0Value_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object blockValue, Object selfValue, Object blockArgumentValue, Object arguments0Value) {
            if (blockValue instanceof DynamicObject && arguments0Value instanceof Object[]) {
                DirectCallNode callNode1;
                BaseNode_ s;
                DynamicObject blockValue_ = (DynamicObject)blockValue;
                CallTarget cachedCallTarget1 = CallBlockNode.getBlockCallTarget(blockValue_);
                if (CallBlockNode.getBlockCallTarget(blockValue_) == cachedCallTarget1 && !this.root.excludeCallBlockCached_ && this.countSame(s = CallBlockCachedNode_.create(this.root, cachedCallTarget1, callNode1 = this.root.createBlockCallNode(cachedCallTarget1))) < this.root.getCacheLimit()) {
                    return s;
                }
                IndirectCallNode callNode2 = IndirectCallNode.create();
                this.root.excludeCallBlockCached_ = true;
                return CallBlockUncachedNode_.create(this.root, callNode2);
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

