/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ConstProperties;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ExternalArrayData;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.mozilla.javascript.annotations.JSStaticFunction;
import org.mozilla.javascript.debug.DebuggableObject;

public abstract class ScriptableObject
implements Scriptable,
Serializable,
DebuggableObject,
ConstProperties {
    static final long serialVersionUID = 2829861078851942586L;
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    public static final int UNINITIALIZED_CONST = 8;
    public static final int CONST = 13;
    private Scriptable prototypeObject;
    private Scriptable parentScopeObject;
    private transient Slot[] slots;
    private int count;
    private transient ExternalArrayData externalData;
    private transient Slot firstAdded;
    private transient Slot lastAdded;
    private volatile Map<Object, Object> associatedValues;
    private static final int SLOT_QUERY = 1;
    private static final int SLOT_MODIFY = 2;
    private static final int SLOT_MODIFY_CONST = 3;
    private static final int SLOT_MODIFY_GETTER_SETTER = 4;
    private static final int SLOT_CONVERT_ACCESSOR_TO_DATA = 5;
    private static final int INITIAL_SLOT_SIZE = 4;
    private boolean isExtensible = true;
    private static final Method GET_ARRAY_LENGTH;

    protected static ScriptableObject buildDataDescriptor(Scriptable scriptable, Object object, int n) {
        NativeObject nativeObject = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(nativeObject, scriptable, TopLevel.Builtins.Object);
        nativeObject.defineProperty("value", object, 0);
        nativeObject.defineProperty("writable", (n & 1) == 0, 0);
        nativeObject.defineProperty("enumerable", (n & 2) == 0, 0);
        nativeObject.defineProperty("configurable", (n & 4) == 0, 0);
        return nativeObject;
    }

    static void checkValidAttributes(int n) {
        int n2 = 15;
        if ((n & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
    }

    public ScriptableObject() {
    }

    public ScriptableObject(Scriptable scriptable, Scriptable scriptable2) {
        if (scriptable == null) {
            throw new IllegalArgumentException();
        }
        this.parentScopeObject = scriptable;
        this.prototypeObject = scriptable2;
    }

    public String getTypeOf() {
        return this.avoidObjectDetection() ? "undefined" : "object";
    }

    @Override
    public abstract String getClassName();

    @Override
    public boolean has(String string, Scriptable scriptable) {
        return null != this.getSlot(string, 0, 1);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        if (this.externalData != null) {
            return n < this.externalData.getArrayLength();
        }
        return null != this.getSlot((String)null, n, 1);
    }

    @Override
    public Object get(String string, Scriptable scriptable) {
        Slot slot = this.getSlot(string, 0, 1);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.getValue(scriptable);
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        if (this.externalData != null) {
            if (n < this.externalData.getArrayLength()) {
                return this.externalData.getArrayElement(n);
            }
            return Scriptable.NOT_FOUND;
        }
        Slot slot = this.getSlot((String)null, n, 1);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.getValue(scriptable);
    }

    @Override
    public void put(String string, Scriptable scriptable, Object object) {
        if (this.putImpl(string, 0, scriptable, object)) {
            return;
        }
        if (scriptable == this) {
            throw Kit.codeBug();
        }
        scriptable.put(string, scriptable, object);
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        if (this.externalData != null) {
            if (n >= this.externalData.getArrayLength()) {
                throw new JavaScriptException(ScriptRuntime.newNativeError(Context.getCurrentContext(), this, TopLevel.NativeErrors.RangeError, new Object[]{"External array index out of bounds "}), null, 0);
            }
            this.externalData.setArrayElement(n, object);
            return;
        }
        if (this.putImpl(null, n, scriptable, object)) {
            return;
        }
        if (scriptable == this) {
            throw Kit.codeBug();
        }
        scriptable.put(n, scriptable, object);
    }

    @Override
    public void delete(String string) {
        this.checkNotSealed(string, 0);
        this.removeSlot(string, 0);
    }

    @Override
    public void delete(int n) {
        this.checkNotSealed(null, n);
        this.removeSlot(null, n);
    }

    @Override
    public void putConst(String string, Scriptable scriptable, Object object) {
        if (this.putConstImpl(string, 0, scriptable, object, 1)) {
            return;
        }
        if (scriptable == this) {
            throw Kit.codeBug();
        }
        if (scriptable instanceof ConstProperties) {
            ((ConstProperties)((Object)scriptable)).putConst(string, scriptable, object);
        } else {
            scriptable.put(string, scriptable, object);
        }
    }

    @Override
    public void defineConst(String string, Scriptable scriptable) {
        if (this.putConstImpl(string, 0, scriptable, Undefined.instance, 8)) {
            return;
        }
        if (scriptable == this) {
            throw Kit.codeBug();
        }
        if (scriptable instanceof ConstProperties) {
            ((ConstProperties)((Object)scriptable)).defineConst(string, scriptable);
        }
    }

    @Override
    public boolean isConst(String string) {
        Slot slot = this.getSlot(string, 0, 1);
        if (slot == null) {
            return false;
        }
        return (slot.getAttributes() & 5) == 5;
    }

    @Deprecated
    public final int getAttributes(String string, Scriptable scriptable) {
        return this.getAttributes(string);
    }

    @Deprecated
    public final int getAttributes(int n, Scriptable scriptable) {
        return this.getAttributes(n);
    }

    @Deprecated
    public final void setAttributes(String string, Scriptable scriptable, int n) {
        this.setAttributes(string, n);
    }

    @Deprecated
    public void setAttributes(int n, Scriptable scriptable, int n2) {
        this.setAttributes(n, n2);
    }

    public int getAttributes(String string) {
        return this.findAttributeSlot(string, 0, 1).getAttributes();
    }

    public int getAttributes(int n) {
        return this.findAttributeSlot(null, n, 1).getAttributes();
    }

    public void setAttributes(String string, int n) {
        this.checkNotSealed(string, 0);
        this.findAttributeSlot(string, 0, 2).setAttributes(n);
    }

    public void setAttributes(int n, int n2) {
        this.checkNotSealed(null, n);
        this.findAttributeSlot(null, n, 2).setAttributes(n2);
    }

    public void setGetterOrSetter(String string, int n, Callable callable, boolean bl) {
        this.setGetterOrSetter(string, n, callable, bl, false);
    }

    private void setGetterOrSetter(String string, int n, Callable callable, boolean bl, boolean bl2) {
        int n2;
        GetterSlot getterSlot;
        if (string != null && n != 0) {
            throw new IllegalArgumentException(string);
        }
        if (!bl2) {
            this.checkNotSealed(string, n);
        }
        if (this.isExtensible()) {
            getterSlot = (GetterSlot)this.getSlot(string, n, 4);
        } else {
            Slot slot = ScriptableObject.unwrapSlot(this.getSlot(string, n, 1));
            if (!(slot instanceof GetterSlot)) {
                return;
            }
            getterSlot = (GetterSlot)slot;
        }
        if (!bl2 && ((n2 = getterSlot.getAttributes()) & 1) != 0) {
            throw Context.reportRuntimeError1("msg.modify.readonly", string);
        }
        if (bl) {
            getterSlot.setter = callable;
        } else {
            getterSlot.getter = callable;
        }
        getterSlot.value = Undefined.instance;
    }

    public Object getGetterOrSetter(String string, int n, boolean bl) {
        if (string != null && n != 0) {
            throw new IllegalArgumentException(string);
        }
        Slot slot = ScriptableObject.unwrapSlot(this.getSlot(string, n, 1));
        if (slot == null) {
            return null;
        }
        if (slot instanceof GetterSlot) {
            GetterSlot getterSlot = (GetterSlot)slot;
            Object object = bl ? getterSlot.setter : getterSlot.getter;
            return object != null ? object : Undefined.instance;
        }
        return Undefined.instance;
    }

    protected boolean isGetterOrSetter(String string, int n, boolean bl) {
        Slot slot = ScriptableObject.unwrapSlot(this.getSlot(string, n, 1));
        if (slot instanceof GetterSlot) {
            if (bl && ((GetterSlot)slot).setter != null) {
                return true;
            }
            if (!bl && ((GetterSlot)slot).getter != null) {
                return true;
            }
        }
        return false;
    }

    void addLazilyInitializedValue(String string, int n, LazilyLoadedCtor lazilyLoadedCtor, int n2) {
        if (string != null && n != 0) {
            throw new IllegalArgumentException(string);
        }
        this.checkNotSealed(string, n);
        GetterSlot getterSlot = (GetterSlot)this.getSlot(string, n, 4);
        getterSlot.setAttributes(n2);
        getterSlot.getter = null;
        getterSlot.setter = null;
        getterSlot.value = lazilyLoadedCtor;
    }

    public void setExternalArrayData(ExternalArrayData externalArrayData) {
        this.externalData = externalArrayData;
        if (externalArrayData == null) {
            this.delete("length");
        } else {
            this.defineProperty("length", null, GET_ARRAY_LENGTH, null, 3);
        }
    }

    public ExternalArrayData getExternalArrayData() {
        return this.externalData;
    }

    public Object getExternalArrayLength() {
        return this.externalData == null ? 0 : this.externalData.getArrayLength();
    }

    @Override
    public Scriptable getPrototype() {
        return this.prototypeObject;
    }

    @Override
    public void setPrototype(Scriptable scriptable) {
        this.prototypeObject = scriptable;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parentScopeObject;
    }

    @Override
    public void setParentScope(Scriptable scriptable) {
        this.parentScopeObject = scriptable;
    }

    @Override
    public Object[] getIds() {
        return this.getIds(false);
    }

    @Override
    public Object[] getAllIds() {
        return this.getIds(true);
    }

    @Override
    public Object getDefaultValue(Class<?> clazz) {
        return ScriptableObject.getDefaultValue(this, clazz);
    }

    public static Object getDefaultValue(Scriptable scriptable, Class<?> clazz) {
        Context context = null;
        for (int i = 0; i < 2; ++i) {
            Object object;
            Object object2;
            Object[] objectArray;
            String string;
            boolean bl;
            if (clazz == ScriptRuntime.StringClass) {
                bl = i == 0;
            } else {
                boolean bl2 = bl = i == 1;
            }
            if (bl) {
                string = "toString";
                objectArray = ScriptRuntime.emptyArgs;
            } else {
                string = "valueOf";
                objectArray = new Object[1];
                if (clazz == null) {
                    object2 = "undefined";
                } else if (clazz == ScriptRuntime.StringClass) {
                    object2 = "string";
                } else if (clazz == ScriptRuntime.ScriptableClass) {
                    object2 = "object";
                } else if (clazz == ScriptRuntime.FunctionClass) {
                    object2 = "function";
                } else if (clazz == ScriptRuntime.BooleanClass || clazz == Boolean.TYPE) {
                    object2 = "boolean";
                } else if (clazz == ScriptRuntime.NumberClass || clazz == ScriptRuntime.ByteClass || clazz == Byte.TYPE || clazz == ScriptRuntime.ShortClass || clazz == Short.TYPE || clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE || clazz == ScriptRuntime.FloatClass || clazz == Float.TYPE || clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
                    object2 = "number";
                } else {
                    throw Context.reportRuntimeError1("msg.invalid.type", clazz.toString());
                }
                objectArray[0] = object2;
            }
            object2 = ScriptableObject.getProperty(scriptable, string);
            if (!(object2 instanceof Function)) continue;
            Function function = (Function)object2;
            if (context == null) {
                context = Context.getContext();
            }
            if ((object2 = function.call(context, function.getParentScope(), scriptable, objectArray)) == null) continue;
            if (!(object2 instanceof Scriptable)) {
                return object2;
            }
            if (clazz == ScriptRuntime.ScriptableClass || clazz == ScriptRuntime.FunctionClass) {
                return object2;
            }
            if (!bl || !(object2 instanceof Wrapper) || !((object = ((Wrapper)object2).unwrap()) instanceof String)) continue;
            return object;
        }
        String string = clazz == null ? "undefined" : clazz.getName();
        throw ScriptRuntime.typeError1("msg.default.value", string);
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        return ScriptRuntime.jsDelegatesTo(scriptable, this);
    }

    public boolean avoidObjectDetection() {
        return false;
    }

    protected Object equivalentValues(Object object) {
        return this == object ? Boolean.TRUE : Scriptable.NOT_FOUND;
    }

    public static <T extends Scriptable> void defineClass(Scriptable scriptable, Class<T> clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scriptable, clazz, false, false);
    }

    public static <T extends Scriptable> void defineClass(Scriptable scriptable, Class<T> clazz, boolean bl) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scriptable, clazz, bl, false);
    }

    public static <T extends Scriptable> String defineClass(Scriptable scriptable, Class<T> clazz, boolean bl, boolean bl2) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        BaseFunction baseFunction = ScriptableObject.buildClassCtor(scriptable, clazz, bl, bl2);
        if (baseFunction == null) {
            return null;
        }
        String string = baseFunction.getClassPrototype().getClassName();
        ScriptableObject.defineProperty(scriptable, string, baseFunction, 2);
        return string;
    }

    static <T extends Scriptable> BaseFunction buildClassCtor(Scriptable scriptable, Class<T> clazz, boolean bl, boolean bl2) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        FunctionObject functionObject;
        Object object;
        String string;
        Object object2;
        Object object3;
        Executable executable;
        AccessibleObject[] accessibleObjectArray = FunctionObject.getMethodList(clazz);
        for (int i = 0; i < accessibleObjectArray.length; ++i) {
            executable = accessibleObjectArray[i];
            if (!((Method)executable).getName().equals("init")) continue;
            Class<?>[] classArray = ((Method)executable).getParameterTypes();
            if (classArray.length == 3 && classArray[0] == ScriptRuntime.ContextClass && classArray[1] == ScriptRuntime.ScriptableClass && classArray[2] == Boolean.TYPE && Modifier.isStatic(((Method)executable).getModifiers())) {
                Object[] objectArray = new Object[]{Context.getContext(), scriptable, bl ? Boolean.TRUE : Boolean.FALSE};
                ((Method)executable).invoke(null, objectArray);
                return null;
            }
            if (classArray.length != 1 || classArray[0] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(((Method)executable).getModifiers())) continue;
            Object[] objectArray = new Object[]{scriptable};
            ((Method)executable).invoke(null, objectArray);
            return null;
        }
        AccessibleObject[] accessibleObjectArray2 = clazz.getConstructors();
        executable = null;
        for (int i = 0; i < accessibleObjectArray2.length; ++i) {
            if (accessibleObjectArray2[i].getParameterTypes().length != 0) continue;
            executable = accessibleObjectArray2[i];
            break;
        }
        if (executable == null) {
            throw Context.reportRuntimeError1("msg.zero.arg.ctor", clazz.getName());
        }
        Scriptable scriptable2 = (Scriptable)((Constructor)executable).newInstance(ScriptRuntime.emptyArgs);
        String string2 = scriptable2.getClassName();
        Object object4 = ScriptableObject.getProperty(ScriptableObject.getTopLevelScope(scriptable), string2);
        if (object4 instanceof BaseFunction && (object3 = ((BaseFunction)object4).getPrototypeProperty()) != null && clazz.equals(object3.getClass())) {
            return (BaseFunction)object4;
        }
        object3 = null;
        if (bl2 && ScriptRuntime.ScriptableClass.isAssignableFrom((Class<?>)(object2 = clazz.getSuperclass())) && !Modifier.isAbstract(((Class)object2).getModifiers()) && (string = ScriptableObject.defineClass(scriptable, object = ScriptableObject.extendsScriptable(object2), bl, bl2)) != null) {
            object3 = ScriptableObject.getClassPrototype(scriptable, string);
        }
        if (object3 == null) {
            object3 = ScriptableObject.getObjectPrototype(scriptable);
        }
        scriptable2.setPrototype((Scriptable)object3);
        object2 = "jsFunction_";
        object = "jsStaticFunction_";
        string = "jsGet_";
        String string3 = "jsSet_";
        String string4 = "jsConstructor";
        Object object5 = ScriptableObject.findAnnotatedMember(accessibleObjectArray, JSConstructor.class);
        if (object5 == null) {
            object5 = ScriptableObject.findAnnotatedMember(accessibleObjectArray2, JSConstructor.class);
        }
        if (object5 == null) {
            object5 = FunctionObject.findSingleMethod((Method[])accessibleObjectArray, "jsConstructor");
        }
        if (object5 == null) {
            if (accessibleObjectArray2.length == 1) {
                object5 = accessibleObjectArray2[0];
            } else if (accessibleObjectArray2.length == 2) {
                if (((Constructor)accessibleObjectArray2[0]).getParameterTypes().length == 0) {
                    object5 = accessibleObjectArray2[1];
                } else if (((Constructor)accessibleObjectArray2[1]).getParameterTypes().length == 0) {
                    object5 = accessibleObjectArray2[0];
                }
            }
            if (object5 == null) {
                throw Context.reportRuntimeError1("msg.ctor.multiple.parms", clazz.getName());
            }
        }
        if ((functionObject = new FunctionObject(string2, (Member)object5, scriptable)).isVarArgsMethod()) {
            throw Context.reportRuntimeError1("msg.varargs.ctor", object5.getName());
        }
        functionObject.initAsConstructor(scriptable, scriptable2);
        AccessibleObject accessibleObject = null;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet hashSet2 = new HashSet();
        for (AccessibleObject accessibleObject2 : accessibleObjectArray) {
            Object object6;
            String string5;
            boolean bl3;
            HashSet<String> hashSet3;
            Object object7;
            if (accessibleObject2 == object5) continue;
            String string6 = ((Method)accessibleObject2).getName();
            if (string6.equals("finishInit") && ((Class<?>[])(object7 = ((Method)accessibleObject2).getParameterTypes())).length == 3 && object7[0] == ScriptRuntime.ScriptableClass && object7[1] == FunctionObject.class && object7[2] == ScriptRuntime.ScriptableClass && Modifier.isStatic(((Method)accessibleObject2).getModifiers())) {
                accessibleObject = accessibleObject2;
                continue;
            }
            if (string6.indexOf(36) != -1 || string6.equals("jsConstructor")) continue;
            object7 = null;
            String string7 = null;
            if (accessibleObject2.isAnnotationPresent(JSFunction.class)) {
                object7 = ((Method)accessibleObject2).getAnnotation(JSFunction.class);
            } else if (accessibleObject2.isAnnotationPresent(JSStaticFunction.class)) {
                object7 = ((Method)accessibleObject2).getAnnotation(JSStaticFunction.class);
            } else if (accessibleObject2.isAnnotationPresent(JSGetter.class)) {
                object7 = ((Method)accessibleObject2).getAnnotation(JSGetter.class);
            } else if (accessibleObject2.isAnnotationPresent(JSSetter.class)) continue;
            if (object7 == null) {
                if (string6.startsWith("jsFunction_")) {
                    string7 = "jsFunction_";
                } else if (string6.startsWith("jsStaticFunction_")) {
                    string7 = "jsStaticFunction_";
                } else if (string6.startsWith("jsGet_")) {
                    string7 = "jsGet_";
                } else if (object7 == null) continue;
            }
            if ((hashSet3 = (bl3 = object7 instanceof JSStaticFunction || string7 == "jsStaticFunction_") ? hashSet : hashSet2).contains(string5 = ScriptableObject.getPropertyName(string6, string7, object7))) {
                throw Context.reportRuntimeError2("duplicate.defineClass.name", string6, string5);
            }
            hashSet3.add(string5);
            string6 = string5;
            if (object7 instanceof JSGetter || string7 == "jsGet_") {
                if (!(scriptable2 instanceof ScriptableObject)) {
                    throw Context.reportRuntimeError2("msg.extend.scriptable", scriptable2.getClass().toString(), string6);
                }
                object6 = ScriptableObject.findSetterMethod((Method[])accessibleObjectArray, string6, "jsSet_");
                int n = 6 | (object6 != null ? 0 : 1);
                ((ScriptableObject)scriptable2).defineProperty(string6, null, (Method)accessibleObject2, (Method)object6, n);
                continue;
            }
            if (bl3 && !Modifier.isStatic(((Method)accessibleObject2).getModifiers())) {
                throw Context.reportRuntimeError("jsStaticFunction must be used with static method.");
            }
            object6 = new FunctionObject(string6, (Member)((Object)accessibleObject2), scriptable2);
            if (((FunctionObject)object6).isVarArgsConstructor()) {
                throw Context.reportRuntimeError1("msg.varargs.fun", object5.getName());
            }
            ScriptableObject.defineProperty(bl3 ? functionObject : scriptable2, string6, object6, 2);
            if (!bl) continue;
            ((ScriptableObject)object6).sealObject();
        }
        if (accessibleObject != null) {
            Object[] objectArray = new Object[]{scriptable, functionObject, scriptable2};
            accessibleObject.invoke(null, objectArray);
        }
        if (bl) {
            functionObject.sealObject();
            if (scriptable2 instanceof ScriptableObject) {
                ((ScriptableObject)scriptable2).sealObject();
            }
        }
        return functionObject;
    }

    private static Member findAnnotatedMember(AccessibleObject[] accessibleObjectArray, Class<? extends Annotation> clazz) {
        for (AccessibleObject accessibleObject : accessibleObjectArray) {
            if (!accessibleObject.isAnnotationPresent(clazz)) continue;
            return (Member)((Object)accessibleObject);
        }
        return null;
    }

    private static Method findSetterMethod(Method[] methodArray, String string, String string2) {
        String string3 = "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        for (Method method : methodArray) {
            JSSetter object = method.getAnnotation(JSSetter.class);
            if (object == null || !string.equals(object.value()) && (!"".equals(object.value()) || !string3.equals(method.getName()))) continue;
            return method;
        }
        String string4 = string2 + string;
        for (Method method : methodArray) {
            if (!string4.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    private static String getPropertyName(String string, String string2, Annotation annotation) {
        if (string2 != null) {
            return string.substring(string2.length());
        }
        String string3 = null;
        if (annotation instanceof JSGetter) {
            string3 = ((JSGetter)annotation).value();
            if ((string3 == null || string3.length() == 0) && string.length() > 3 && string.startsWith("get") && Character.isUpperCase((string3 = string.substring(3)).charAt(0))) {
                if (string3.length() == 1) {
                    string3 = string3.toLowerCase();
                } else if (!Character.isUpperCase(string3.charAt(1))) {
                    string3 = Character.toLowerCase(string3.charAt(0)) + string3.substring(1);
                }
            }
        } else if (annotation instanceof JSFunction) {
            string3 = ((JSFunction)annotation).value();
        } else if (annotation instanceof JSStaticFunction) {
            string3 = ((JSStaticFunction)annotation).value();
        }
        if (string3 == null || string3.length() == 0) {
            string3 = string;
        }
        return string3;
    }

    private static <T extends Scriptable> Class<T> extendsScriptable(Class<?> clazz) {
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(clazz)) {
            return clazz;
        }
        return null;
    }

    public void defineProperty(String string, Object object, int n) {
        this.checkNotSealed(string, 0);
        this.put(string, (Scriptable)this, object);
        this.setAttributes(string, n);
    }

    public static void defineProperty(Scriptable scriptable, String string, Object object, int n) {
        if (!(scriptable instanceof ScriptableObject)) {
            scriptable.put(string, scriptable, object);
            return;
        }
        ScriptableObject scriptableObject = (ScriptableObject)scriptable;
        scriptableObject.defineProperty(string, object, n);
    }

    public static void defineConstProperty(Scriptable scriptable, String string) {
        if (scriptable instanceof ConstProperties) {
            ConstProperties constProperties = (ConstProperties)((Object)scriptable);
            constProperties.defineConst(string, scriptable);
        } else {
            ScriptableObject.defineProperty(scriptable, string, Undefined.instance, 13);
        }
    }

    public void defineProperty(String string, Class<?> clazz, int n) {
        int n2 = string.length();
        if (n2 == 0) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[3 + n2];
        string.getChars(0, n2, cArray, 3);
        cArray[3] = Character.toUpperCase(cArray[3]);
        cArray[0] = 103;
        cArray[1] = 101;
        cArray[2] = 116;
        String string2 = new String(cArray);
        cArray[0] = 115;
        String string3 = new String(cArray);
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        Method method = FunctionObject.findSingleMethod(methodArray, string2);
        Method method2 = FunctionObject.findSingleMethod(methodArray, string3);
        if (method2 == null) {
            n |= 1;
        }
        this.defineProperty(string, null, method, method2 == null ? null : method2, n);
    }

    public void defineProperty(String string, Object object, Method method, Method method2, int n) {
        Object object2;
        Object object3;
        MemberBox memberBox = null;
        if (method != null) {
            boolean bl;
            memberBox = new MemberBox(method);
            if (!Modifier.isStatic(method.getModifiers())) {
                bl = object != null;
                memberBox.delegateTo = object;
            } else {
                bl = true;
                memberBox.delegateTo = Void.TYPE;
            }
            String string2 = null;
            object3 = method.getParameterTypes();
            if (((Class<?>[])object3).length == 0) {
                if (bl) {
                    string2 = "msg.obj.getter.parms";
                }
            } else if (((Class<?>[])object3).length == 1) {
                object2 = object3[0];
                if (object2 != ScriptRuntime.ScriptableClass && object2 != ScriptRuntime.ScriptableObjectClass) {
                    string2 = "msg.bad.getter.parms";
                } else if (!bl) {
                    string2 = "msg.bad.getter.parms";
                }
            } else {
                string2 = "msg.bad.getter.parms";
            }
            if (string2 != null) {
                throw Context.reportRuntimeError1(string2, method.toString());
            }
        }
        MemberBox memberBox2 = null;
        if (method2 != null) {
            boolean bl;
            if (method2.getReturnType() != Void.TYPE) {
                throw Context.reportRuntimeError1("msg.setter.return", method2.toString());
            }
            memberBox2 = new MemberBox(method2);
            if (!Modifier.isStatic(method2.getModifiers())) {
                bl = object != null;
                memberBox2.delegateTo = object;
            } else {
                bl = true;
                memberBox2.delegateTo = Void.TYPE;
            }
            object3 = null;
            object2 = method2.getParameterTypes();
            if (((Class<?>[])object2).length == 1) {
                if (bl) {
                    object3 = "msg.setter2.expected";
                }
            } else if (((Class<?>[])object2).length == 2) {
                Class<?> clazz = object2[0];
                if (clazz != ScriptRuntime.ScriptableClass && clazz != ScriptRuntime.ScriptableObjectClass) {
                    object3 = "msg.setter2.parms";
                } else if (!bl) {
                    object3 = "msg.setter1.parms";
                }
            } else {
                object3 = "msg.setter.parms";
            }
            if (object3 != null) {
                throw Context.reportRuntimeError1(object3, method2.toString());
            }
        }
        GetterSlot getterSlot = (GetterSlot)this.getSlot(string, 0, 4);
        getterSlot.setAttributes(n);
        getterSlot.getter = memberBox;
        getterSlot.setter = memberBox2;
    }

    public void defineOwnProperties(Context context, ScriptableObject scriptableObject) {
        int n;
        Object[] objectArray = scriptableObject.getIds();
        ScriptableObject[] scriptableObjectArray = new ScriptableObject[objectArray.length];
        int n2 = objectArray.length;
        for (n = 0; n < n2; ++n) {
            Object object = ScriptRuntime.getObjectElem(scriptableObject, objectArray[n], context);
            ScriptableObject scriptableObject2 = ScriptableObject.ensureScriptableObject(object);
            this.checkPropertyDefinition(scriptableObject2);
            scriptableObjectArray[n] = scriptableObject2;
        }
        n2 = objectArray.length;
        for (n = 0; n < n2; ++n) {
            this.defineOwnProperty(context, objectArray[n], scriptableObjectArray[n]);
        }
    }

    public void defineOwnProperty(Context context, Object object, ScriptableObject scriptableObject) {
        this.checkPropertyDefinition(scriptableObject);
        this.defineOwnProperty(context, object, scriptableObject, true);
    }

    protected void defineOwnProperty(Context context, Object object, ScriptableObject scriptableObject, boolean bl) {
        int n;
        boolean bl2;
        Slot slot = this.getSlot(context, object, 1);
        boolean bl3 = bl2 = slot == null;
        if (bl) {
            ScriptableObject scriptableObject2 = slot == null ? null : slot.getPropertyDescriptor(context, this);
            String string = ScriptRuntime.toString(object);
            this.checkPropertyChange(string, scriptableObject2, scriptableObject);
        }
        boolean bl4 = this.isAccessorDescriptor(scriptableObject);
        if (slot == null) {
            slot = this.getSlot(context, object, bl4 ? 4 : 2);
            n = this.applyDescriptorToAttributeBitset(7, scriptableObject);
        } else {
            n = this.applyDescriptorToAttributeBitset(slot.getAttributes(), scriptableObject);
        }
        slot = ScriptableObject.unwrapSlot(slot);
        if (bl4) {
            Object object2;
            if (!(slot instanceof GetterSlot)) {
                slot = this.getSlot(context, object, 4);
            }
            GetterSlot getterSlot = (GetterSlot)slot;
            Object object3 = ScriptableObject.getProperty((Scriptable)scriptableObject, "get");
            if (object3 != NOT_FOUND) {
                getterSlot.getter = object3;
            }
            if ((object2 = ScriptableObject.getProperty((Scriptable)scriptableObject, "set")) != NOT_FOUND) {
                getterSlot.setter = object2;
            }
            getterSlot.value = Undefined.instance;
            getterSlot.setAttributes(n);
        } else {
            Object object4;
            if (slot instanceof GetterSlot && this.isDataDescriptor(scriptableObject)) {
                slot = this.getSlot(context, object, 5);
            }
            if ((object4 = ScriptableObject.getProperty((Scriptable)scriptableObject, "value")) != NOT_FOUND) {
                slot.value = object4;
            } else if (bl2) {
                slot.value = Undefined.instance;
            }
            slot.setAttributes(n);
        }
    }

    protected void checkPropertyDefinition(ScriptableObject scriptableObject) {
        Object object = ScriptableObject.getProperty((Scriptable)scriptableObject, "get");
        if (object != NOT_FOUND && object != Undefined.instance && !(object instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(object);
        }
        Object object2 = ScriptableObject.getProperty((Scriptable)scriptableObject, "set");
        if (object2 != NOT_FOUND && object2 != Undefined.instance && !(object2 instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(object2);
        }
        if (this.isDataDescriptor(scriptableObject) && this.isAccessorDescriptor(scriptableObject)) {
            throw ScriptRuntime.typeError0("msg.both.data.and.accessor.desc");
        }
    }

    protected void checkPropertyChange(String string, ScriptableObject scriptableObject, ScriptableObject scriptableObject2) {
        if (scriptableObject == null) {
            if (!this.isExtensible()) {
                throw ScriptRuntime.typeError0("msg.not.extensible");
            }
        } else if (ScriptableObject.isFalse(scriptableObject.get("configurable", (Scriptable)scriptableObject))) {
            if (ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "configurable"))) {
                throw ScriptRuntime.typeError1("msg.change.configurable.false.to.true", string);
            }
            if (ScriptableObject.isTrue(scriptableObject.get("enumerable", (Scriptable)scriptableObject)) != ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "enumerable"))) {
                throw ScriptRuntime.typeError1("msg.change.enumerable.with.configurable.false", string);
            }
            boolean bl = this.isDataDescriptor(scriptableObject2);
            boolean bl2 = this.isAccessorDescriptor(scriptableObject2);
            if (bl || bl2) {
                if (bl && this.isDataDescriptor(scriptableObject)) {
                    if (ScriptableObject.isFalse(scriptableObject.get("writable", (Scriptable)scriptableObject))) {
                        if (ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "writable"))) {
                            throw ScriptRuntime.typeError1("msg.change.writable.false.to.true.with.configurable.false", string);
                        }
                        if (!this.sameValue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "value"), scriptableObject.get("value", (Scriptable)scriptableObject))) {
                            throw ScriptRuntime.typeError1("msg.change.value.with.writable.false", string);
                        }
                    }
                } else if (bl2 && this.isAccessorDescriptor(scriptableObject)) {
                    if (!this.sameValue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "set"), scriptableObject.get("set", (Scriptable)scriptableObject))) {
                        throw ScriptRuntime.typeError1("msg.change.setter.with.configurable.false", string);
                    }
                    if (!this.sameValue(ScriptableObject.getProperty((Scriptable)scriptableObject2, "get"), scriptableObject.get("get", (Scriptable)scriptableObject))) {
                        throw ScriptRuntime.typeError1("msg.change.getter.with.configurable.false", string);
                    }
                } else {
                    if (this.isDataDescriptor(scriptableObject)) {
                        throw ScriptRuntime.typeError1("msg.change.property.data.to.accessor.with.configurable.false", string);
                    }
                    throw ScriptRuntime.typeError1("msg.change.property.accessor.to.data.with.configurable.false", string);
                }
            }
        }
    }

    protected static boolean isTrue(Object object) {
        return object != NOT_FOUND && ScriptRuntime.toBoolean(object);
    }

    protected static boolean isFalse(Object object) {
        return !ScriptableObject.isTrue(object);
    }

    protected boolean sameValue(Object object, Object object2) {
        if (object == NOT_FOUND) {
            return true;
        }
        if (object2 == NOT_FOUND) {
            object2 = Undefined.instance;
        }
        if (object2 instanceof Number && object instanceof Number) {
            double d = ((Number)object2).doubleValue();
            double d2 = ((Number)object).doubleValue();
            if (Double.isNaN(d) && Double.isNaN(d2)) {
                return true;
            }
            if (d == 0.0 && Double.doubleToLongBits(d) != Double.doubleToLongBits(d2)) {
                return false;
            }
        }
        return ScriptRuntime.shallowEq(object2, object);
    }

    protected int applyDescriptorToAttributeBitset(int n, ScriptableObject scriptableObject) {
        Object object;
        Object object2;
        Object object3 = ScriptableObject.getProperty((Scriptable)scriptableObject, "enumerable");
        if (object3 != NOT_FOUND) {
            int n2 = n = ScriptRuntime.toBoolean(object3) ? n & 0xFFFFFFFD : n | 2;
        }
        if ((object2 = ScriptableObject.getProperty((Scriptable)scriptableObject, "writable")) != NOT_FOUND) {
            int n3 = n = ScriptRuntime.toBoolean(object2) ? n & 0xFFFFFFFE : n | 1;
        }
        if ((object = ScriptableObject.getProperty((Scriptable)scriptableObject, "configurable")) != NOT_FOUND) {
            n = ScriptRuntime.toBoolean(object) ? n & 0xFFFFFFFB : n | 4;
        }
        return n;
    }

    protected boolean isDataDescriptor(ScriptableObject scriptableObject) {
        return ScriptableObject.hasProperty((Scriptable)scriptableObject, "value") || ScriptableObject.hasProperty((Scriptable)scriptableObject, "writable");
    }

    protected boolean isAccessorDescriptor(ScriptableObject scriptableObject) {
        return ScriptableObject.hasProperty((Scriptable)scriptableObject, "get") || ScriptableObject.hasProperty((Scriptable)scriptableObject, "set");
    }

    protected boolean isGenericDescriptor(ScriptableObject scriptableObject) {
        return !this.isDataDescriptor(scriptableObject) && !this.isAccessorDescriptor(scriptableObject);
    }

    protected static Scriptable ensureScriptable(Object object) {
        if (!(object instanceof Scriptable)) {
            throw ScriptRuntime.typeError1("msg.arg.not.object", ScriptRuntime.typeof(object));
        }
        return (Scriptable)object;
    }

    protected static ScriptableObject ensureScriptableObject(Object object) {
        if (!(object instanceof ScriptableObject)) {
            throw ScriptRuntime.typeError1("msg.arg.not.object", ScriptRuntime.typeof(object));
        }
        return (ScriptableObject)object;
    }

    public void defineFunctionProperties(String[] stringArray, Class<?> clazz, int n) {
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Method method = FunctionObject.findSingleMethod(methodArray, string);
            if (method == null) {
                throw Context.reportRuntimeError2("msg.method.not.found", string, clazz.getName());
            }
            FunctionObject functionObject = new FunctionObject(string, method, this);
            this.defineProperty(string, functionObject, n);
        }
    }

    public static Scriptable getObjectPrototype(Scriptable scriptable) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scriptable), TopLevel.Builtins.Object);
    }

    public static Scriptable getFunctionPrototype(Scriptable scriptable) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scriptable), TopLevel.Builtins.Function);
    }

    public static Scriptable getArrayPrototype(Scriptable scriptable) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scriptable), TopLevel.Builtins.Array);
    }

    public static Scriptable getClassPrototype(Scriptable scriptable, String string) {
        Object object;
        Object object2 = ScriptableObject.getProperty(scriptable = ScriptableObject.getTopLevelScope(scriptable), string);
        if (object2 instanceof BaseFunction) {
            object = ((BaseFunction)object2).getPrototypeProperty();
        } else if (object2 instanceof Scriptable) {
            Scriptable scriptable2 = (Scriptable)object2;
            object = scriptable2.get("prototype", scriptable2);
        } else {
            return null;
        }
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return null;
    }

    public static Scriptable getTopLevelScope(Scriptable scriptable) {
        Scriptable scriptable2;
        while ((scriptable2 = scriptable.getParentScope()) != null) {
            scriptable = scriptable2;
        }
        return scriptable;
    }

    public boolean isExtensible() {
        return this.isExtensible;
    }

    public void preventExtensions() {
        this.isExtensible = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sealObject() {
        if (this.count >= 0) {
            Slot slot = this.firstAdded;
            while (slot != null) {
                Object object = slot.value;
                if (object instanceof LazilyLoadedCtor) {
                    LazilyLoadedCtor lazilyLoadedCtor = (LazilyLoadedCtor)object;
                    try {
                        lazilyLoadedCtor.init();
                    }
                    finally {
                        slot.value = lazilyLoadedCtor.getValue();
                    }
                }
                slot = slot.orderedNext;
            }
            this.count ^= 0xFFFFFFFF;
        }
    }

    public final boolean isSealed() {
        return this.count < 0;
    }

    private void checkNotSealed(String string, int n) {
        if (!this.isSealed()) {
            return;
        }
        String string2 = string != null ? string : Integer.toString(n);
        throw Context.reportRuntimeError1("msg.modify.sealed", string2);
    }

    public static Object getProperty(Scriptable scriptable, String string) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(string, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static <T> T getTypedProperty(Scriptable scriptable, int n, Class<T> clazz) {
        Object object = ScriptableObject.getProperty(scriptable, n);
        if (object == Scriptable.NOT_FOUND) {
            object = null;
        }
        return clazz.cast(Context.jsToJava(object, clazz));
    }

    public static Object getProperty(Scriptable scriptable, int n) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(n, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static <T> T getTypedProperty(Scriptable scriptable, String string, Class<T> clazz) {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (object == Scriptable.NOT_FOUND) {
            object = null;
        }
        return clazz.cast(Context.jsToJava(object, clazz));
    }

    public static boolean hasProperty(Scriptable scriptable, String string) {
        return null != ScriptableObject.getBase(scriptable, string);
    }

    public static void redefineProperty(Scriptable scriptable, String string, boolean bl) {
        ConstProperties constProperties;
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            return;
        }
        if (scriptable2 instanceof ConstProperties && (constProperties = (ConstProperties)((Object)scriptable2)).isConst(string)) {
            throw ScriptRuntime.typeError1("msg.const.redecl", string);
        }
        if (bl) {
            throw ScriptRuntime.typeError1("msg.var.redecl", string);
        }
    }

    public static boolean hasProperty(Scriptable scriptable, int n) {
        return null != ScriptableObject.getBase(scriptable, n);
    }

    public static void putProperty(Scriptable scriptable, String string, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(string, scriptable, object);
    }

    public static void putConstProperty(Scriptable scriptable, String string, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        if (scriptable2 instanceof ConstProperties) {
            ((ConstProperties)((Object)scriptable2)).putConst(string, scriptable, object);
        }
    }

    public static void putProperty(Scriptable scriptable, int n, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(n, scriptable, object);
    }

    public static boolean deleteProperty(Scriptable scriptable, String string) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(string);
        return !scriptable2.has(string, scriptable);
    }

    public static boolean deleteProperty(Scriptable scriptable, int n) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(n);
        return !scriptable2.has(n, scriptable);
    }

    public static Object[] getPropertyIds(Scriptable scriptable) {
        if (scriptable == null) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray = scriptable.getIds();
        ObjToIntMap objToIntMap = null;
        while ((scriptable = scriptable.getPrototype()) != null) {
            int n;
            Object[] objectArray2 = scriptable.getIds();
            if (objectArray2.length == 0) continue;
            if (objToIntMap == null) {
                if (objectArray.length == 0) {
                    objectArray = objectArray2;
                    continue;
                }
                objToIntMap = new ObjToIntMap(objectArray.length + objectArray2.length);
                for (n = 0; n != objectArray.length; ++n) {
                    objToIntMap.intern(objectArray[n]);
                }
                objectArray = null;
            }
            for (n = 0; n != objectArray2.length; ++n) {
                objToIntMap.intern(objectArray2[n]);
            }
        }
        if (objToIntMap != null) {
            objectArray = objToIntMap.getKeys();
        }
        return objectArray;
    }

    public static Object callMethod(Scriptable scriptable, String string, Object[] objectArray) {
        return ScriptableObject.callMethod(null, scriptable, string, objectArray);
    }

    public static Object callMethod(Context context, Scriptable scriptable, String string, Object[] objectArray) {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (!(object instanceof Function)) {
            throw ScriptRuntime.notFunctionError(scriptable, string);
        }
        Function function = (Function)object;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        if (context != null) {
            return function.call(context, scriptable2, scriptable, objectArray);
        }
        return Context.call(null, function, scriptable2, scriptable, objectArray);
    }

    private static Scriptable getBase(Scriptable scriptable, String string) {
        while (!scriptable.has(string, scriptable) && (scriptable = scriptable.getPrototype()) != null) {
        }
        return scriptable;
    }

    private static Scriptable getBase(Scriptable scriptable, int n) {
        while (!scriptable.has(n, scriptable) && (scriptable = scriptable.getPrototype()) != null) {
        }
        return scriptable;
    }

    public final Object getAssociatedValue(Object object) {
        Map<Object, Object> map = this.associatedValues;
        if (map == null) {
            return null;
        }
        return map.get(object);
    }

    public static Object getTopScopeValue(Scriptable scriptable, Object object) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        do {
            ScriptableObject scriptableObject;
            Object object2;
            if (!(scriptable instanceof ScriptableObject) || (object2 = (scriptableObject = (ScriptableObject)scriptable).getAssociatedValue(object)) == null) continue;
            return object2;
        } while ((scriptable = scriptable.getPrototype()) != null);
        return null;
    }

    public final synchronized Object associateValue(Object object, Object object2) {
        if (object2 == null) {
            throw new IllegalArgumentException();
        }
        Map<Object, Object> map = this.associatedValues;
        if (map == null) {
            this.associatedValues = map = new HashMap<Object, Object>();
        }
        return Kit.initHash(map, object, object2);
    }

    private boolean putImpl(String string, int n, Scriptable scriptable, Object object) {
        Slot slot;
        if (this != scriptable) {
            slot = this.getSlot(string, n, 1);
            if (slot == null) {
                return false;
            }
        } else if (!this.isExtensible) {
            slot = this.getSlot(string, n, 1);
            if (slot == null) {
                return true;
            }
        } else {
            if (this.count < 0) {
                this.checkNotSealed(string, n);
            }
            slot = this.getSlot(string, n, 2);
        }
        return slot.setValue(object, this, scriptable);
    }

    private boolean putConstImpl(String string, int n, Scriptable scriptable, Object object, int n2) {
        Slot slot;
        assert (n2 != 0);
        if (this != scriptable) {
            slot = this.getSlot(string, n, 1);
            if (slot == null) {
                return false;
            }
        } else if (!this.isExtensible()) {
            slot = this.getSlot(string, n, 1);
            if (slot == null) {
                return true;
            }
        } else {
            this.checkNotSealed(string, n);
            Slot slot2 = ScriptableObject.unwrapSlot(this.getSlot(string, n, 3));
            int n3 = slot2.getAttributes();
            if ((n3 & 1) == 0) {
                throw Context.reportRuntimeError1("msg.var.redecl", string);
            }
            if ((n3 & 8) != 0) {
                slot2.value = object;
                if (n2 != 8) {
                    slot2.setAttributes(n3 & 0xFFFFFFF7);
                }
            }
            return true;
        }
        return slot.setValue(object, this, scriptable);
    }

    private Slot findAttributeSlot(String string, int n, int n2) {
        Slot slot = this.getSlot(string, n, n2);
        if (slot == null) {
            String string2 = string != null ? string : Integer.toString(n);
            throw Context.reportRuntimeError1("msg.prop.not.found", string2);
        }
        return slot;
    }

    private static Slot unwrapSlot(Slot slot) {
        return slot instanceof RelinkedSlot ? ((RelinkedSlot)slot).slot : slot;
    }

    private Slot getSlot(String string, int n, int n2) {
        int n3;
        Slot[] slotArray = this.slots;
        if (slotArray == null && n2 == 1) {
            return null;
        }
        int n4 = n3 = string != null ? string.hashCode() : n;
        if (slotArray != null) {
            int n5 = ScriptableObject.getSlotIndex(slotArray.length, n3);
            Slot slot = slotArray[n5];
            while (slot != null) {
                String string2 = slot.name;
                if (n3 == slot.indexOrHash && (string2 == string || string != null && string.equals(string2))) break;
                slot = slot.next;
            }
            switch (n2) {
                case 1: {
                    return slot;
                }
                case 2: 
                case 3: {
                    if (slot == null) break;
                    return slot;
                }
                case 4: {
                    slot = ScriptableObject.unwrapSlot(slot);
                    if (!(slot instanceof GetterSlot)) break;
                    return slot;
                }
                case 5: {
                    slot = ScriptableObject.unwrapSlot(slot);
                    if (slot instanceof GetterSlot) break;
                    return slot;
                }
            }
        }
        return this.createSlot(string, n3, n2);
    }

    private synchronized Slot createSlot(String string, int n, int n2) {
        Slot slot;
        int n3;
        Slot[] slotArray = this.slots;
        if (this.count == 0) {
            slotArray = new Slot[4];
            this.slots = slotArray;
            n3 = ScriptableObject.getSlotIndex(slotArray.length, n);
        } else {
            Slot slot2;
            int n4 = slotArray.length;
            n3 = ScriptableObject.getSlotIndex(n4, n);
            Slot slot3 = slot2 = slotArray[n3];
            while (!(slot3 == null || slot3.indexOrHash == n && (slot3.name == string || string != null && string.equals(slot3.name)))) {
                slot2 = slot3;
                slot3 = slot3.next;
            }
            if (slot3 != null) {
                Slot slot4;
                Slot slot5 = ScriptableObject.unwrapSlot(slot3);
                if (n2 == 4 && !(slot5 instanceof GetterSlot)) {
                    slot4 = new GetterSlot(string, n, slot5.getAttributes());
                } else if (n2 == 5 && slot5 instanceof GetterSlot) {
                    slot4 = new Slot(string, n, slot5.getAttributes());
                } else {
                    if (n2 == 3) {
                        return null;
                    }
                    return slot5;
                }
                slot4.value = slot5.value;
                slot4.next = slot3.next;
                if (this.lastAdded != null) {
                    this.lastAdded.orderedNext = slot4;
                }
                if (this.firstAdded == null) {
                    this.firstAdded = slot4;
                }
                this.lastAdded = slot4;
                if (slot2 == slot3) {
                    slotArray[n3] = slot4;
                } else {
                    slot2.next = slot4;
                }
                slot3.markDeleted();
                return slot4;
            }
            if (4 * (this.count + 1) > 3 * slotArray.length) {
                slotArray = new Slot[slotArray.length * 2];
                ScriptableObject.copyTable(this.slots, slotArray, this.count);
                this.slots = slotArray;
                n3 = ScriptableObject.getSlotIndex(slotArray.length, n);
            }
        }
        Slot slot6 = slot = n2 == 4 ? new GetterSlot(string, n, 0) : new Slot(string, n, 0);
        if (n2 == 3) {
            slot.setAttributes(13);
        }
        ++this.count;
        if (this.lastAdded != null) {
            this.lastAdded.orderedNext = slot;
        }
        if (this.firstAdded == null) {
            this.firstAdded = slot;
        }
        this.lastAdded = slot;
        ScriptableObject.addKnownAbsentSlot(slotArray, slot, n3);
        return slot;
    }

    private synchronized void removeSlot(String string, int n) {
        int n2 = string != null ? string.hashCode() : n;
        Slot[] slotArray = this.slots;
        if (this.count != 0) {
            Slot slot;
            int n3 = slotArray.length;
            int n4 = ScriptableObject.getSlotIndex(n3, n2);
            Slot slot2 = slot = slotArray[n4];
            while (!(slot2 == null || slot2.indexOrHash == n2 && (slot2.name == string || string != null && string.equals(slot2.name)))) {
                slot = slot2;
                slot2 = slot2.next;
            }
            if (slot2 != null && (slot2.getAttributes() & 4) == 0) {
                --this.count;
                if (slot == slot2) {
                    slotArray[n4] = slot2.next;
                } else {
                    slot.next = slot2.next;
                }
                Slot slot3 = ScriptableObject.unwrapSlot(slot2);
                if (slot3 == this.firstAdded) {
                    slot = null;
                    this.firstAdded = slot3.orderedNext;
                } else {
                    slot = this.firstAdded;
                    while (slot.orderedNext != slot3) {
                        slot = slot.orderedNext;
                    }
                    slot.orderedNext = slot3.orderedNext;
                }
                if (slot3 == this.lastAdded) {
                    this.lastAdded = slot;
                }
                slot2.markDeleted();
            }
        }
    }

    private static int getSlotIndex(int n, int n2) {
        return n2 & n - 1;
    }

    private static void copyTable(Slot[] slotArray, Slot[] slotArray2, int n) {
        if (n == 0) {
            throw Kit.codeBug();
        }
        int n2 = slotArray2.length;
        int n3 = slotArray.length;
        block0: while (true) {
            Slot slot = slotArray[--n3];
            do {
                if (slot == null) continue block0;
                int n4 = ScriptableObject.getSlotIndex(n2, slot.indexOrHash);
                Slot slot2 = slot.next == null ? slot : new RelinkedSlot(slot);
                ScriptableObject.addKnownAbsentSlot(slotArray2, slot2, n4);
                slot = slot.next;
            } while (--n != 0);
            break;
        }
    }

    private static void addKnownAbsentSlot(Slot[] slotArray, Slot slot, int n) {
        if (slotArray[n] == null) {
            slotArray[n] = slot;
        } else {
            Slot slot2 = slotArray[n];
            Slot slot3 = slot2.next;
            while (slot3 != null) {
                slot2 = slot3;
                slot3 = slot2.next;
            }
            slot2.next = slot;
        }
    }

    Object[] getIds(boolean bl) {
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        int n2;
        Slot[] slotArray = this.slots;
        int n3 = n2 = this.externalData == null ? 0 : this.externalData.getArrayLength();
        if (n2 == 0) {
            objectArray2 = ScriptRuntime.emptyArgs;
        } else {
            objectArray2 = new Object[n2];
            for (n = 0; n < n2; ++n) {
                objectArray2[n] = n;
            }
        }
        if (slotArray == null) {
            return objectArray2;
        }
        n = n2;
        Slot slot = this.firstAdded;
        while (slot != null && slot.wasDeleted) {
            slot = slot.orderedNext;
        }
        while (slot != null) {
            if (bl || (slot.getAttributes() & 2) == 0) {
                if (n == n2) {
                    objectArray = objectArray2;
                    objectArray2 = new Object[slotArray.length + n2];
                    if (objectArray != null) {
                        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
                    }
                }
                objectArray2[n++] = slot.name != null ? slot.name : Integer.valueOf(slot.indexOrHash);
            }
            slot = slot.orderedNext;
            while (slot != null && slot.wasDeleted) {
                slot = slot.orderedNext;
            }
        }
        if (n == objectArray2.length + n2) {
            return objectArray2;
        }
        objectArray = new Object[n];
        System.arraycopy(objectArray2, 0, objectArray, 0, n);
        return objectArray;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.count;
        if (n < 0) {
            n ^= 0xFFFFFFFF;
        }
        if (n == 0) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.slots.length);
            Slot slot = this.firstAdded;
            while (slot != null && slot.wasDeleted) {
                slot = slot.orderedNext;
            }
            this.firstAdded = slot;
            while (slot != null) {
                objectOutputStream.writeObject(slot);
                Slot slot2 = slot.orderedNext;
                while (slot2 != null && slot2.wasDeleted) {
                    slot2 = slot2.orderedNext;
                }
                slot.orderedNext = slot2;
                slot = slot2;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n != 0) {
            int n2;
            if ((n & n - 1) != 0) {
                if (n > 0x40000000) {
                    throw new RuntimeException("Property table overflow");
                }
                for (n2 = 4; n2 < n; n2 <<= 1) {
                }
                n = n2;
            }
            this.slots = new Slot[n];
            n2 = this.count;
            if (n2 < 0) {
                n2 ^= 0xFFFFFFFF;
            }
            Slot slot = null;
            for (int i = 0; i != n2; ++i) {
                this.lastAdded = (Slot)objectInputStream.readObject();
                if (i == 0) {
                    this.firstAdded = this.lastAdded;
                } else {
                    slot.orderedNext = this.lastAdded;
                }
                int n3 = ScriptableObject.getSlotIndex(n, this.lastAdded.indexOrHash);
                ScriptableObject.addKnownAbsentSlot(this.slots, this.lastAdded, n3);
                slot = this.lastAdded;
            }
        }
    }

    protected ScriptableObject getOwnPropertyDescriptor(Context context, Object object) {
        Slot slot = this.getSlot(context, object, 1);
        if (slot == null) {
            return null;
        }
        Scriptable scriptable = this.getParentScope();
        return slot.getPropertyDescriptor(context, scriptable == null ? this : scriptable);
    }

    protected Slot getSlot(Context context, Object object, int n) {
        String string = ScriptRuntime.toStringIdOrIndex(context, object);
        if (string == null) {
            return this.getSlot((String)null, ScriptRuntime.lastIndexResult(context), n);
        }
        return this.getSlot(string, 0, n);
    }

    public int size() {
        return this.count < 0 ? ~this.count : this.count;
    }

    public boolean isEmpty() {
        return this.count == 0 || this.count == -1;
    }

    public Object get(Object object) {
        Object object2 = null;
        if (object instanceof String) {
            object2 = this.get((String)object, (Scriptable)this);
        } else if (object instanceof Number) {
            object2 = this.get(((Number)object).intValue(), (Scriptable)this);
        }
        if (object2 == Scriptable.NOT_FOUND || object2 == Undefined.instance) {
            return null;
        }
        if (object2 instanceof Wrapper) {
            return ((Wrapper)object2).unwrap();
        }
        return object2;
    }

    static {
        try {
            GET_ARRAY_LENGTH = ScriptableObject.class.getMethod("getExternalArrayLength", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    private static final class GetterSlot
    extends Slot {
        static final long serialVersionUID = -4900574849788797588L;
        Object getter;
        Object setter;

        GetterSlot(String string, int n, int n2) {
            super(string, n, n2);
        }

        @Override
        ScriptableObject getPropertyDescriptor(Context context, Scriptable scriptable) {
            int n = this.getAttributes();
            NativeObject nativeObject = new NativeObject();
            ScriptRuntime.setBuiltinProtoAndParent(nativeObject, scriptable, TopLevel.Builtins.Object);
            nativeObject.defineProperty("enumerable", (n & 2) == 0, 0);
            nativeObject.defineProperty("configurable", (n & 4) == 0, 0);
            if (this.getter != null) {
                nativeObject.defineProperty("get", this.getter, 0);
            }
            if (this.setter != null) {
                nativeObject.defineProperty("set", this.setter, 0);
            }
            return nativeObject;
        }

        @Override
        boolean setValue(Object object, Scriptable scriptable, Scriptable scriptable2) {
            if (this.setter == null) {
                if (this.getter != null) {
                    if (Context.getContext().hasFeature(11)) {
                        throw ScriptRuntime.typeError1("msg.set.prop.no.setter", this.name);
                    }
                    return true;
                }
            } else {
                Context context = Context.getContext();
                if (this.setter instanceof MemberBox) {
                    Object[] objectArray;
                    Object object2;
                    MemberBox memberBox = (MemberBox)this.setter;
                    Class<?>[] classArray = memberBox.argTypes;
                    Class<?> clazz = classArray[classArray.length - 1];
                    int n = FunctionObject.getTypeTag(clazz);
                    Object object3 = FunctionObject.convertArg(context, scriptable2, object, n);
                    if (memberBox.delegateTo == null) {
                        object2 = scriptable2;
                        objectArray = new Object[]{object3};
                    } else {
                        object2 = memberBox.delegateTo;
                        objectArray = new Object[]{scriptable2, object3};
                    }
                    memberBox.invoke(object2, objectArray);
                } else if (this.setter instanceof Function) {
                    Function function = (Function)this.setter;
                    function.call(context, function.getParentScope(), scriptable2, new Object[]{object});
                }
                return true;
            }
            return super.setValue(object, scriptable, scriptable2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Object getValue(Scriptable scriptable) {
            Object object;
            if (this.getter != null) {
                if (this.getter instanceof MemberBox) {
                    Object[] objectArray;
                    Object object2;
                    MemberBox memberBox = (MemberBox)this.getter;
                    if (memberBox.delegateTo == null) {
                        object2 = scriptable;
                        objectArray = ScriptRuntime.emptyArgs;
                    } else {
                        object2 = memberBox.delegateTo;
                        objectArray = new Object[]{scriptable};
                    }
                    return memberBox.invoke(object2, objectArray);
                }
                if (this.getter instanceof Function) {
                    Function function = (Function)this.getter;
                    Context context = Context.getContext();
                    return function.call(context, function.getParentScope(), scriptable, ScriptRuntime.emptyArgs);
                }
            }
            if ((object = this.value) instanceof LazilyLoadedCtor) {
                LazilyLoadedCtor lazilyLoadedCtor = (LazilyLoadedCtor)object;
                try {
                    lazilyLoadedCtor.init();
                }
                finally {
                    this.value = object = lazilyLoadedCtor.getValue();
                }
            }
            return object;
        }

        @Override
        void markDeleted() {
            super.markDeleted();
            this.getter = null;
            this.setter = null;
        }
    }

    private static class RelinkedSlot
    extends Slot {
        final Slot slot;

        RelinkedSlot(Slot slot) {
            super(slot.name, slot.indexOrHash, slot.attributes);
            this.slot = ScriptableObject.unwrapSlot(slot);
        }

        @Override
        boolean setValue(Object object, Scriptable scriptable, Scriptable scriptable2) {
            return this.slot.setValue(object, scriptable, scriptable2);
        }

        @Override
        Object getValue(Scriptable scriptable) {
            return this.slot.getValue(scriptable);
        }

        @Override
        ScriptableObject getPropertyDescriptor(Context context, Scriptable scriptable) {
            return this.slot.getPropertyDescriptor(context, scriptable);
        }

        @Override
        int getAttributes() {
            return this.slot.getAttributes();
        }

        @Override
        void setAttributes(int n) {
            this.slot.setAttributes(n);
        }

        @Override
        void markDeleted() {
            super.markDeleted();
            this.slot.markDeleted();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.slot);
        }
    }

    private static class Slot
    implements Serializable {
        private static final long serialVersionUID = -6090581677123995491L;
        String name;
        int indexOrHash;
        private volatile short attributes;
        volatile transient boolean wasDeleted;
        volatile Object value;
        transient Slot next;
        volatile transient Slot orderedNext;

        Slot(String string, int n, int n2) {
            this.name = string;
            this.indexOrHash = n;
            this.attributes = (short)n2;
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.name != null) {
                this.indexOrHash = this.name.hashCode();
            }
        }

        boolean setValue(Object object, Scriptable scriptable, Scriptable scriptable2) {
            if ((this.attributes & 1) != 0) {
                return true;
            }
            if (scriptable == scriptable2) {
                this.value = object;
                return true;
            }
            return false;
        }

        Object getValue(Scriptable scriptable) {
            return this.value;
        }

        int getAttributes() {
            return this.attributes;
        }

        synchronized void setAttributes(int n) {
            ScriptableObject.checkValidAttributes(n);
            this.attributes = (short)n;
        }

        void markDeleted() {
            this.wasDeleted = true;
            this.value = null;
            this.name = null;
        }

        ScriptableObject getPropertyDescriptor(Context context, Scriptable scriptable) {
            return ScriptableObject.buildDataDescriptor(scriptable, this.value, this.attributes);
        }
    }
}

