/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;

public abstract class NativeArrayBufferView
extends IdScriptableObject {
    private static final long serialVersionUID = 6884475582973958419L;
    protected final NativeArrayBuffer arrayBuffer;
    protected final int offset;
    protected final int byteLength;
    private static final int Id_buffer = 1;
    private static final int Id_byteOffset = 2;
    private static final int Id_byteLength = 3;
    private static final int MAX_INSTANCE_ID = 3;

    public NativeArrayBufferView() {
        this.arrayBuffer = NativeArrayBuffer.EMPTY_BUFFER;
        this.offset = 0;
        this.byteLength = 0;
    }

    protected NativeArrayBufferView(NativeArrayBuffer nativeArrayBuffer, int n, int n2) {
        this.offset = n;
        this.byteLength = n2;
        this.arrayBuffer = nativeArrayBuffer;
    }

    public NativeArrayBuffer getBuffer() {
        return this.arrayBuffer;
    }

    public int getByteOffset() {
        return this.offset;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    protected static boolean isArg(Object[] objectArray, int n) {
        return objectArray.length > n && !Undefined.instance.equals(objectArray[n]);
    }

    @Override
    protected int getMaxInstanceId() {
        return 3;
    }

    @Override
    protected String getInstanceIdName(int n) {
        switch (n) {
            case 1: {
                return "buffer";
            }
            case 2: {
                return "byteOffset";
            }
            case 3: {
                return "byteLength";
            }
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        switch (n) {
            case 1: {
                return this.arrayBuffer;
            }
            case 2: {
                return ScriptRuntime.wrapInt(this.offset);
            }
            case 3: {
                return ScriptRuntime.wrapInt(this.byteLength);
            }
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        int n = 0;
        String string2 = null;
        int n2 = string.length();
        if (n2 == 6) {
            string2 = "buffer";
            n = 1;
        } else if (n2 == 10) {
            char c = string.charAt(4);
            if (c == 'L') {
                string2 = "byteLength";
                n = 3;
            } else if (c == 'O') {
                string2 = "byteOffset";
                n = 2;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        if (n == 0) {
            return super.findInstanceIdInfo(string);
        }
        return NativeArrayBufferView.instanceIdInfo(5, n);
    }
}

