/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.ToolBarEditDialog;
import org.gjt.sp.util.StandardUtilities;

public class ToolBarOptionPane
extends AbstractOptionPane {
    private JCheckBox showToolbar;
    private DefaultListModel listModel;
    private JList list;
    private RolloverButton add;
    private RolloverButton remove;
    private RolloverButton moveUp;
    private RolloverButton moveDown;
    private RolloverButton edit;
    private RolloverButton reset;
    private DefaultComboBoxModel iconList;

    public ToolBarOptionPane() {
        super("toolbar");
    }

    @Override
    protected void _init() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        this.showToolbar = new JCheckBox(jEdit.getProperty("options.toolbar.showToolbar"));
        this.showToolbar.setSelected(jEdit.getBooleanProperty("view.showToolbar"));
        jPanel.add(this.showToolbar);
        jPanel.add(new JLabel(jEdit.getProperty("options.toolbar.caption")));
        this.add("North", jPanel);
        this.listModel = new DefaultListModel();
        this.reloadButtonList(jEdit.getProperty("view.toolbar"));
        this.list = new JList(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(new ListHandler());
        this.list.setCellRenderer(new ButtonCellRenderer());
        this.add("Center", new JScrollPane(this.list));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(3, 0, 0, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        ActionHandler actionHandler = new ActionHandler();
        this.add = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.toolbar.add.icon")));
        this.add.setToolTipText(jEdit.getProperty("options.toolbar.add"));
        this.add.addActionListener(actionHandler);
        jPanel2.add(this.add);
        jPanel2.add(Box.createHorizontalStrut(6));
        this.remove = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.toolbar.remove.icon")));
        this.remove.setToolTipText(jEdit.getProperty("options.toolbar.remove"));
        this.remove.addActionListener(actionHandler);
        jPanel2.add(this.remove);
        jPanel2.add(Box.createHorizontalStrut(6));
        this.moveUp = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.toolbar.moveUp.icon")));
        this.moveUp.setToolTipText(jEdit.getProperty("options.toolbar.moveUp"));
        this.moveUp.addActionListener(actionHandler);
        jPanel2.add(this.moveUp);
        jPanel2.add(Box.createHorizontalStrut(6));
        this.moveDown = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.toolbar.moveDown.icon")));
        this.moveDown.setToolTipText(jEdit.getProperty("options.toolbar.moveDown"));
        this.moveDown.addActionListener(actionHandler);
        jPanel2.add(this.moveDown);
        jPanel2.add(Box.createHorizontalStrut(6));
        this.edit = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.toolbar.edit.icon")));
        this.edit.setToolTipText(jEdit.getProperty("options.toolbar.edit"));
        this.edit.addActionListener(actionHandler);
        jPanel2.add(this.edit);
        jPanel2.add(Box.createGlue());
        this.reset = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("options.toolbar.reset.icon")));
        this.reset.setToolTipText(jEdit.getProperty("options.toolbar.reset"));
        this.reset.addActionListener(actionHandler);
        jPanel2.add(this.reset);
        this.updateButtons();
        this.add("South", jPanel2);
        this.iconList = new DefaultComboBoxModel();
        StringTokenizer stringTokenizer = new StringTokenizer(jEdit.getProperty("icons"));
        while (stringTokenizer.hasMoreElements()) {
            String string = stringTokenizer.nextToken();
            this.iconList.addElement(new IconListEntry(GUIUtilities.loadIcon(string), string));
        }
    }

    @Override
    protected void _save() {
        jEdit.setBooleanProperty("view.showToolbar", this.showToolbar.isSelected());
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (i != 0) {
                stringBuilder.append(' ');
            }
            Button button = (Button)this.listModel.elementAt(i);
            stringBuilder.append(button.actionName);
            jEdit.setProperty(button.actionName + ".icon", button.iconName);
        }
        jEdit.setProperty("view.toolbar", stringBuilder.toString());
    }

    private void updateButtons() {
        int n = this.list.getSelectedIndex();
        this.remove.setEnabled(n != -1 && this.listModel.getSize() != 0);
        this.moveUp.setEnabled(n > 0);
        this.moveDown.setEnabled(n != -1 && n != this.listModel.getSize() - 1);
        this.edit.setEnabled(n != -1);
    }

    private void reloadButtonList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.listModel.clear();
        while (stringTokenizer.hasMoreTokens()) {
            Icon icon;
            String string2;
            String string3;
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("-")) {
                this.listModel.addElement(new Button("-", null, null, "-"));
                continue;
            }
            EditAction editAction = jEdit.getAction(string4);
            if (editAction == null || (string3 = editAction.getLabel()) == null) continue;
            if (string4.equals("-")) {
                string2 = null;
                icon = null;
            } else {
                string2 = jEdit.getProperty(string4 + ".icon");
                if (string2 == null) {
                    icon = GUIUtilities.loadIcon(jEdit.getProperty("broken-image.icon"));
                } else {
                    icon = GUIUtilities.loadIcon(string2);
                    if (icon == null) {
                        icon = GUIUtilities.loadIcon(jEdit.getProperty("broken-image.icon"));
                    }
                }
            }
            this.listModel.addElement(new Button(string4, string2, icon, string3));
        }
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ToolBarOptionPane.this.updateButtons();
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == ToolBarOptionPane.this.add) {
                ToolBarEditDialog toolBarEditDialog = new ToolBarEditDialog(ToolBarOptionPane.this, ToolBarOptionPane.this.iconList, null);
                Button button = toolBarEditDialog.getSelection();
                if (button == null) {
                    return;
                }
                int n = ToolBarOptionPane.this.list.getSelectedIndex();
                n = n == -1 ? ToolBarOptionPane.this.listModel.getSize() : ++n;
                ToolBarOptionPane.this.listModel.insertElementAt(button, n);
                ToolBarOptionPane.this.list.setSelectedIndex(n);
                ToolBarOptionPane.this.list.ensureIndexIsVisible(n);
            } else if (object == ToolBarOptionPane.this.remove) {
                int n = ToolBarOptionPane.this.list.getSelectedIndex();
                ToolBarOptionPane.this.listModel.removeElementAt(n);
                if (ToolBarOptionPane.this.listModel.getSize() != 0) {
                    if (ToolBarOptionPane.this.listModel.getSize() == n) {
                        ToolBarOptionPane.this.list.setSelectedIndex(n - 1);
                    } else {
                        ToolBarOptionPane.this.list.setSelectedIndex(n);
                    }
                }
                ToolBarOptionPane.this.updateButtons();
            } else if (object == ToolBarOptionPane.this.moveUp) {
                int n = ToolBarOptionPane.this.list.getSelectedIndex();
                Object e = ToolBarOptionPane.this.list.getSelectedValue();
                ToolBarOptionPane.this.listModel.removeElementAt(n);
                ToolBarOptionPane.this.listModel.insertElementAt(e, n - 1);
                ToolBarOptionPane.this.list.setSelectedIndex(n - 1);
                ToolBarOptionPane.this.list.ensureIndexIsVisible(n - 1);
            } else if (object == ToolBarOptionPane.this.moveDown) {
                int n = ToolBarOptionPane.this.list.getSelectedIndex();
                Object e = ToolBarOptionPane.this.list.getSelectedValue();
                ToolBarOptionPane.this.listModel.removeElementAt(n);
                ToolBarOptionPane.this.listModel.insertElementAt(e, n + 1);
                ToolBarOptionPane.this.list.setSelectedIndex(n + 1);
                ToolBarOptionPane.this.list.ensureIndexIsVisible(n + 1);
            } else if (object == ToolBarOptionPane.this.edit) {
                ToolBarEditDialog toolBarEditDialog = new ToolBarEditDialog(ToolBarOptionPane.this, ToolBarOptionPane.this.iconList, (Button)ToolBarOptionPane.this.list.getSelectedValue());
                Button button = toolBarEditDialog.getSelection();
                if (button == null) {
                    return;
                }
                int n = ToolBarOptionPane.this.list.getSelectedIndex();
                ToolBarOptionPane.this.listModel.setElementAt(button, n);
                ToolBarOptionPane.this.list.setSelectedIndex(n);
                ToolBarOptionPane.this.list.ensureIndexIsVisible(n);
            } else if (object == ToolBarOptionPane.this.reset) {
                String string = "options.toolbar.reset.dialog";
                int n = GUIUtilities.confirm(ToolBarOptionPane.this.list, string, null, 0, 2);
                if (n == 0) {
                    String string2 = jEdit.getProperty("view.toolbar");
                    jEdit.resetProperty("view.toolbar");
                    String string3 = jEdit.getProperty("view.toolbar");
                    jEdit.setProperty("view.toolbar", string2);
                    ToolBarOptionPane.this.reloadButtonList(string3);
                    ToolBarOptionPane.this.list.setSelectedIndex(0);
                    ToolBarOptionPane.this.list.ensureIndexIsVisible(0);
                    ToolBarOptionPane.this.updateButtons();
                }
            }
        }
    }

    static class IconCellRenderer
    extends DefaultListCellRenderer {
        IconCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            IconListEntry iconListEntry = (IconListEntry)object;
            this.setIcon(iconListEntry.icon);
            return this;
        }
    }

    static class ButtonCellRenderer
    extends DefaultListCellRenderer {
        ButtonCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Button button = (Button)object;
            this.setIcon(button.icon);
            return this;
        }
    }

    static class IconListEntry {
        Icon icon;
        String name;

        IconListEntry(Icon icon, String string) {
            this.icon = icon;
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    static class Button {
        String actionName;
        String iconName;
        Icon icon;
        String label;

        Button(String string, String string2, Icon icon, String string3) {
            this.actionName = string;
            this.iconName = string2;
            this.icon = icon;
            this.label = GUIUtilities.prettifyMenuLabel(string3);
        }

        public String toString() {
            return this.label;
        }

        public boolean equals(Object object) {
            if (object instanceof Button) {
                return ((Button)object).actionName.equals(this.actionName);
            }
            return false;
        }
    }

    static class ButtonCompare
    implements Comparator<Button> {
        ButtonCompare() {
        }

        @Override
        public int compare(Button button, Button button2) {
            return StandardUtilities.compareStrings(button.label, button2.label, true);
        }
    }
}

