/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.dialogs.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.layer.LayerListTransferHandler;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class DuplicateAction
extends AbstractAction
implements IEnabledStateUpdating {
    private transient Layer layer;
    private final LayerListDialog.LayerListModel model;

    public DuplicateAction(Layer layer, LayerListDialog.LayerListModel layerListModel) {
        this(layerListModel);
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.layer = layer;
        this.updateEnabledState();
    }

    public DuplicateAction(LayerListDialog.LayerListModel layerListModel) {
        this.model = layerListModel;
        this.putValue("Name", I18n.tr("Duplicate", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs", "duplicatelayer"));
        this.putValue("ShortDescription", I18n.tr("Duplicate this layer", new Object[0]));
        this.putValue("help", HelpUtil.ht("/Dialog/LayerList#DuplicateLayer"));
        this.updateEnabledState();
    }

    private static void duplicate(Layer layer) {
        if (layer instanceof OsmDataLayer) {
            String string = LayerListTransferHandler.suggestNewLayerName(layer.getName(), Main.getLayerManager().getLayers());
            OsmDataLayer osmDataLayer = (OsmDataLayer)layer;
            Main.getLayerManager().addLayer(new OsmDataLayer(new DataSet(osmDataLayer.data), string, null));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.layer != null) {
            DuplicateAction.duplicate(this.layer);
        } else {
            DuplicateAction.duplicate(this.model.getSelectedLayers().get(0));
        }
    }

    @Override
    public void updateEnabledState() {
        if (this.layer == null) {
            if (this.model.getSelectedLayers().size() == 1) {
                this.setEnabled(this.model.getSelectedLayers().get(0) instanceof OsmDataLayer);
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(this.layer instanceof OsmDataLayer);
        }
    }
}

