/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentHashMap;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyEncoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.encoding.EncodingManager;
import org.jruby.truffle.core.rope.AsciiOnlyLeafRope;
import org.jruby.truffle.core.rope.BytesVisitor;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.ConcatRope;
import org.jruby.truffle.core.rope.InvalidLeafRope;
import org.jruby.truffle.core.rope.LazyIntRope;
import org.jruby.truffle.core.rope.LazyRope;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.RepeatingRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.rope.SubstringRope;
import org.jruby.truffle.core.rope.ValidLeafRope;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.util.StringUtils;
import org.jruby.util.ByteList;
import org.jruby.util.Memo;
import org.jruby.util.StringSupport;
import org.jruby.util.io.EncodingUtils;

public class RopeOperations {
    private static final ConcurrentHashMap<Encoding, Charset> encodingToCharsetMap = new ConcurrentHashMap();

    public static LeafRope create(byte[] bytes, Encoding encoding, CodeRange codeRange) {
        if (bytes.length == 1) {
            int index = bytes[0] & 0xFF;
            if (encoding == UTF8Encoding.INSTANCE) {
                return RopeConstants.UTF8_SINGLE_BYTE_ROPES[index];
            }
            if (encoding == USASCIIEncoding.INSTANCE) {
                return RopeConstants.US_ASCII_SINGLE_BYTE_ROPES[index];
            }
            if (encoding == ASCIIEncoding.INSTANCE) {
                return RopeConstants.ASCII_8BIT_SINGLE_BYTE_ROPES[index];
            }
        }
        int characterLength = -1;
        if (codeRange == CodeRange.CR_UNKNOWN) {
            long packedLengthAndCodeRange = RopeOperations.calculateCodeRangeAndLength(encoding, bytes, 0, bytes.length);
            codeRange = CodeRange.fromInt(StringSupport.unpackArg((long)packedLengthAndCodeRange));
            characterLength = StringSupport.unpackResult((long)packedLengthAndCodeRange);
        } else if (codeRange == CodeRange.CR_VALID) {
            characterLength = RopeOperations.strLength(encoding, bytes, 0, bytes.length);
        }
        switch (codeRange) {
            case CR_7BIT: {
                return new AsciiOnlyLeafRope(bytes, encoding);
            }
            case CR_VALID: {
                return new ValidLeafRope(bytes, encoding, characterLength);
            }
            case CR_BROKEN: {
                return new InvalidLeafRope(bytes, encoding);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new RuntimeException(StringUtils.format("Unknown code range type: %d", new Object[]{codeRange}));
    }

    public static Rope withEncodingVerySlow(Rope originalRope, Encoding newEncoding, CodeRange newCodeRange) {
        if (originalRope.getEncoding() == newEncoding && originalRope.getCodeRange() == newCodeRange) {
            return originalRope;
        }
        if (originalRope.getCodeRange() == newCodeRange) {
            return originalRope.withEncoding(newEncoding, newCodeRange);
        }
        if (originalRope.getCodeRange() == CodeRange.CR_7BIT && newEncoding.isAsciiCompatible()) {
            return originalRope.withEncoding(newEncoding, CodeRange.CR_7BIT);
        }
        return RopeOperations.create(originalRope.getBytes(), newEncoding, newCodeRange);
    }

    public static Rope withEncodingVerySlow(Rope originalRope, Encoding newEncoding) {
        return RopeOperations.withEncodingVerySlow(originalRope, newEncoding, originalRope.getCodeRange());
    }

    @CompilerDirectives.TruffleBoundary
    public static String decodeUTF8(Rope rope) {
        return RopeOperations.decodeUTF8(rope.getBytes(), 0, rope.byteLength());
    }

    @CompilerDirectives.TruffleBoundary
    public static String decodeUTF8(byte[] bytes, int offset, int byteLength) {
        return RubyEncoding.decodeUTF8((byte[])bytes, (int)offset, (int)byteLength);
    }

    @CompilerDirectives.TruffleBoundary
    public static String decodeRope(Rope value) {
        value = RopeOperations.flatten(value);
        int begin = 0;
        int length = value.byteLength();
        Encoding encoding = value.getEncoding();
        if (encoding == UTF8Encoding.INSTANCE) {
            return RubyEncoding.decodeUTF8((byte[])value.getBytes(), (int)begin, (int)length);
        }
        Charset charset = encodingToCharsetMap.computeIfAbsent(encoding, EncodingManager::charsetForEncoding);
        return RubyEncoding.decode((byte[])value.getBytes(), (int)begin, (int)length, (Charset)charset);
    }

    @CompilerDirectives.TruffleBoundary
    public static Encoding STR_ENC_GET(Rope rope) {
        return EncodingUtils.getActualEncoding((Encoding)rope.getEncoding(), (byte[])rope.getBytes(), (int)0, (int)rope.byteLength());
    }

    @CompilerDirectives.TruffleBoundary
    public static long calculateCodeRangeAndLength(Encoding encoding, byte[] bytes, int start, int end) {
        if (bytes.length == 0) {
            return StringSupport.pack((int)0, (int)(encoding.isAsciiCompatible() ? CodeRange.CR_7BIT.toInt() : CodeRange.CR_VALID.toInt()));
        }
        if (encoding == ASCIIEncoding.INSTANCE) {
            return RopeOperations.strLengthWithCodeRangeBinaryString(bytes, start, end);
        }
        if (encoding.isAsciiCompatible()) {
            return StringSupport.strLengthWithCodeRangeAsciiCompatible((Encoding)encoding, (byte[])bytes, (int)start, (int)end);
        }
        return StringSupport.strLengthWithCodeRangeNonAsciiCompatible((Encoding)encoding, (byte[])bytes, (int)start, (int)end);
    }

    @CompilerDirectives.TruffleBoundary
    public static int strLength(Encoding enc, byte[] bytes, int p, int end) {
        return StringSupport.strLength((Encoding)enc, (byte[])bytes, (int)p, (int)end);
    }

    private static long strLengthWithCodeRangeBinaryString(byte[] bytes, int start, int end) {
        CodeRange codeRange = CodeRange.CR_7BIT;
        for (int i = start; i < end; ++i) {
            if (bytes[i] >= 0) continue;
            codeRange = CodeRange.CR_VALID;
            break;
        }
        return StringSupport.pack((int)(end - start), (int)codeRange.toInt());
    }

    public static LeafRope flatten(Rope rope) {
        if (rope instanceof LeafRope) {
            return (LeafRope)rope;
        }
        return RopeOperations.create(RopeOperations.flattenBytes(rope), rope.getEncoding(), rope.getCodeRange());
    }

    public static void visitBytes(Rope rope, BytesVisitor visitor) {
        RopeOperations.visitBytes(rope, visitor, 0, rope.byteLength());
    }

    @CompilerDirectives.TruffleBoundary
    public static void visitBytes(Rope rope, BytesVisitor visitor, int offset, int length) {
        visitor.accept(RopeOperations.flattenBytes(rope), offset, length);
    }

    @CompilerDirectives.TruffleBoundary
    public static byte[] extractRange(Rope rope, int offset, int length) {
        byte[] result = new byte[length];
        Memo resultPosition = new Memo((Object)0);
        RopeOperations.visitBytes(rope, (bytes, offset1, length1) -> {
            int resultPositionValue = (Integer)resultPosition.get();
            System.arraycopy(bytes, offset1, result, resultPositionValue, length1);
            resultPosition.set((Object)(resultPositionValue + length1));
        }, offset, length);
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static byte[] flattenBytes(Rope rope) {
        if (rope.getRawBytes() != null) {
            return rope.getRawBytes();
        }
        int bufferPosition = 0;
        int offset = 0;
        byte[] buffer = new byte[rope.byteLength()];
        ArrayDeque<Integer> substringLengths = new ArrayDeque<Integer>();
        ArrayDeque<Rope> workStack = new ArrayDeque<Rope>();
        workStack.push(rope);
        while (!workStack.isEmpty()) {
            Rope current = (Rope)workStack.pop();
            if (current.isEmpty()) continue;
            if (current instanceof LazyRope) {
                ((LazyRope)current).fulfill();
            }
            if (current.getRawBytes() != null) {
                if (substringLengths.isEmpty()) {
                    System.arraycopy(current.getRawBytes(), offset, buffer, bufferPosition, current.byteLength());
                    bufferPosition += current.byteLength();
                } else {
                    int bytesToCopy = (Integer)substringLengths.pop();
                    int currentBytesToCopy = bytesToCopy > current.byteLength() - offset ? current.byteLength() - offset : bytesToCopy;
                    System.arraycopy(current.getRawBytes(), offset, buffer, bufferPosition, currentBytesToCopy);
                    bufferPosition += currentBytesToCopy;
                    if ((bytesToCopy -= currentBytesToCopy) > 0) {
                        substringLengths.push(bytesToCopy);
                    }
                }
                offset = 0;
                continue;
            }
            if (current instanceof ConcatRope) {
                ConcatRope concatRope = (ConcatRope)current;
                if (substringLengths.isEmpty()) {
                    workStack.push(concatRope.getRight());
                    workStack.push(concatRope.getLeft());
                    continue;
                }
                int leftLength = concatRope.getLeft().byteLength();
                if (offset < leftLength) {
                    if (offset + (Integer)substringLengths.peek() > leftLength) {
                        workStack.push(concatRope.getRight());
                        workStack.push(concatRope.getLeft());
                        continue;
                    }
                    workStack.push(concatRope.getLeft());
                    continue;
                }
                offset -= leftLength;
                workStack.push(concatRope.getRight());
                continue;
            }
            if (current instanceof SubstringRope) {
                SubstringRope substringRope = (SubstringRope)current;
                offset += substringRope.getOffset();
                workStack.push(substringRope.getChild());
                if (substringLengths.isEmpty()) {
                    substringLengths.push(substringRope.byteLength());
                    continue;
                }
                int adjustedByteLength = substringRope.byteLength() - (offset - substringRope.getOffset());
                if ((Integer)substringLengths.peek() <= adjustedByteLength) continue;
                int bytesToCopy = (Integer)substringLengths.pop();
                substringLengths.push(bytesToCopy - adjustedByteLength);
                substringLengths.push(adjustedByteLength);
                continue;
            }
            if (current instanceof RepeatingRope) {
                RepeatingRope repeatingRope = (RepeatingRope)current;
                if (substringLengths.isEmpty()) {
                    for (int i = 0; i < repeatingRope.getTimes(); ++i) {
                        workStack.push(repeatingRope.getChild());
                    }
                    continue;
                }
                int bytesToCopy = (Integer)substringLengths.peek();
                int patternLength = repeatingRope.getChild().byteLength();
                int loopCount = (bytesToCopy + patternLength - 1) / patternLength;
                if ((offset %= repeatingRope.getChild().byteLength()) > 0 && (bytesToCopy - (patternLength - offset)) % patternLength > 0) {
                    ++loopCount;
                }
                LeafRope flattenedChild = RopeOperations.flatten(repeatingRope.getChild());
                for (int i = 0; i < loopCount; ++i) {
                    workStack.push(flattenedChild);
                }
                continue;
            }
            throw new UnsupportedOperationException("Don't know how to flatten rope of type: " + rope.getClass().getName());
        }
        return buffer;
    }

    public static int hashCodeForLeafRope(byte[] bytes, int startingHashCode, int offset, int length) {
        assert (offset <= bytes.length);
        assert (length <= bytes.length);
        int hashCode = startingHashCode;
        int endIndex = offset + length;
        for (int i = offset; i < endIndex; ++i) {
            hashCode = 31 * hashCode + bytes[i];
        }
        return hashCode;
    }

    @CompilerDirectives.TruffleBoundary
    public static int hashForRange(Rope rope, int startingHashCode, int offset, int length) {
        if (rope instanceof LeafRope) {
            return RopeOperations.hashCodeForLeafRope(rope.getBytes(), startingHashCode, offset, length);
        }
        if (rope instanceof SubstringRope) {
            SubstringRope substringRope = (SubstringRope)rope;
            return RopeOperations.hashForRange(substringRope.getChild(), startingHashCode, offset + substringRope.getOffset(), length);
        }
        if (rope instanceof ConcatRope) {
            ConcatRope concatRope = (ConcatRope)rope;
            Rope left = concatRope.getLeft();
            Rope right = concatRope.getRight();
            int hash = startingHashCode;
            int leftLength = left.byteLength();
            if (offset < leftLength) {
                if (offset + length > leftLength) {
                    int coveredByLeft = leftLength - offset;
                    hash = RopeOperations.hashForRange(left, hash, offset, coveredByLeft);
                    hash = RopeOperations.hashForRange(right, hash, 0, length - coveredByLeft);
                    return hash;
                }
                return RopeOperations.hashForRange(left, hash, offset, length);
            }
            return RopeOperations.hashForRange(right, hash, offset - leftLength, length);
        }
        if (rope instanceof RepeatingRope) {
            RepeatingRope repeatingRope = (RepeatingRope)rope;
            Rope child = repeatingRope.getChild();
            int remainingLength = length;
            int patternLength = child.byteLength();
            int loopCount = (length + patternLength - 1) / patternLength;
            if ((offset %= child.byteLength()) > 0 && (length - (patternLength - offset)) % patternLength > 0) {
                ++loopCount;
            }
            int hash = startingHashCode;
            for (int i = 0; i < loopCount; ++i) {
                hash = RopeOperations.hashForRange(child, hash, offset, remainingLength >= child.byteLength() ? child.byteLength() : remainingLength % child.byteLength());
                remainingLength = child.byteLength() - offset;
                offset = 0;
            }
            return hash;
        }
        if (rope instanceof LazyRope) {
            return RopeOperations.hashCodeForLeafRope(rope.getBytes(), startingHashCode, offset, length);
        }
        throw new RuntimeException("Hash code not supported for rope of type: " + rope.getClass().getName());
    }

    @CompilerDirectives.TruffleBoundary
    public static int cmp(Rope string, Rope other) {
        if (string == other) {
            return 0;
        }
        int size = string.byteLength();
        int len = Math.min(size, other.byteLength());
        int offset = -1;
        byte[] bytes = string.getBytes();
        byte[] otherBytes = other.getBytes();
        while (++offset < len && bytes[offset] == otherBytes[offset]) {
        }
        if (offset < len) {
            return (bytes[offset] & 0xFF) > (otherBytes[offset] & 0xFF) ? 1 : -1;
        }
        return size == other.byteLength() ? 0 : (size == len ? -1 : 1);
    }

    public static boolean areComparable(Rope rope, Rope other) {
        if (rope.getEncoding() == other.getEncoding() || rope.isEmpty() || other.isEmpty()) {
            return true;
        }
        return RopeOperations.areComparableViaCodeRange(rope, other);
    }

    public static boolean areComparableViaCodeRange(Rope string, Rope other) {
        CodeRange cr1 = string.getCodeRange();
        CodeRange cr2 = other.getCodeRange();
        if (cr1 == CodeRange.CR_7BIT && (cr2 == CodeRange.CR_7BIT || other.getEncoding().isAsciiCompatible())) {
            return true;
        }
        return cr2 == CodeRange.CR_7BIT && string.getEncoding().isAsciiCompatible();
    }

    public static ByteList getByteListReadOnly(Rope rope) {
        return new ByteList(rope.getBytes(), rope.getEncoding(), false);
    }

    public static ByteList toByteListCopy(Rope rope) {
        return new ByteList(rope.getBytes(), rope.getEncoding(), true);
    }

    @CompilerDirectives.TruffleBoundary
    public static Rope format(RubyContext context, Object ... values) {
        Rope rope = null;
        for (Object value : values) {
            Rope valueRope;
            if (value instanceof DynamicObject && RubyGuards.isRubyString(value)) {
                Rope stringRope = Layouts.STRING.getRope((DynamicObject)value);
                Encoding encoding = stringRope.getEncoding();
                valueRope = encoding == UTF8Encoding.INSTANCE || encoding == USASCIIEncoding.INSTANCE || encoding == ASCIIEncoding.INSTANCE ? stringRope : StringOperations.encodeRope(RopeOperations.decodeRope(stringRope), (Encoding)UTF8Encoding.INSTANCE);
            } else if (value instanceof Integer) {
                valueRope = new LazyIntRope((Integer)value);
            } else if (value instanceof String) {
                valueRope = context.getRopeTable().getRope((String)value);
            } else {
                throw new IllegalArgumentException();
            }
            if (rope == null) {
                rope = valueRope;
                continue;
            }
            if (valueRope == null) {
                throw new UnsupportedOperationException(value.getClass().toString());
            }
            rope = new ConcatRope(rope, valueRope, (Encoding)UTF8Encoding.INSTANCE, RopeOperations.commonCodeRange(rope.getCodeRange(), valueRope.getCodeRange()), rope.isSingleByteOptimizable() && valueRope.isSingleByteOptimizable(), Math.max(rope.depth(), valueRope.depth()) + 1);
        }
        if (rope == null) {
            rope = RopeConstants.EMPTY_UTF8_ROPE;
        }
        return rope;
    }

    private static CodeRange commonCodeRange(CodeRange first, CodeRange second) {
        if (first == second) {
            return first;
        }
        if (first == CodeRange.CR_BROKEN || second == CodeRange.CR_BROKEN) {
            return CodeRange.CR_BROKEN;
        }
        return CodeRange.CR_VALID;
    }

    @CompilerDirectives.TruffleBoundary
    public static int codePoint(RubyContext context, Rope rope, int start) {
        byte[] bytes = rope.getBytes();
        int p = start;
        int end = rope.byteLength();
        Encoding enc = rope.getEncoding();
        assert (p < end) : "empty string";
        int cl = StringSupport.preciseLength((Encoding)enc, (byte[])bytes, (int)p, (int)end);
        if (cl <= 0) {
            throw new RaiseException(context.getCoreExceptions().argumentError("invalid byte sequence in " + enc, null));
        }
        return enc.mbcToCode(bytes, p, end);
    }
}

