/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Instrumentable;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyBaseNode;
import org.jruby.truffle.language.RubyNodeWrapper;
import org.jruby.truffle.language.RubySourceSection;

@Instrumentable(factory=RubyNodeWrapper.class)
public abstract class RubyNode
extends RubyBaseNode {
    public RubyNode() {
    }

    public RubyNode(RubyContext context) {
        super(context);
    }

    public RubyNode(SourceSection sourceSection) {
        super(sourceSection);
    }

    public RubyNode(RubySourceSection sourceSection) {
        super(sourceSection);
    }

    public RubyNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public RubyNode(RubyContext context, RubySourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object execute(VirtualFrame var1);

    public void executeVoid(VirtualFrame frame) {
        this.execute(frame);
    }

    public Object isDefined(VirtualFrame frame) {
        return this.coreStrings().EXPRESSION.createInstance();
    }

    public NotProvided executeNotProvided(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof NotProvided) {
            return (NotProvided)value;
        }
        throw new UnexpectedResultException(value);
    }

    public boolean executeBoolean(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new UnexpectedResultException(value);
    }

    public int executeInteger(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    public long executeLong(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new UnexpectedResultException(value);
    }

    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new UnexpectedResultException(value);
    }

    public DynamicObject executeDynamicObject(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof DynamicObject) {
            return (DynamicObject)value;
        }
        throw new UnexpectedResultException(value);
    }

    public Object[] executeObjectArray(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value.getClass() == Object[].class) {
            return (Object[])value;
        }
        throw new UnexpectedResultException(value);
    }
}

