// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BOPAlgo_BuilderSolid_HeaderFile
#define _BOPAlgo_BuilderSolid_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <TopoDS_Solid.hxx>
#include <BOPAlgo_BuilderArea.hxx>
#include <BOPCol_BaseAllocator.hxx>
class TopoDS_Solid;


//! The algorithm to build solids from set of faces
class BOPAlgo_BuilderSolid  : public BOPAlgo_BuilderArea
{
public:

  DEFINE_STANDARD_ALLOC

  
  Standard_EXPORT BOPAlgo_BuilderSolid();
Standard_EXPORT virtual ~BOPAlgo_BuilderSolid();
  
  Standard_EXPORT BOPAlgo_BuilderSolid(const BOPCol_BaseAllocator& theAllocator);
  
  //! Sets the source solid <theSolid>
  Standard_EXPORT   void SetSolid (const TopoDS_Solid& theSolid) ;
  
  //! Returns the source solid
  Standard_EXPORT  const  TopoDS_Solid& Solid()  const;
  
  //! Performs the algorithm
  Standard_EXPORT virtual   void Perform() ;




protected:

  
  //! Collect the faces that
  //! a) are internal
  //! b) are the same and have different orientation
  Standard_EXPORT virtual   void PerformShapesToAvoid() ;
  
  //! Build draft shells
  //! a)myLoops - draft shells that consist of
  //! boundary faces
  //! b)myLoopsInternal - draft shells that contains
  //! inner faces
  Standard_EXPORT virtual   void PerformLoops() ;
  
  //! Build draft solids that contains boundary faces
  Standard_EXPORT virtual   void PerformAreas() ;
  
  //! Build finalized solids with internal shells
  Standard_EXPORT virtual   void PerformInternalShapes() ;


  TopoDS_Solid mySolid;


private:





};







#endif // _BOPAlgo_BuilderSolid_HeaderFile
