/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.MDIDesktopPane;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class WindowMenu
extends CommandMenu {
    private MDIDesktopPane desktop;
    private Command cascadeCommand;
    private Command tileCommand;

    public WindowMenu(String newText, MDIDesktopPane desktop, DrawingEditor editor) {
        super(newText);
        this.desktop = desktop;
        this.cascadeCommand = new AbstractCommand("Cascade", editor){

            public void execute() {
                WindowMenu.this.desktop.cascadeFrames();
            }

            public boolean isExecutable() {
                return super.isExecutable() && WindowMenu.this.desktop.getAllFrames().length > 0;
            }
        };
        this.tileCommand = new AbstractCommand("Tile", editor){

            public void execute() {
                WindowMenu.this.desktop.tileFrames();
            }

            public boolean isExecutable() {
                return super.isExecutable() && WindowMenu.this.desktop.getAllFrames().length > 0;
            }
        };
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
                WindowMenu.this.removeAll();
            }

            public void menuSelected(MenuEvent e) {
                WindowMenu.this.buildChildMenus();
            }
        });
    }

    private void buildChildMenus() {
        JInternalFrame[] array = this.desktop.getAllFrames();
        this.add(this.cascadeCommand);
        this.add(this.tileCommand);
        if (array.length > 0) {
            this.addSeparator();
        }
        for (int i = 0; i < array.length; ++i) {
            ChildMenuItem menu = new ChildMenuItem(array[i]);
            menu.setState(i == 0);
            menu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    JInternalFrame frame = ((ChildMenuItem)ae.getSource()).getFrame();
                    frame.moveToFront();
                    try {
                        frame.setSelected(true);
                    }
                    catch (PropertyVetoException e) {
                        e.printStackTrace();
                    }
                }
            });
            menu.setIcon(array[i].getFrameIcon());
            this.add(menu);
        }
    }

    class ChildMenuItem
    extends JCheckBoxMenuItem {
        private JInternalFrame frame;

        public ChildMenuItem(JInternalFrame frame) {
            super(frame.getTitle());
            this.frame = frame;
        }

        public JInternalFrame getFrame() {
            return this.frame;
        }
    }
}

