

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Remove Duplicates (duplicate){/block}
  {block name=body}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Remove Duplicates (duplicate)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="filter_nuketypes.html">Prev</a> </td><th width="60%" align="center">Chapter 4. Data Filters</th><td width="20%" align="right"> <a accesskey="n" href="filter_position.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="filter_duplicate"></a>Remove Duplicates (duplicate)</h2></div></div></div><p> 
The duplicate filter is designed to remove duplicate points based on their 
short name (traditionally a waypoint's name on the GPS receiver), and/or 
their location (to a  precision of 6 decimals).  This filter supports two 
options that specify how duplicates will be recognized, 
<code class="option">shortname</code> and <code class="option">location</code>.  
Generally, at least one of these options is required.  
</p><div class="example"><a id="duplicate_to_suppress_points"></a><p class="title"><strong>Example 4.15. Using the duplicate filter to suppress points with the same 
         name and location</strong></p><div class="example-contents"><p>
  This command line removes points that have duplicate short names
  and duplicate locations.  The result would be a 
  <a class="link" href="fmt_gpx.html" title="GPX XML (gpx)">gpx</a> file that more than likely 
  contains only unique points and point data.
  </p><p><strong class="userinput"><code> gpsbabel -i gpx -f 1.gpx -f 2.gpx -x duplicate,location,shortname -o gpx -F merged_with_no_dupes.gpx</code></strong></p></div></div><br class="example-break" /><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_duplicate_o_shortname"></a>shortname option</h3></div></div></div><p>
      Suppress duplicate waypoints based on name.
    </p><p>
This option is the one most often used with the duplicate filter.  This 
option instructs the duplicate filter to remove any waypoints that share
a short name with a waypoint that has come before.  This option might be
used to remove duplicates if you are merging two datasets that were 
each created in part from a common ancestor dataset.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_duplicate_o_location"></a>location option</h3></div></div></div><p>
      Suppress duplicate waypoint based on coords.
    </p><p>
This option causes the duplicate filter to remove any additional waypoint 
that has the same coordinates (to six decimal degrees) as a waypoint that 
came before.  This option may be used to remove duplicate waypoints if the 
names are not expected to be the same.  It also might be used along with the
<code class="option">shortname</code> option to remove duplicate waypoints if the names 
of several unrelated groups of waypoints might be the same.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_duplicate_o_all"></a>all option</h3></div></div></div><p>
      Suppress all instances of duplicates.
    </p><p>
When this option is specified, GPSBabel will remove all instances of a
duplicated waypoint, not just the second and subsequent instances.  If
your input file contains waypoints A, B, B, and C, the output file will
contain waypoints A, B, and C without the <code class="option">all</code> option, 
or just A and C with the <code class="option">all</code> option.
</p><div class="example"><a id="duplicate_to_ignore"></a><p class="title"><strong>Example 4.16. Using the duplicate filter to implement an "ignore list."</strong></p><div class="example-contents"><p>
This option may be used to implement an "ignore list."  In the following 
example, the duplicate filter is used to remove a list of waypoints to be
ignored from a larger collection of waypoints:
</p><p><strong class="userinput"><code>gpsbabel -i gpx -f waypoints.gpx -i csv -f to_ignore.csv -x duplicate,shortname,all -o gpx -F filtered.gpx</code></strong></p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_duplicate_o_correct"></a>correct option</h3></div></div></div><p>
      Use coords from duplicate points.
    </p><p>
This option is used to change the locations of waypoints without losing any 
of the other associated information.  When this option is specified, the 
latitude and longitude from later duplicates will replace the latitude and
longitude in the original waypoint.
</p><p>
As an example, this option may be used to adjust the locations of "puzzle" 
geocaches in a Groundspeak pocket query:
</p><div class="example"><a id="Correcting_Cache_Locations"></a><p class="title"><strong>Example 4.17. Using the duplicate filter to correct the locations of "puzzle"
geocaches</strong></p><div class="example-contents"><p><strong class="userinput"><code>gpsbabel -i gpx -f 43622.gpx -i csv -f corrections.csv -x duplicate,shortname,correct -o gpx -F 43622-corrected.gpx</code></strong></p><p>
After this command is run, the waypoints in the output file will have all 
of the descriptive information from <code class="filename">43622.gpx</code>, but 
waypoints that were also found in <code class="filename">corrections.csv</code> 
will have their coordinates replaced with the coordinates from that file.
</p></div></div><br class="example-break" /></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="filter_nuketypes.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Data_Filters.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="filter_position.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Remove all waypoints, tracks, or routes (nuketypes) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Remove Points Within Distance (position)</td></tr></table></div>
  
      {/block}
  