/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFReference;

public class PDFLaunch
extends PDFAction {
    private PDFReference externalFileSpec;

    public PDFLaunch(PDFFileSpec fileSpec) {
        this(fileSpec.makeReference());
    }

    public PDFLaunch(PDFReference fileSpec) {
        PDFObject fs = fileSpec.getObject();
        if (fs != null) assert (fs instanceof PDFFileSpec);
        this.externalFileSpec = fileSpec;
    }

    public String getAction() {
        return this.referencePDF();
    }

    public String toPDFString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("<<\n/S /Launch\n/F ");
        sb.append(this.externalFileSpec.toString());
        sb.append("\n>>");
        return sb.toString();
    }

    protected boolean contentEquals(PDFObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PDFLaunch)) {
            return false;
        }
        PDFLaunch launch = (PDFLaunch)obj;
        return launch.externalFileSpec.toString().equals(this.externalFileSpec.toString());
    }
}

