/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.cext;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.RubyLanguage;
import org.jruby.truffle.cext.StringCharPointerAdapter;
import org.jruby.truffle.core.rope.NativeRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.rope.RopeNodesFactory;
import org.jruby.truffle.core.string.StringNodes;
import org.jruby.truffle.core.string.StringNodesFactory;
import org.jruby.truffle.core.string.StringOperations;

public class StringCharPointerMessageResolution {

    public static abstract class CharPointerUnboxNode
    extends Node {
        @Node.Child
        private Node findContextNode;
        private final ConditionProfile convertProfile = ConditionProfile.createBinaryProfile();
        @CompilerDirectives.CompilationFinal
        private RubyContext context;

        protected Object access(StringCharPointerAdapter stringCharPointerAdapter) {
            NativeRope nativeRope;
            Rope currentRope = Layouts.STRING.getRope(stringCharPointerAdapter.getString());
            if (this.convertProfile.profile(currentRope instanceof NativeRope)) {
                nativeRope = (NativeRope)currentRope;
            } else {
                if (this.findContextNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.findContextNode = this.insert(RubyLanguage.INSTANCE.unprotectedCreateFindContextNode());
                    this.context = RubyLanguage.INSTANCE.unprotectedFindContext(this.findContextNode);
                }
                nativeRope = new NativeRope(this.context.getNativePlatform().getMemoryManager(), currentRope.getBytes(), currentRope.getEncoding(), currentRope.characterLength());
                Layouts.STRING.setRope(stringCharPointerAdapter.getString(), nativeRope);
            }
            return nativeRope.getNativePointer().address();
        }
    }

    public static abstract class CharPointerWriteNode
    extends Node {
        @Node.Child
        private Node findContextNode;
        @Node.Child
        private StringNodes.SetByteNode setByteNode;

        protected Object access(StringCharPointerAdapter stringCharPointerAdapter, int index, Object value) {
            return this.getHelperNode().executeSetByte(stringCharPointerAdapter.getString(), index, value);
        }

        private StringNodes.SetByteNode getHelperNode() {
            if (this.setByteNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.findContextNode = this.insert(RubyLanguage.INSTANCE.unprotectedCreateFindContextNode());
                RubyContext context = RubyLanguage.INSTANCE.unprotectedFindContext(this.findContextNode);
                this.setByteNode = this.insert(StringNodesFactory.SetByteNodeFactory.create(context, null, null, null, null));
            }
            return this.setByteNode;
        }
    }

    public static abstract class CharPointerReadNode
    extends Node {
        @Node.Child
        private RopeNodes.GetByteNode getByteNode;

        protected Object access(StringCharPointerAdapter stringCharPointerAdapter, int index) {
            return this.getHelperNode().executeGetByte(StringOperations.rope(stringCharPointerAdapter.getString()), index);
        }

        private RopeNodes.GetByteNode getHelperNode() {
            if (this.getByteNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getByteNode = this.insert(RopeNodesFactory.GetByteNodeGen.create(null, null));
            }
            return this.getByteNode;
        }
    }

    public static abstract class CharPointerGetSizeNode
    extends Node {
        protected Object access(StringCharPointerAdapter stringCharPointerAdapter) {
            return StringOperations.rope(stringCharPointerAdapter.getString()).byteLength();
        }
    }

    public static abstract class CharPointerHasSizeNode
    extends Node {
        protected Object access(StringCharPointerAdapter object) {
            return true;
        }
    }

    public static abstract class CharPointerCheckNode
    extends Node {
        protected static boolean test(TruffleObject receiver) {
            return receiver instanceof StringCharPointerAdapter;
        }
    }
}

