/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.format.FormatFloatNode;

@GeneratedBy(value=FormatFloatNode.class)
public final class FormatFloatNodeGen
extends FormatFloatNode {
    @Node.Child
    private FormatNode width_;
    @Node.Child
    private FormatNode precision_;
    @Node.Child
    private FormatNode value_;
    @CompilerDirectives.CompilationFinal
    private boolean seenUnsupported0;

    private FormatFloatNodeGen(RubyContext context, char format, boolean hasSpaceFlag, boolean hasZeroFlag, boolean hasPlusFlag, boolean hasMinusFlag, boolean hasFSharpFlag, FormatNode width, FormatNode precision, FormatNode value) {
        super(context, format, hasSpaceFlag, hasZeroFlag, hasPlusFlag, hasMinusFlag, hasFSharpFlag);
        this.width_ = width;
        this.precision_ = precision;
        this.value_ = value;
    }

    @Override
    public NodeCost getCost() {
        return NodeCost.MONOMORPHIC;
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        double valueValue_;
        int precisionValue_;
        int widthValue_;
        try {
            widthValue_ = FormatFloatNodeGen.expectInteger(this.width_.execute(frameValue));
        }
        catch (UnexpectedResultException ex) {
            Object precisionValue = this.precision_.execute(frameValue);
            Object valueValue = this.value_.execute(frameValue);
            throw this.unsupported(ex.getResult(), precisionValue, valueValue);
        }
        try {
            precisionValue_ = FormatFloatNodeGen.expectInteger(this.precision_.execute(frameValue));
        }
        catch (UnexpectedResultException ex) {
            Object valueValue = this.value_.execute(frameValue);
            throw this.unsupported(widthValue_, ex.getResult(), valueValue);
        }
        try {
            valueValue_ = FormatFloatNodeGen.expectDouble(this.value_.execute(frameValue));
        }
        catch (UnexpectedResultException ex) {
            throw this.unsupported(widthValue_, precisionValue_, ex.getResult());
        }
        return this.formatInfinite(widthValue_, precisionValue_, valueValue_);
    }

    private UnsupportedSpecializationException unsupported(Object widthValue, Object precisionValue, Object valueValue) {
        if (!this.seenUnsupported0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.seenUnsupported0 = true;
        }
        return new UnsupportedSpecializationException(this, new Node[]{this.width_, this.precision_, this.value_}, widthValue, precisionValue, valueValue);
    }

    private static double expectDouble(Object value) throws UnexpectedResultException {
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static FormatFloatNode create(RubyContext context, char format, boolean hasSpaceFlag, boolean hasZeroFlag, boolean hasPlusFlag, boolean hasMinusFlag, boolean hasFSharpFlag, FormatNode width, FormatNode precision, FormatNode value) {
        return new FormatFloatNodeGen(context, format, hasSpaceFlag, hasZeroFlag, hasPlusFlag, hasMinusFlag, hasFSharpFlag, width, precision, value);
    }
}

