/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.loader;

import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Locale;
import org.jruby.Ruby;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.util.StringUtils;

public class SourceLoader {
    public static final String TRUFFLE_SCHEME = "truffle:";
    public static final String JRUBY_SCHEME = "jruby:";
    private final RubyContext context;

    public SourceLoader(RubyContext context) {
        this.context = context;
    }

    public Source load(String canonicalPath) throws IOException {
        if (canonicalPath.equals("-e")) {
            return this.loadFragment(new String(this.context.getJRubyRuntime().getInstanceConfig().inlineScript(), StandardCharsets.UTF_8), "-e");
        }
        if (canonicalPath.startsWith(TRUFFLE_SCHEME) || canonicalPath.startsWith(JRUBY_SCHEME)) {
            return this.loadResource(canonicalPath);
        }
        File file = new File(canonicalPath).getCanonicalFile();
        if (!file.canRead()) {
            throw new IOException("Can't read file " + canonicalPath);
        }
        if (canonicalPath.toLowerCase().endsWith(".su")) {
            return Source.newBuilder(file).name(file.getPath()).mimeType("application/x-sulong-library").build();
        }
        return Source.newBuilder(file).name(file.getPath()).mimeType("application/x-ruby").build();
    }

    public Source loadFragment(String fragment, String name) {
        return Source.newBuilder(fragment).name(name).mimeType("application/x-ruby").build();
    }

    private Source loadResource(String path) throws IOException {
        Path relativePath;
        Class<RubyContext> relativeClass;
        if (!path.toLowerCase(Locale.ENGLISH).endsWith(".rb")) {
            throw new FileNotFoundException(path);
        }
        if (path.startsWith(TRUFFLE_SCHEME)) {
            relativeClass = RubyContext.class;
            relativePath = FileSystems.getDefault().getPath(path.substring(TRUFFLE_SCHEME.length()), new String[0]);
        } else if (path.startsWith(JRUBY_SCHEME)) {
            relativeClass = Ruby.class;
            relativePath = FileSystems.getDefault().getPath(path.substring(JRUBY_SCHEME.length()), new String[0]);
        } else {
            throw new UnsupportedOperationException();
        }
        Path normalizedPath = relativePath.normalize();
        InputStream stream = relativeClass.getResourceAsStream(StringUtils.replace(normalizedPath.toString(), '\\', '/'));
        if (stream == null) {
            throw new FileNotFoundException(path);
        }
        return Source.newBuilder(new InputStreamReader(stream, StandardCharsets.UTF_8)).name(path).mimeType("application/x-ruby").build();
    }
}

