/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.ControlFlowInformationProvider;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00a3\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001KB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0007J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0007J\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0002J*\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\"\u001a\u0004\u0018\u00010#H\u0007J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u001bH\u0007J\u0018\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u0001H\u0002J\u0018\u0010+\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020,2\u0006\u0010-\u001a\u00020\fH\u0002J\u0010\u0010.\u001a\u00020\f2\u0006\u0010'\u001a\u00020\u0001H\u0002J\u001e\u0010/\u001a\u0004\u0018\u00010\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J \u00100\u001a\u00020\f2\u0006\u00101\u001a\u0002022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u00103\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u00104\u001a\u00020\f2\b\u00105\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u00106\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u0002082\u0006\u0010<\u001a\u00020=H\u0002J0\u0010>\u001a\u0002082\u0006\u0010?\u001a\u00020\u00172\u000e\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010B0A2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010C\u001a\u00020DH\u0002J \u0010E\u001a\u0002082\u0006\u0010?\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010C\u001a\u00020DH\u0002J\u0010\u0010F\u001a\u0002082\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010G\u001a\u0002082\u0006\u0010 \u001a\u00020!2\b\u0010H\u001a\u0004\u0018\u00010#J\u001a\u0010I\u001a\u00020)2\u0006\u00109\u001a\u00020:2\b\u0010H\u001a\u0004\u0018\u00010#H\u0002J*\u0010J\u001a\u00020)2\u0006\u0010 \u001a\u00020!2\b\u0010H\u001a\u0004\u0018\u00010#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010C\u001a\u00020DH\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006L"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "", "()V", "NO_IDENTIFIER_INFO", "org/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory$NO_IDENTIFIER_INFO$1", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory$NO_IDENTIFIER_INFO$1;", "immanentNullability", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/Nullability;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getImmanentNullability", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/calls/smartcasts/Nullability;", "combineInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory$IdentifierInfo;", "receiverInfo", "selectorInfo", "createDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "containingDeclarationOrModule", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolutionContext", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "receiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "createDataFlowValueForComplexExpression", "createDataFlowValueForProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "usageContainingModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "createDataFlowValueForStableReceiver", "receiver", "createInfo", "id", "kind", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Kind;", "createPackageOrClassInfo", "createPostfixInfo", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "argumentInfo", "createStableInfo", "getIdForImplicitReceiver", "getIdForSimpleNameExpression", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "getIdForStableIdentifier", "getIdForThisReceiver", "descriptorOfThisReceiver", "getVariableContainingDeclaration", "hasDefaultGetter", "", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "invisibleFromOtherModules", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "isAccessedBeforeAllClosureWriters", "variableContainingDeclaration", "writers", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "accessElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isAccessedInsideClosure", "isComplexExpression", "isStableValue", "usageModule", "propertyKind", "variableKind", "IdentifierInfo", "kotlin-compiler"})
public final class DataFlowValueFactory {
    private static final NO_IDENTIFIER_INFO.1 NO_IDENTIFIER_INFO;
    public static final DataFlowValueFactory INSTANCE;

    @JvmStatic
    @NotNull
    public static final DataFlowValue createDataFlowValue(@NotNull KtExpression expression, @NotNull KotlinType type2, @NotNull ResolutionContext<?> resolutionContext) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(resolutionContext, "resolutionContext");
        BindingContext bindingContext = resolutionContext.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "resolutionContext.trace.bindingContext");
        return DataFlowValueFactory.createDataFlowValue(expression, type2, bindingContext, resolutionContext.scope.getOwnerDescriptor());
    }

    private final boolean isComplexExpression(KtExpression expression) {
        KtExpression deparenthesized;
        KtExpression ktExpression = expression;
        boolean bl = ktExpression instanceof KtBlockExpression || ktExpression instanceof KtIfExpression || ktExpression instanceof KtWhenExpression ? true : (ktExpression instanceof KtBinaryExpression ? ((KtBinaryExpression)expression).getOperationToken() == KtTokens.ELVIS : (ktExpression instanceof KtParenthesizedExpression ? (deparenthesized = KtPsiUtil.deparenthesize(expression)) != null && this.isComplexExpression(deparenthesized) : false));
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final DataFlowValue createDataFlowValue(@NotNull KtExpression expression, @NotNull KotlinType type2, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(containingDeclarationOrModule, "containingDeclarationOrModule");
        if (expression instanceof KtConstantExpression && ((KtConstantExpression)expression).getNode().getElementType() == KtNodeTypes.NULL) {
            return DataFlowValue.Companion.nullValue(DescriptorUtilsKt.getBuiltIns(containingDeclarationOrModule));
        }
        if (type2.isError()) {
            return DataFlowValue.ERROR;
        }
        if (KotlinBuiltIns.isNullableNothing(type2)) {
            return DataFlowValue.Companion.nullValue(DescriptorUtilsKt.getBuiltIns(containingDeclarationOrModule));
        }
        if (ExpressionTypingUtils.isExclExclExpression(KtPsiUtil.deparenthesize(expression))) {
            return new DataFlowValue(expression, type2, DataFlowValue.Kind.OTHER, Nullability.NOT_NULL);
        }
        if (INSTANCE.isComplexExpression(expression)) {
            return INSTANCE.createDataFlowValueForComplexExpression(expression, type2);
        }
        IdentifierInfo result2 = INSTANCE.getIdForStableIdentifier(expression, bindingContext, containingDeclarationOrModule);
        return new DataFlowValue(result2 == NO_IDENTIFIER_INFO ? expression : result2.getId(), type2, result2.getKind(), INSTANCE.getImmanentNullability(type2));
    }

    @JvmStatic
    @NotNull
    public static final DataFlowValue createDataFlowValueForStableReceiver(@NotNull ReceiverValue receiver) {
        KotlinType type2;
        Intrinsics.checkParameterIsNotNull(receiver, "receiver");
        KotlinType kotlinType = type2 = receiver.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "type");
        return new DataFlowValue(receiver, kotlinType, DataFlowValue.Kind.STABLE_VALUE, INSTANCE.getImmanentNullability(type2));
    }

    @JvmStatic
    @NotNull
    public static final DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull ResolutionContext<?> resolutionContext) {
        Intrinsics.checkParameterIsNotNull(receiverValue, "receiverValue");
        Intrinsics.checkParameterIsNotNull(resolutionContext, "resolutionContext");
        BindingContext bindingContext = resolutionContext.trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "resolutionContext.trace.bindingContext");
        return DataFlowValueFactory.createDataFlowValue(receiverValue, bindingContext, resolutionContext.scope.getOwnerDescriptor());
    }

    @JvmStatic
    @NotNull
    public static final DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        DataFlowValue dataFlowValue;
        Intrinsics.checkParameterIsNotNull(receiverValue, "receiverValue");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(containingDeclarationOrModule, "containingDeclarationOrModule");
        ReceiverValue receiverValue2 = receiverValue;
        if (receiverValue2 instanceof TransientReceiver || receiverValue2 instanceof ImplicitReceiver) {
            dataFlowValue = DataFlowValueFactory.createDataFlowValueForStableReceiver(receiverValue);
        } else if (receiverValue2 instanceof ExpressionReceiver) {
            KtExpression ktExpression = ((ExpressionReceiver)receiverValue).getExpression();
            KotlinType kotlinType = receiverValue.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiverValue.getType()");
            dataFlowValue = DataFlowValueFactory.createDataFlowValue(ktExpression, kotlinType, bindingContext, containingDeclarationOrModule);
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported receiver value: " + receiverValue.getClass().getName());
        }
        return dataFlowValue;
    }

    @JvmStatic
    @NotNull
    public static final DataFlowValue createDataFlowValueForProperty(@NotNull KtProperty property, @NotNull VariableDescriptor variableDescriptor, @NotNull BindingContext bindingContext, @Nullable ModuleDescriptor usageContainingModule) {
        KotlinType type2;
        Intrinsics.checkParameterIsNotNull(property, "property");
        Intrinsics.checkParameterIsNotNull(variableDescriptor, "variableDescriptor");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        KotlinType kotlinType = type2 = variableDescriptor.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "type");
        return new DataFlowValue(variableDescriptor, kotlinType, INSTANCE.variableKind(variableDescriptor, usageContainingModule, bindingContext, property), INSTANCE.getImmanentNullability(type2));
    }

    private final DataFlowValue createDataFlowValueForComplexExpression(KtExpression expression, KotlinType type2) {
        return new DataFlowValue(expression, type2, DataFlowValue.Kind.STABLE_COMPLEX_EXPRESSION, this.getImmanentNullability(type2));
    }

    private final Nullability getImmanentNullability(@NotNull KotlinType $receiver) {
        return TypeUtils.isNullableType($receiver) ? Nullability.UNKNOWN : Nullability.NOT_NULL;
    }

    private final IdentifierInfo createInfo(Object id, DataFlowValue.Kind kind) {
        return new IdentifierInfo(id, kind, false);
    }

    private final IdentifierInfo createStableInfo(Object id) {
        return this.createInfo(id, DataFlowValue.Kind.STABLE_VALUE);
    }

    private final IdentifierInfo createPackageOrClassInfo(Object id) {
        return new IdentifierInfo(id, DataFlowValue.Kind.STABLE_VALUE, true);
    }

    private final IdentifierInfo combineInfo(IdentifierInfo receiverInfo, IdentifierInfo selectorInfo) {
        IdentifierInfo identifierInfo;
        if (selectorInfo.getId() == null || receiverInfo == NO_IDENTIFIER_INFO) {
            identifierInfo = NO_IDENTIFIER_INFO;
        } else if (receiverInfo == null || receiverInfo.isPackage()) {
            identifierInfo = selectorInfo;
        } else {
            Pair<Object, Object> pair = Pair.create(receiverInfo.getId(), selectorInfo.getId());
            Intrinsics.checkExpressionValueIsNotNull(pair, "Pair.create<Any, Any>(re\u2026Info.id, selectorInfo.id)");
            identifierInfo = this.createInfo(pair, receiverInfo.getKind().isStable() ? selectorInfo.getKind() : DataFlowValue.Kind.OTHER);
        }
        return identifierInfo;
    }

    private final IdentifierInfo createPostfixInfo(KtPostfixExpression expression, IdentifierInfo argumentInfo) {
        IdentifierInfo identifierInfo;
        if (argumentInfo == NO_IDENTIFIER_INFO) {
            identifierInfo = NO_IDENTIFIER_INFO;
        } else {
            Pair<KtPostfixExpression, Object> pair = Pair.create(expression, argumentInfo.getId());
            Intrinsics.checkExpressionValueIsNotNull(pair, "Pair.create<KtPostfixExp\u2026ression, argumentInfo.id)");
            identifierInfo = this.createInfo(pair, argumentInfo.getKind());
        }
        return identifierInfo;
    }

    private final IdentifierInfo getIdForStableIdentifier(KtExpression expression, BindingContext bindingContext, DeclarationDescriptor containingDeclarationOrModule) {
        IdentifierInfo identifierInfo;
        KtExpression deparenthesized;
        if (expression != null && expression != (deparenthesized = KtPsiUtil.deparenthesize(expression))) {
            return this.getIdForStableIdentifier(deparenthesized, bindingContext, containingDeclarationOrModule);
        }
        KtExpression ktExpression = expression;
        if (ktExpression instanceof KtQualifiedExpression) {
            KtExpression receiverExpression = ((KtQualifiedExpression)expression).getReceiverExpression();
            KtExpression selectorExpression = ((KtQualifiedExpression)expression).getSelectorExpression();
            IdentifierInfo receiverId = this.getIdForStableIdentifier(receiverExpression, bindingContext, containingDeclarationOrModule);
            IdentifierInfo selectorId = this.getIdForStableIdentifier(selectorExpression, bindingContext, containingDeclarationOrModule);
            identifierInfo = this.combineInfo(receiverId, selectorId);
        } else if (ktExpression instanceof KtSimpleNameExpression) {
            identifierInfo = this.getIdForSimpleNameExpression((KtSimpleNameExpression)expression, bindingContext, containingDeclarationOrModule);
        } else if (ktExpression instanceof KtThisExpression) {
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext.get(BindingContext.REFERENCE_TARGET, ((KtThisExpression)expression).getInstanceReference());
            identifierInfo = this.getIdForThisReceiver(declarationDescriptor);
        } else {
            IElementType operationType;
            identifierInfo = ktExpression instanceof KtPostfixExpression ? ((operationType = ((KtPostfixExpression)expression).getOperationReference().getReferencedNameElementType()) == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS ? this.createPostfixInfo((KtPostfixExpression)expression, this.getIdForStableIdentifier(((KtPostfixExpression)expression).getBaseExpression(), bindingContext, containingDeclarationOrModule)) : (IdentifierInfo)NO_IDENTIFIER_INFO) : (IdentifierInfo)NO_IDENTIFIER_INFO;
        }
        return identifierInfo;
    }

    private final IdentifierInfo getIdForSimpleNameExpression(KtSimpleNameExpression simpleNameExpression, BindingContext bindingContext, DeclarationDescriptor containingDeclarationOrModule) {
        IdentifierInfo identifierInfo;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext.get(BindingContext.REFERENCE_TARGET, simpleNameExpression);
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        if (declarationDescriptor2 instanceof VariableDescriptor) {
            IdentifierInfo identifierInfo2;
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(simpleNameExpression, bindingContext);
            ModuleDescriptor usageModuleDescriptor = DescriptorUtils.getContainingModuleOrNull(containingDeclarationOrModule);
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            if (resolvedCall3 != null) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall4 = resolvedCall3;
                ResolvedCall<? extends CallableDescriptor> it = resolvedCall4;
                identifierInfo2 = INSTANCE.getIdForImplicitReceiver(it.getDispatchReceiver(), simpleNameExpression);
            } else {
                identifierInfo2 = null;
            }
            IdentifierInfo receiverInfo = identifierInfo2;
            identifierInfo = this.combineInfo(receiverInfo, this.createInfo(declarationDescriptor, this.variableKind((VariableDescriptor)declarationDescriptor, usageModuleDescriptor, bindingContext, simpleNameExpression)));
        } else {
            identifierInfo = declarationDescriptor2 instanceof PackageViewDescriptor || declarationDescriptor2 instanceof ClassDescriptor ? this.createPackageOrClassInfo(declarationDescriptor) : (IdentifierInfo)NO_IDENTIFIER_INFO;
        }
        return identifierInfo;
    }

    private final IdentifierInfo getIdForImplicitReceiver(ReceiverValue receiverValue, KtExpression expression) {
        IdentifierInfo identifierInfo;
        ReceiverValue receiverValue2 = receiverValue;
        if (receiverValue2 instanceof ImplicitReceiver) {
            identifierInfo = this.getIdForThisReceiver(((ImplicitReceiver)receiverValue).getDeclarationDescriptor());
        } else {
            if (receiverValue2 instanceof TransientReceiver) {
                throw (Throwable)((Object)new AssertionError((Object)("Transient receiver is implicit for an explicit expression: " + expression + ". Receiver: " + receiverValue)));
            }
            identifierInfo = null;
        }
        return identifierInfo;
    }

    private final IdentifierInfo getIdForThisReceiver(DeclarationDescriptor descriptorOfThisReceiver) {
        IdentifierInfo identifierInfo;
        DeclarationDescriptor declarationDescriptor = descriptorOfThisReceiver;
        if (declarationDescriptor instanceof CallableDescriptor) {
            ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)descriptorOfThisReceiver).getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                String string = "'This' refers to the callable member without a receiver parameter: " + descriptorOfThisReceiver;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
            ReceiverValue receiverValue = receiverParameter.getValue();
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "receiverParameter.value");
            identifierInfo = this.createStableInfo(receiverValue);
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            ReceiverValue receiverValue = ((ClassDescriptor)descriptorOfThisReceiver).getThisAsReceiverParameter().getValue();
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "descriptorOfThisReceiver\u2026AsReceiverParameter.value");
            identifierInfo = this.createStableInfo(receiverValue);
        } else {
            identifierInfo = NO_IDENTIFIER_INFO;
        }
        return identifierInfo;
    }

    private final DeclarationDescriptor getVariableContainingDeclaration(VariableDescriptor variableDescriptor) {
        DeclarationDescriptor declarationDescriptor;
        DeclarationDescriptor containingDeclarationDescriptor = variableDescriptor.getContainingDeclaration();
        if (containingDeclarationDescriptor instanceof ConstructorDescriptor && ((ConstructorDescriptor)containingDeclarationDescriptor).isPrimary()) {
            DeclarationDescriptor declarationDescriptor2 = ((ConstructorDescriptor)containingDeclarationDescriptor).getContainingDeclaration();
            declarationDescriptor = declarationDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "containingDeclarationDes\u2026tor.containingDeclaration");
        } else {
            DeclarationDescriptor declarationDescriptor3 = containingDeclarationDescriptor;
            declarationDescriptor = declarationDescriptor3;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor3, "containingDeclarationDescriptor");
        }
        return declarationDescriptor;
    }

    private final boolean isAccessedInsideClosure(DeclarationDescriptor variableContainingDeclaration, BindingContext bindingContext, KtElement accessElement) {
        KtDeclaration parent2 = ControlFlowInformationProvider.Companion.getElementParentDeclaration(accessElement);
        return parent2 != null ? Intrinsics.areEqual(variableContainingDeclaration, bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, parent2)) ^ true : false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isAccessedBeforeAllClosureWriters(DeclarationDescriptor variableContainingDeclaration, Set<? extends KtDeclaration> writers, BindingContext bindingContext, KtElement accessElement) {
        void $receiver$iv;
        Iterable iterable = CollectionsKt.filterNotNull((Iterable)writers);
        for (Object element$iv : $receiver$iv) {
            KtDeclaration writer = (KtDeclaration)element$iv;
            DeclarationDescriptor writerDescriptor = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, writer);
            if (!(Intrinsics.areEqual(variableContainingDeclaration, writerDescriptor) ^ true) || PsiUtilsKt.before(accessElement, writer)) continue;
            return false;
        }
        return true;
    }

    private final DataFlowValue.Kind propertyKind(PropertyDescriptor propertyDescriptor, ModuleDescriptor usageModule) {
        if (propertyDescriptor.isVar()) {
            return DataFlowValue.Kind.MUTABLE_PROPERTY;
        }
        if (ModalityKt.isOverridable(propertyDescriptor)) {
            return DataFlowValue.Kind.PROPERTY_WITH_GETTER;
        }
        if (!this.hasDefaultGetter(propertyDescriptor)) {
            return DataFlowValue.Kind.PROPERTY_WITH_GETTER;
        }
        if (!this.invisibleFromOtherModules(propertyDescriptor)) {
            ModuleDescriptor declarationModule = DescriptorUtils.getContainingModule(propertyDescriptor);
            if (usageModule == null || Intrinsics.areEqual(usageModule, declarationModule) ^ true) {
                return DataFlowValue.Kind.ALIEN_PUBLIC_PROPERTY;
            }
        }
        return DataFlowValue.Kind.STABLE_VALUE;
    }

    private final DataFlowValue.Kind variableKind(VariableDescriptor variableDescriptor, ModuleDescriptor usageModule, BindingContext bindingContext, KtElement accessElement) {
        if (variableDescriptor instanceof PropertyDescriptor) {
            return this.propertyKind((PropertyDescriptor)variableDescriptor, usageModule);
        }
        if (!(variableDescriptor instanceof LocalVariableDescriptor) && !(variableDescriptor instanceof ParameterDescriptor)) {
            return DataFlowValue.Kind.OTHER;
        }
        if (!variableDescriptor.isVar()) {
            return DataFlowValue.Kind.STABLE_VALUE;
        }
        if (variableDescriptor instanceof SyntheticFieldDescriptor) {
            return DataFlowValue.Kind.MUTABLE_PROPERTY;
        }
        PreliminaryDeclarationVisitor preliminaryDeclarationVisitor = PreliminaryDeclarationVisitor.Companion.getVisitorByVariable(variableDescriptor, bindingContext);
        if (preliminaryDeclarationVisitor == null) {
            return DataFlowValue.Kind.UNPREDICTABLE_VARIABLE;
        }
        PreliminaryDeclarationVisitor preliminaryVisitor = preliminaryDeclarationVisitor;
        Set<KtDeclaration> writers = preliminaryVisitor.writers(variableDescriptor);
        if (writers.isEmpty()) {
            return DataFlowValue.Kind.PREDICTABLE_VARIABLE;
        }
        DeclarationDescriptor variableContainingDeclaration = this.getVariableContainingDeclaration(variableDescriptor);
        if (this.isAccessedInsideClosure(variableContainingDeclaration, bindingContext, accessElement)) {
            return DataFlowValue.Kind.UNPREDICTABLE_VARIABLE;
        }
        return this.isAccessedBeforeAllClosureWriters(variableContainingDeclaration, writers, bindingContext, accessElement) ? DataFlowValue.Kind.PREDICTABLE_VARIABLE : DataFlowValue.Kind.UNPREDICTABLE_VARIABLE;
    }

    public final boolean isStableValue(@NotNull VariableDescriptor variableDescriptor, @Nullable ModuleDescriptor usageModule) {
        Intrinsics.checkParameterIsNotNull(variableDescriptor, "variableDescriptor");
        if (variableDescriptor.isVar()) {
            return false;
        }
        return !(variableDescriptor instanceof PropertyDescriptor) || this.propertyKind((PropertyDescriptor)variableDescriptor, usageModule) == DataFlowValue.Kind.STABLE_VALUE;
    }

    private final boolean invisibleFromOtherModules(DeclarationDescriptorWithVisibility descriptor2) {
        if (Visibilities.INVISIBLE_FROM_OTHER_MODULES.contains(descriptor2.getVisibility())) {
            return true;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        return containingDeclaration instanceof DeclarationDescriptorWithVisibility && this.invisibleFromOtherModules((DeclarationDescriptorWithVisibility)containingDeclaration);
    }

    private final boolean hasDefaultGetter(PropertyDescriptor propertyDescriptor) {
        PropertyGetterDescriptor getter = propertyDescriptor.getGetter();
        return getter == null || getter.isDefault();
    }

    private DataFlowValueFactory() {
        INSTANCE = this;
        NO_IDENTIFIER_INFO = new IdentifierInfo(null, DataFlowValue.Kind.OTHER, false){

            @NotNull
            public String toString() {
                return "NO_IDENTIFIER_INFO";
            }
        };
    }

    static {
        new DataFlowValueFactory();
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0012\u0018\u00002\u00020\u0001B!\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory$IdentifierInfo;", "", "id", "kind", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Kind;", "isPackage", "", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Kind;Z)V", "getId", "()Ljava/lang/Object;", "()Z", "getKind", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Kind;", "kotlin-compiler"})
    private static class IdentifierInfo {
        @Nullable
        private final Object id;
        @NotNull
        private final DataFlowValue.Kind kind;
        private final boolean isPackage;

        @Nullable
        public final Object getId() {
            return this.id;
        }

        @NotNull
        public final DataFlowValue.Kind getKind() {
            return this.kind;
        }

        public final boolean isPackage() {
            return this.isPackage;
        }

        public IdentifierInfo(@Nullable Object id, @NotNull DataFlowValue.Kind kind, boolean isPackage) {
            Intrinsics.checkParameterIsNotNull((Object)kind, "kind");
            this.id = id;
            this.kind = kind;
            this.isPackage = isPackage;
        }
    }
}

