"""
eventing.py event and event tagging utility functions

"""
from __future__ import absolute_import, division, print_function

import sys
import os
import datetime

# Import ioflo libs
from .sixing import *
from .odicting import odict
from .consoling import getConsole

console = getConsole()

def tagify(tail=u'', head=u'', sep=u'.'):
    """
    Returns namespaced event tag string.
    Tag generated by joining with sep the head and tail in that order

    If tail is a list Then join all string elements of tail individually
    Else use string suffix

    If either head or tail is empty then do not exhibit

    """
    parts = [head]
    if hasattr(tail, 'append'):  # list so extend parts
        parts.extend(tail)
    else:  # string so append
        parts.append(tail)
    return sep.join([part for part in parts if part])

def eventify(tag, data=None, stamp=None, uid=None):
    """
    Returns new event with tag and  current timestamp and data if any
    Timestamp is iso 8601
    YYYY-MM-DDTHH:MM:SS.mmmmmm which is strftime '%Y-%m-%dT%H:%M:%S.%f'
    Adds uid field if provided
    """
    event = odict([(u'tag', tag),
                   (u'stamp', stamp if stamp is not None else
                         datetime.datetime.utcnow().isoformat()),
                   ])
    if uid is not None:
        event['uid'] = uid
    event['data'] = data if data is not None else odict()
    return event

