/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.params;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.json.JSONObject;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.params.ExtensionParams;
import org.zaproxy.zap.extension.params.HtmlParameterStats;
import org.zaproxy.zap.extension.params.SiteParameters;
import org.zaproxy.zap.utils.ApiUtils;

public class ParamsAPI
extends ApiImplementor {
    private static final String PREFIX = "params";
    private static final String VIEW_PARAMS = "params";
    private static final String VIEW_PARAMS_PARAM_SITE = "site";
    private ExtensionParams extension;

    public ParamsAPI(ExtensionParams extensionParams) {
        this.extension = extensionParams;
        this.addApiView(new ApiView("params", new String[0], new String[]{VIEW_PARAMS_PARAM_SITE}));
    }

    @Override
    public String getPrefix() {
        return "params";
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        if ("params".equals(string)) {
            Object object;
            ApiResponseList apiResponseList = new ApiResponseList("Parameters");
            if (jSONObject.containsKey((Object)VIEW_PARAMS_PARAM_SITE) && !((String)(object = jSONObject.getString(VIEW_PARAMS_PARAM_SITE))).isEmpty()) {
                String string2 = ApiUtils.getAuthority((String)object);
                if (!this.extension.hasSite(string2)) {
                    throw new ApiException(ApiException.Type.DOES_NOT_EXIST, (String)object);
                }
                if (this.extension.hasParameters(string2)) {
                    apiResponseList.addItem(ParamsAPI.createSiteParamStatsResponse(this.extension.getSiteParameters(string2)));
                }
                return apiResponseList;
            }
            object = this.extension.getAllSiteParameters();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                SiteParameters siteParameters = (SiteParameters)iterator.next();
                apiResponseList.addItem(ParamsAPI.createSiteParamStatsResponse(siteParameters));
            }
            return apiResponseList;
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    private static ApiResponseList createSiteParamStatsResponse(SiteParameters siteParameters) {
        ApiResponseList apiResponseList = new ApiResponseList("Parameter");
        for (HtmlParameterStats htmlParameterStats : siteParameters.getParams()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(VIEW_PARAMS_PARAM_SITE, htmlParameterStats.getSite());
            hashMap.put("name", htmlParameterStats.getName());
            hashMap.put("type", htmlParameterStats.getType().name());
            hashMap.put("timesUsed", String.valueOf(htmlParameterStats.getTimesUsed()));
            apiResponseList.addItem(new ApiResponseSet("Stats", hashMap));
            ApiResponseList apiResponseList2 = new ApiResponseList("Flags");
            for (String string : htmlParameterStats.getFlags()) {
                apiResponseList2.addItem(new ApiResponseElement("Flag", string));
            }
            if (htmlParameterStats.getFlags().size() > 0) {
                apiResponseList.addItem(apiResponseList2);
            }
            ApiResponseList apiResponseList3 = new ApiResponseList("Values");
            for (String string : htmlParameterStats.getValues()) {
                apiResponseList3.addItem(new ApiResponseElement("Value", string));
            }
            if (htmlParameterStats.getValues().size() <= 0) continue;
            apiResponseList.addItem(apiResponseList3);
        }
        return apiResponseList;
    }
}

