/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderHtmlParser
extends SpiderParser {
    private static final Pattern urlPattern = Pattern.compile("url\\s*=\\s*([^;]+)", 2);
    private static final Pattern PLAIN_COMMENTS_URL_PATTERN = Pattern.compile("(?:http(?:s?):)?//[^\\x00-\\x1f\"'\\s<>#]+", 2);
    private SpiderParam params;

    public SpiderHtmlParser(SpiderParam spiderParam) {
        if (spiderParam == null) {
            throw new IllegalArgumentException("Parameter params must not be null.");
        }
        this.params = spiderParam;
    }

    @Override
    public boolean parseResource(HttpMessage httpMessage, Source source, int n) {
        Object object;
        if (source == null) {
            source = new Source((CharSequence)httpMessage.getResponseBody().toString());
        }
        String string = httpMessage.getRequestHeader().getURI().toString();
        Element element = source.getFirstElement("base");
        if (element != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Base tag was found in HTML: " + element.getDebugInfo()));
            }
            if ((object = element.getAttributeValue("href")) != null && !((String)object).isEmpty()) {
                string = object;
            }
        }
        this.parseSource(httpMessage, source, n, string);
        if (this.params.isParseComments()) {
            object = source.getAllStartTags(StartTagType.COMMENT);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                StartTag startTag = (StartTag)iterator.next();
                Source source2 = new Source((CharSequence)startTag.getTagContent());
                if (this.parseSource(httpMessage, source2, n, string)) continue;
                Matcher matcher = PLAIN_COMMENTS_URL_PATTERN.matcher(source2.toString());
                while (matcher.find()) {
                    this.processURL(httpMessage, n, matcher.group(), string);
                }
            }
        }
        return false;
    }

    private boolean parseSource(HttpMessage httpMessage, Source source, int n, String string) {
        log.debug((Object)"Parsing an HTML message...");
        boolean bl = false;
        List list = source.getAllElements("a");
        for (Element element : list) {
            bl |= this.processAttributeElement(httpMessage, n, string, element, "href");
        }
        list = source.getAllElements("area");
        for (Element element : list) {
            bl |= this.processAttributeElement(httpMessage, n, string, element, "href");
        }
        list = source.getAllElements("frame");
        for (Element element : list) {
            bl |= this.processAttributeElement(httpMessage, n, string, element, "src");
        }
        list = source.getAllElements("iframe");
        for (Element element : list) {
            bl |= this.processAttributeElement(httpMessage, n, string, element, "src");
        }
        list = source.getAllElements("link");
        for (Element element : list) {
            bl |= this.processAttributeElement(httpMessage, n, string, element, "href");
        }
        list = source.getAllElements("script");
        for (Element element : list) {
            bl |= this.processAttributeElement(httpMessage, n, string, element, "src");
        }
        list = source.getAllElements("img");
        for (Element element : list) {
            bl |= this.processAttributeElement(httpMessage, n, string, element, "src");
        }
        list = source.getAllElements("meta");
        for (Element element : list) {
            Matcher matcher;
            String string2 = element.getAttributeValue("http-equiv");
            String string3 = element.getAttributeValue("content");
            if (string2 == null || string3 == null || !string2.equalsIgnoreCase("refresh") && !string2.equalsIgnoreCase("location") || !(matcher = urlPattern.matcher(string3)).find()) continue;
            String string4 = matcher.group(1);
            this.processURL(httpMessage, n, string4, string);
            bl = true;
        }
        return bl;
    }

    private boolean processAttributeElement(HttpMessage httpMessage, int n, String string, Element element, String string2) {
        String string3 = element.getAttributeValue(string2);
        if (string3 == null) {
            return false;
        }
        this.processURL(httpMessage, n, string3, string);
        return true;
    }

    @Override
    public boolean canParseResource(HttpMessage httpMessage, String string, boolean bl) {
        return !bl && httpMessage.getResponseHeader().isHtml();
    }
}

