/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.desktop;

import com.sun.javafx.tk.Toolkit;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class PerformanceTrackerHelper {
    private static final PerformanceTrackerHelper instance = PerformanceTrackerHelper.createInstance();

    public static PerformanceTrackerHelper getInstance() {
        return instance;
    }

    private PerformanceTrackerHelper() {
    }

    private static PerformanceTrackerHelper createInstance() {
        return AccessController.doPrivileged(new PrivilegedAction<PerformanceTrackerHelper>(){

            @Override
            public PerformanceTrackerHelper run() {
                try {
                    if (System.getProperty("sun.perflog") != null) {
                        final PerformanceTrackerDefaultImpl performanceTrackerDefaultImpl = new PerformanceTrackerDefaultImpl();
                        if (System.getProperty("sun.perflog.fx.exitflush") != null) {
                            Runtime.getRuntime().addShutdownHook(new Thread(){

                                @Override
                                public void run() {
                                    performanceTrackerDefaultImpl.outputLog();
                                }
                            });
                        }
                        return performanceTrackerDefaultImpl;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return new PerformanceTrackerDummyImpl();
            }
        });
    }

    public abstract void logEvent(String var1);

    public abstract void outputLog();

    public abstract boolean isPerfLoggingEnabled();

    public final long nanoTime() {
        return Toolkit.getToolkit().getMasterTimer().nanos();
    }

    private static final class PerformanceTrackerDefaultImpl
    extends PerformanceTrackerHelper {
        private long firstTime;
        private long lastTime;
        private final Method logEventMethod;
        private final Method outputLogMethod;
        private final Method getStartTimeMethod;
        private final Method setStartTimeMethod;

        public PerformanceTrackerDefaultImpl() throws ClassNotFoundException, NoSuchMethodException {
            Class<?> clazz = Class.forName("sun.misc.PerformanceLogger", true, null);
            this.logEventMethod = clazz.getMethod("setTime", String.class);
            this.outputLogMethod = clazz.getMethod("outputLog", new Class[0]);
            this.getStartTimeMethod = clazz.getMethod("getStartTime", new Class[0]);
            this.setStartTimeMethod = clazz.getMethod("setStartTime", String.class, Long.TYPE);
        }

        @Override
        public void logEvent(final String string) {
            final long l = System.currentTimeMillis();
            if (this.firstTime == 0L) {
                this.firstTime = l;
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        PerformanceTrackerDefaultImpl.this.logEventMethod.invoke(null, "JavaFX> " + string + " (" + (l - PerformanceTrackerDefaultImpl.this.firstTime) + "ms total, " + (l - PerformanceTrackerDefaultImpl.this.lastTime) + "ms)");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
            this.lastTime = l;
        }

        @Override
        public void outputLog() {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    PerformanceTrackerDefaultImpl.this.logLaunchTime();
                    try {
                        PerformanceTrackerDefaultImpl.this.outputLogMethod.invoke(null, new Object[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }

        @Override
        public boolean isPerfLoggingEnabled() {
            return true;
        }

        private void logLaunchTime() {
            try {
                String string;
                if ((Long)this.getStartTimeMethod.invoke(null, new Object[0]) <= 0L && (string = System.getProperty("launchTime")) != null && !string.equals("")) {
                    long l = Long.parseLong(string);
                    this.setStartTimeMethod.invoke(null, "LaunchTime", l);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private static final class PerformanceTrackerDummyImpl
    extends PerformanceTrackerHelper {
        private PerformanceTrackerDummyImpl() {
        }

        @Override
        public void logEvent(String string) {
        }

        @Override
        public void outputLog() {
        }

        @Override
        public boolean isPerfLoggingEnabled() {
            return false;
        }
    }
}

