/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.initialization.AbstractClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScopeIdentifier;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassLoaderScope
extends AbstractClassLoaderScope {
    public static final String STRICT_MODE_PROPERTY = "org.gradle.classloaderscope.strict";
    private final ClassLoaderScope parent;
    private boolean locked;
    private ClassPath export = ClassPath.EMPTY;
    private List<ClassLoader> exportLoaders;
    private ClassPath local = ClassPath.EMPTY;
    private List<ClassLoader> ownLoaders;
    private MultiParentClassLoader exportingClassLoader;
    private MultiParentClassLoader localClassLoader;
    private ClassLoader effectiveLocalClassLoader;
    private ClassLoader effectiveExportClassLoader;

    public DefaultClassLoaderScope(ClassLoaderScopeIdentifier id, ClassLoaderScope parent, ClassLoaderCache classLoaderCache) {
        super(id, classLoaderCache);
        this.parent = parent;
    }

    private ClassLoader buildLockedLoader(ClassLoaderId id, ClassPath classPath) {
        if (classPath.isEmpty()) {
            return this.parent.getExportClassLoader();
        }
        return this.loader(id, classPath);
    }

    private ClassLoader buildLockedLoader(ClassLoaderId id, ClassLoader additional, ClassPath classPath) {
        if (classPath.isEmpty()) {
            return additional;
        }
        return new CachingClassLoader((ClassLoader)new MultiParentClassLoader(new ClassLoader[]{additional, this.loader(id, classPath)}));
    }

    private ClassLoader buildLockedLoader(ClassLoaderId id, ClassPath classPath, List<ClassLoader> loaders) {
        if (loaders != null) {
            return new CachingClassLoader((ClassLoader)this.buildMultiLoader(id, classPath, loaders));
        }
        if (!classPath.isEmpty()) {
            return this.buildLockedLoader(id, classPath);
        }
        return this.parent.getExportClassLoader();
    }

    private MultiParentClassLoader buildMultiLoader(ClassLoaderId id, ClassPath classPath, List<ClassLoader> loaders) {
        int numParents = 1;
        if (loaders != null) {
            numParents += loaders.size();
        }
        if (!classPath.isEmpty()) {
            ++numParents;
        }
        ArrayList<ClassLoader> parents = new ArrayList<ClassLoader>(numParents);
        parents.add(this.parent.getExportClassLoader());
        if (loaders != null) {
            parents.addAll(loaders);
        }
        if (!classPath.isEmpty()) {
            parents.add(this.loader(id, classPath));
        }
        return new MultiParentClassLoader(parents);
    }

    private void buildEffectiveLoaders() {
        if (this.effectiveLocalClassLoader == null) {
            boolean hasLocals;
            boolean hasExports = !this.export.isEmpty() || this.exportLoaders != null;
            boolean bl = hasLocals = !this.local.isEmpty();
            if (this.locked) {
                if (hasExports && hasLocals) {
                    this.effectiveExportClassLoader = this.buildLockedLoader(this.id.exportId(), this.export, this.exportLoaders);
                    this.effectiveLocalClassLoader = this.buildLockedLoader(this.id.localId(), this.effectiveExportClassLoader, this.local);
                } else if (hasLocals) {
                    this.classLoaderCache.remove(this.id.exportId());
                    this.effectiveLocalClassLoader = this.buildLockedLoader(this.id.localId(), this.local);
                    this.effectiveExportClassLoader = this.parent.getExportClassLoader();
                } else if (hasExports) {
                    this.classLoaderCache.remove(this.id.localId());
                    this.effectiveExportClassLoader = this.effectiveLocalClassLoader = this.buildLockedLoader(this.id.exportId(), this.export, this.exportLoaders);
                } else {
                    this.classLoaderCache.remove(this.id.localId());
                    this.classLoaderCache.remove(this.id.exportId());
                    this.effectiveLocalClassLoader = this.parent.getExportClassLoader();
                    this.effectiveExportClassLoader = this.parent.getExportClassLoader();
                }
            } else {
                if (Boolean.getBoolean(STRICT_MODE_PROPERTY)) {
                    throw new IllegalStateException("Attempt to define scope class loader before scope is locked");
                }
                this.exportingClassLoader = this.buildMultiLoader(this.id.exportId(), this.export, this.exportLoaders);
                this.effectiveExportClassLoader = new CachingClassLoader((ClassLoader)this.exportingClassLoader);
                this.localClassLoader = new MultiParentClassLoader(new ClassLoader[]{this.effectiveExportClassLoader, this.loader(this.id.localId(), this.local)});
                this.effectiveLocalClassLoader = new CachingClassLoader((ClassLoader)this.localClassLoader);
            }
            this.export = null;
            this.exportLoaders = null;
            this.local = null;
        }
    }

    @Override
    public ClassLoader getExportClassLoader() {
        this.buildEffectiveLoaders();
        return this.effectiveExportClassLoader;
    }

    @Override
    public ClassLoader getLocalClassLoader() {
        this.buildEffectiveLoaders();
        return this.effectiveLocalClassLoader;
    }

    @Override
    public ClassLoaderScope getParent() {
        return this.parent;
    }

    @Override
    public boolean defines(Class<?> clazz) {
        if (this.ownLoaders != null) {
            for (ClassLoader ownLoader : this.ownLoaders) {
                if (!ownLoader.equals(clazz.getClassLoader())) continue;
                return true;
            }
        }
        return false;
    }

    private ClassLoader loader(ClassLoaderId id, ClassPath classPath) {
        ClassLoader classLoader = this.classLoaderCache.get(id, classPath, this.parent.getExportClassLoader(), null);
        if (this.ownLoaders == null) {
            this.ownLoaders = new ArrayList<ClassLoader>();
        }
        this.ownLoaders.add(classLoader);
        return classLoader;
    }

    @Override
    public ClassLoaderScope local(ClassPath classPath) {
        if (classPath.isEmpty()) {
            return this;
        }
        this.assertNotLocked();
        if (this.localClassLoader != null) {
            ClassLoader loader = this.loader(this.id.localId(), classPath);
            this.localClassLoader.addParent(loader);
        } else {
            this.local = this.local.plus(classPath);
        }
        return this;
    }

    @Override
    public ClassLoaderScope export(ClassPath classPath) {
        if (classPath.isEmpty()) {
            return this;
        }
        this.assertNotLocked();
        if (this.exportingClassLoader != null) {
            this.exportingClassLoader.addParent(this.loader(this.id.exportId(), classPath));
        } else {
            this.export = this.export.plus(classPath);
        }
        return this;
    }

    @Override
    public ClassLoaderScope export(ClassLoader classLoader) {
        this.assertNotLocked();
        if (this.exportingClassLoader != null) {
            this.exportingClassLoader.addParent(classLoader);
        } else {
            if (this.exportLoaders == null) {
                this.exportLoaders = new ArrayList<ClassLoader>(1);
            }
            this.exportLoaders.add(classLoader);
        }
        return this;
    }

    private void assertNotLocked() {
        if (this.locked) {
            throw new IllegalStateException("class loader scope is locked");
        }
    }

    @Override
    public ClassLoaderScope lock() {
        this.locked = true;
        return this;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }
}

