/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileDetails;
import org.gradle.api.internal.changedetection.state.IgnoredPathFileSnapshot;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.SnapshotNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertySnapshotNormalizationStrategy;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.TaskPropertyActionContext;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.tasks.Classpath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    static final SnapshotNormalizationStrategy STRATEGY = new SnapshotNormalizationStrategy(){

        public boolean isPathAbsolute() {
            return false;
        }

        public NormalizedFileSnapshot getNormalizedSnapshot(FileDetails fileDetails, IncrementalFileSnapshot snapshot, StringInterner stringInterner) {
            if (fileDetails.isRoot()) {
                return new IgnoredPathFileSnapshot(snapshot);
            }
            return TaskFilePropertySnapshotNormalizationStrategy.getRelativeSnapshot(fileDetails, snapshot, stringInterner);
        }
    };

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return Classpath.class;
    }

    @Override
    public void attachActions(final TaskPropertyActionContext context) {
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(TaskInternal task, Callable<Object> futureValue) {
                task.getInputs().files(futureValue).withPropertyName(context.getName()).orderSensitive(true).withSnapshotNormalizationStrategy(STRATEGY);
            }
        });
    }
}

