/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import org.gradle.api.Action;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskInfo;
import org.gradle.execution.taskgraph.TaskPlanExecutor;
import org.gradle.internal.operations.BuildOperationWorkerRegistry;
import org.gradle.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTaskPlanExecutor
implements TaskPlanExecutor {
    private static final Logger LOGGER = Logging.getLogger(AbstractTaskPlanExecutor.class);

    AbstractTaskPlanExecutor() {
    }

    protected Runnable taskWorker(TaskExecutionPlan taskExecutionPlan, Action<? super TaskInternal> taskWorker, BuildOperationWorkerRegistry buildOperationWorkerRegistry) {
        return new TaskExecutorWorker(taskExecutionPlan, taskWorker, buildOperationWorkerRegistry);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskExecutorWorker
    implements Runnable {
        private final TaskExecutionPlan taskExecutionPlan;
        private final Action<? super TaskInternal> taskWorker;
        private final BuildOperationWorkerRegistry buildOperationWorkerRegistry;

        private TaskExecutorWorker(TaskExecutionPlan taskExecutionPlan, Action<? super TaskInternal> taskWorker, BuildOperationWorkerRegistry buildOperationWorkerRegistry) {
            this.taskExecutionPlan = taskExecutionPlan;
            this.taskWorker = taskWorker;
            this.buildOperationWorkerRegistry = buildOperationWorkerRegistry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TaskInfo task;
            long busy = 0L;
            long start = System.currentTimeMillis();
            while ((task = this.taskExecutionPlan.getTaskToExecute()) != null) {
                BuildOperationWorkerRegistry.Completion completion = this.buildOperationWorkerRegistry.operationStart();
                try {
                    String taskPath = task.getTask().getPath();
                    LOGGER.info("{} ({}) started.", (Object)taskPath, (Object)Thread.currentThread());
                    long startTask = System.currentTimeMillis();
                    this.processTask(task);
                    long taskDuration = System.currentTimeMillis() - startTask;
                    busy += taskDuration;
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("{} ({}) completed. Took {}.", new Object[]{taskPath, Thread.currentThread(), Clock.prettyTime(taskDuration)});
                }
                finally {
                    completion.operationFinish();
                }
            }
            long total = System.currentTimeMillis() - start;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Task worker [{}] finished, busy: {}, idle: {}", new Object[]{Thread.currentThread(), Clock.prettyTime(busy), Clock.prettyTime(total - busy)});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processTask(TaskInfo taskInfo) {
            try {
                this.taskWorker.execute((Object)taskInfo.getTask());
            }
            catch (Throwable e) {
                taskInfo.setExecutionFailure(e);
            }
            finally {
                this.taskExecutionPlan.taskComplete(taskInfo);
            }
        }
    }
}

