/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.logging.StandardOutputListener;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.util.Clock;

public class DefaultBuildRequestContext
implements BuildRequestContext {
    private final BuildCancellationToken token;
    private final BuildEventConsumer buildEventConsumer;
    private final BuildRequestMetaData metaData;
    private final StandardOutputListener outputListener;
    private final StandardOutputListener errorListener;

    public DefaultBuildRequestContext(BuildRequestMetaData metaData, BuildCancellationToken token, BuildEventConsumer buildEventConsumer, StandardOutputListener outputListener, StandardOutputListener errorListener) {
        this.metaData = metaData;
        this.token = token;
        this.buildEventConsumer = buildEventConsumer;
        this.outputListener = outputListener;
        this.errorListener = errorListener;
    }

    public DefaultBuildRequestContext(BuildRequestMetaData metaData, BuildCancellationToken token, BuildEventConsumer buildEventConsumer) {
        this(metaData, token, buildEventConsumer, new NoOpListener(), new NoOpListener());
    }

    public BuildEventConsumer getEventConsumer() {
        return this.buildEventConsumer;
    }

    public BuildCancellationToken getCancellationToken() {
        return this.token;
    }

    public BuildClientMetaData getClient() {
        return this.metaData.getClient();
    }

    public Clock getBuildTimeClock() {
        return this.metaData.getBuildTimeClock();
    }

    public StandardOutputListener getErrorListener() {
        return this.errorListener;
    }

    public StandardOutputListener getOutputListener() {
        return this.outputListener;
    }

    private static class NoOpListener
    implements StandardOutputListener {
        private NoOpListener() {
        }

        public void onOutput(CharSequence output) {
        }
    }
}

