/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildevents;

import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.cache.statistics.TaskExecutionStatistics;
import org.gradle.api.internal.tasks.cache.statistics.TaskExecutionStatisticsListener;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.buildevents.BuildResultLogger;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;

public class CacheStatisticsReporter
implements TaskExecutionStatisticsListener {
    private final StyledTextOutputFactory textOutputFactory;

    public CacheStatisticsReporter(StyledTextOutputFactory textOutputFactory) {
        this.textOutputFactory = textOutputFactory;
    }

    public void buildFinished(TaskExecutionStatistics statistics) {
        StyledTextOutput textOutput = this.textOutputFactory.create(BuildResultLogger.class, LogLevel.LIFECYCLE);
        textOutput.println();
        int allTasks = statistics.getAllTasksCount();
        int allExecutedTasks = statistics.getTasksCount(TaskExecutionOutcome.EXECUTED);
        int skippedTasks = statistics.getTasksCount(TaskExecutionOutcome.SKIPPED);
        int upToDateTasks = statistics.getTasksCount(TaskExecutionOutcome.UP_TO_DATE);
        int fromCacheTasks = statistics.getTasksCount(TaskExecutionOutcome.FROM_CACHE);
        int cacheableExecutedTasks = statistics.getCacheMissCount();
        int nonCacheableExecutedTasks = allExecutedTasks - cacheableExecutedTasks;
        textOutput.formatln("%d tasks in build, out of which %d (%d%%) were executed", new Object[]{allTasks, allExecutedTasks, CacheStatisticsReporter.roundedPercentOf(allExecutedTasks, allTasks)});
        this.statisticsLine(textOutput, skippedTasks, allTasks, "skipped");
        this.statisticsLine(textOutput, upToDateTasks, allTasks, "up-to-date");
        this.statisticsLine(textOutput, fromCacheTasks, allTasks, "loaded from cache");
        this.statisticsLine(textOutput, cacheableExecutedTasks, allTasks, "cache miss");
        this.statisticsLine(textOutput, nonCacheableExecutedTasks, allTasks, "not cacheable");
    }

    private void statisticsLine(StyledTextOutput textOutput, int fraction, int total, String description) {
        if (fraction > 0) {
            int numberLength = Integer.toString(total).length();
            String percent = String.format("(%d%%)", CacheStatisticsReporter.roundedPercentOf(fraction, total));
            textOutput.formatln("%" + numberLength + "d %6s %s", new Object[]{fraction, percent, description});
        }
    }

    private static int roundedPercentOf(int fraction, int total) {
        return total == 0 ? 0 : (int)Math.round(100.0 * (double)fraction / (double)total);
    }
}

