/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.request;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.gradle.process.internal.worker.request.RequestProtocol;
import org.gradle.process.internal.worker.request.ResponseProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerAction
implements Action<WorkerProcessContext>,
Serializable,
RequestProtocol {
    private final String workerImplementationName;
    private transient CountDownLatch completed;
    private transient ResponseProtocol responder;
    private transient Throwable failure;
    private transient Class<?> workerImplementation;
    private transient Object implementation;

    public WorkerAction(Class<?> workerImplementation) {
        this.workerImplementationName = workerImplementation.getName();
    }

    public void execute(WorkerProcessContext workerProcessContext) {
        this.completed = new CountDownLatch(1);
        try {
            this.workerImplementation = Class.forName(this.workerImplementationName);
            this.implementation = this.workerImplementation.newInstance();
        }
        catch (Throwable e) {
            this.failure = e;
        }
        ObjectConnection connection = workerProcessContext.getServerConnection();
        connection.addIncoming(RequestProtocol.class, (Object)this);
        this.responder = (ResponseProtocol)connection.addOutgoing(ResponseProtocol.class);
        connection.connect();
        try {
            this.completed.await();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.completed.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runThenStop(String methodName, Class<?>[] paramTypes, Object[] args) {
        try {
            this.run(methodName, paramTypes, args);
        }
        finally {
            this.stop();
        }
    }

    @Override
    public void run(String methodName, Class<?>[] paramTypes, Object[] args) {
        if (this.failure != null) {
            this.responder.infrastructureFailed(this.failure);
            return;
        }
        try {
            Object result;
            Method method = this.workerImplementation.getDeclaredMethod(methodName, paramTypes);
            try {
                result = method.invoke(this.implementation, args);
            }
            catch (InvocationTargetException e) {
                Throwable failure = e.getCause();
                if (failure instanceof NoClassDefFoundError) {
                    this.responder.infrastructureFailed(failure);
                } else {
                    this.responder.failed(failure);
                }
                return;
            }
            this.responder.completed(result);
        }
        catch (Throwable t) {
            this.responder.infrastructureFailed(t);
        }
    }
}

