/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.scaninfo;

import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.internal.event.ListenerManager;
import org.gradle.launcher.daemon.registry.DaemonRegistry;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationListener;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.scaninfo.DaemonScanInfo;
import org.gradle.launcher.daemon.server.stats.DaemonRunningStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDaemonScanInfo
implements DaemonScanInfo {
    private final DaemonRunningStats stats;
    private final long idleTimeout;
    private final DaemonRegistry daemonRegistry;
    private final ListenerManager listenerManager;

    public DefaultDaemonScanInfo(DaemonRunningStats stats, long idleTimeout, DaemonRegistry daemonRegistry, ListenerManager listenerManager) {
        this.stats = stats;
        this.idleTimeout = idleTimeout;
        this.daemonRegistry = daemonRegistry;
        this.listenerManager = listenerManager;
    }

    @Override
    public int getNumberOfBuilds() {
        return this.stats.getBuildCount();
    }

    @Override
    public long getStartedAt() {
        return this.stats.getStartTime();
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public int getNumberOfRunningDaemons() {
        return this.daemonRegistry.getAll().size();
    }

    @Override
    public void notifyOnUnhealthy(final Action<? super String> listener) {
        final DaemonExpirationListener daemonExpirationListener = new DaemonExpirationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onExpirationEvent(DaemonExpirationResult result) {
                if (result.getStatus() == DaemonExpirationStatus.GRACEFUL_EXPIRE) {
                    try {
                        listener.execute(result.getReason());
                    }
                    finally {
                        DefaultDaemonScanInfo.this.listenerManager.removeListener((Object)this);
                    }
                }
            }
        };
        this.listenerManager.addListener((Object)daemonExpirationListener);
        this.listenerManager.addListener((Object)new BuildAdapter(){

            public void buildFinished(BuildResult result) {
                DefaultDaemonScanInfo.this.listenerManager.removeListener((Object)daemonExpirationListener);
            }
        });
    }
}

