/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.tasks.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.lang.IncompleteArgumentException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.gradle.api.internal.tasks.cache.TaskCacheKey;
import org.gradle.api.internal.tasks.cache.TaskOutputCache;
import org.gradle.api.internal.tasks.cache.TaskOutputReader;
import org.gradle.api.internal.tasks.cache.TaskOutputWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTaskOutputCache
implements TaskOutputCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTaskOutputCache.class);
    private final URI root;

    public HttpTaskOutputCache(URI root) {
        if (!root.getPath().endsWith("/")) {
            throw new IncompleteArgumentException("HTTP cache root URI must end with '/'");
        }
        this.root = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(TaskCacheKey key, TaskOutputReader reader) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            CloseableHttpResponse response;
            block9: {
                boolean bl;
                URI uri = this.root.resolve("./" + key.getHashCode());
                HttpGet httpGet = new HttpGet(uri);
                response = httpClient.execute((HttpUriRequest)httpGet);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Response for GET {}: {}", (Object)uri, (Object)response.getStatusLine());
                }
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode < 200 || statusCode >= 300) break block9;
                    reader.readFrom(response.getEntity().getContent());
                    bl = true;
                }
                catch (Throwable throwable) {
                    response.close();
                    throw throwable;
                }
                response.close();
                return bl;
            }
            boolean bl = false;
            response.close();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(TaskCacheKey key, final TaskOutputWriter output) throws IOException {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            URI uri = this.root.resolve(key.getHashCode());
            HttpPut httpPut = new HttpPut(uri);
            httpPut.setEntity((HttpEntity)new AbstractHttpEntity(){

                public boolean isRepeatable() {
                    return true;
                }

                public long getContentLength() {
                    return -1L;
                }

                public InputStream getContent() throws IOException, UnsupportedOperationException {
                    throw new UnsupportedOperationException();
                }

                public void writeTo(OutputStream outstream) throws IOException {
                    output.writeTo(outstream);
                }

                public boolean isStreaming() {
                    return false;
                }
            });
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response for PUT {}: {}", (Object)uri, (Object)response.getStatusLine());
            }
        }
    }

    public String getDescription() {
        return "HTTP cache at " + this.root;
    }
}

