/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.composite.internal.DefaultIncludedBuilds;
import org.gradle.composite.internal.IncludedBuildDependencySubstitutionsBuilder;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.internal.composite.CompositeContextBuilder;

public class DefaultCompositeContextBuilder
implements CompositeContextBuilder {
    private static final Logger LOGGER = Logging.getLogger(DefaultCompositeContextBuilder.class);
    private final DefaultIncludedBuilds allIncludedBuilds;
    private final CompositeBuildContext context;

    public DefaultCompositeContextBuilder(DefaultIncludedBuilds allIncludedBuilds, CompositeBuildContext context) {
        this.allIncludedBuilds = allIncludedBuilds;
        this.context = context;
    }

    public void addToCompositeContext(Iterable<IncludedBuild> includedBuilds) {
        IncludedBuildDependencySubstitutionsBuilder contextBuilder = new IncludedBuildDependencySubstitutionsBuilder(this.context);
        for (IncludedBuild includedBuild : includedBuilds) {
            this.allIncludedBuilds.registerBuild(includedBuild);
            this.doAddToCompositeContext((IncludedBuildInternal)includedBuild, contextBuilder);
        }
    }

    private void doAddToCompositeContext(IncludedBuildInternal build, IncludedBuildDependencySubstitutionsBuilder contextBuilder) {
        DependencySubstitutionsInternal substitutions = build.resolveDependencySubstitutions();
        if (!substitutions.hasRules()) {
            LOGGER.lifecycle("[composite-build] Configuring build: " + build.getProjectDir());
            contextBuilder.build(build);
        } else {
            this.context.registerSubstitution(substitutions.getRuleAction());
        }
    }
}

