/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.base.Preconditions;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.TaskReferenceResolver;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskInstantiationException;
import org.gradle.api.tasks.TaskReference;
import org.gradle.composite.internal.CompositeBuildTaskDelegate;
import org.gradle.composite.internal.IncludedBuildTaskReference;

public class IncludedBuildTaskReferenceResolver
implements TaskReferenceResolver {
    public Task constructTask(TaskReference reference, TaskContainer tasks) {
        if (!(reference instanceof IncludedBuildTaskReference)) {
            return null;
        }
        final IncludedBuildTaskReference ref = (IncludedBuildTaskReference)reference;
        String delegateTaskName = ref.getBuildName();
        Task task = (Task)tasks.findByName(delegateTaskName);
        if (task == null) {
            return tasks.create(delegateTaskName, CompositeBuildTaskDelegate.class, (Action)new Action<CompositeBuildTaskDelegate>(){

                public void execute(CompositeBuildTaskDelegate compositeBuildTaskDelegate) {
                    compositeBuildTaskDelegate.setBuild(ref.getBuildName());
                    compositeBuildTaskDelegate.addTask(ref.getTaskPath());
                }
            });
        }
        if (task instanceof CompositeBuildTaskDelegate) {
            CompositeBuildTaskDelegate delegateTask = (CompositeBuildTaskDelegate)task;
            Preconditions.checkState((boolean)((CompositeBuildTaskDelegate)task).getBuild().equals(ref.getBuildName()));
            delegateTask.addTask(ref.getTaskPath());
            return task;
        }
        throw new TaskInstantiationException("Cannot create delegating task '" + delegateTaskName + "' as task with same name already exists.");
    }
}

