/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.gradle.authentication.Authentication;
import org.gradle.authentication.http.BasicAuthentication;
import org.gradle.authentication.http.DigestAuthentication;
import org.gradle.internal.authentication.AllSchemesAuthentication;
import org.gradle.internal.resource.connector.ResourceConnectorFactory;
import org.gradle.internal.resource.connector.ResourceConnectorSpecification;
import org.gradle.internal.resource.transfer.DefaultExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceLister;
import org.gradle.internal.resource.transfer.ExternalResourceUploader;
import org.gradle.internal.resource.transport.http.DefaultHttpSettings;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpResourceAccessor;
import org.gradle.internal.resource.transport.http.HttpResourceLister;
import org.gradle.internal.resource.transport.http.HttpResourceUploader;
import org.gradle.internal.resource.transport.http.SslContextFactory;

public class HttpConnectorFactory
implements ResourceConnectorFactory {
    private SslContextFactory sslContextFactory;

    public HttpConnectorFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    public Set<String> getSupportedProtocols() {
        return Sets.newHashSet((Object[])new String[]{"http", "https"});
    }

    public Set<Class<? extends Authentication>> getSupportedAuthentication() {
        HashSet<Class<? extends Authentication>> supported = new HashSet<Class<? extends Authentication>>();
        supported.add(BasicAuthentication.class);
        supported.add(DigestAuthentication.class);
        supported.add(AllSchemesAuthentication.class);
        return supported;
    }

    public ExternalResourceConnector createResourceConnector(ResourceConnectorSpecification connectionDetails) {
        HttpClientHelper http = new HttpClientHelper(new DefaultHttpSettings(connectionDetails.getAuthentications(), this.sslContextFactory));
        HttpResourceAccessor accessor = new HttpResourceAccessor(http);
        HttpResourceLister lister = new HttpResourceLister(accessor);
        HttpResourceUploader uploader = new HttpResourceUploader(http);
        return new DefaultExternalResourceConnector((ExternalResourceAccessor)accessor, (ExternalResourceLister)lister, (ExternalResourceUploader)uploader);
    }
}

