/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceFile;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmPackagePartSource
implements SourceElement {
    @NotNull
    private final JvmClassName className;
    @Nullable
    private final JvmClassName facadeClassName;

    @NotNull
    public final Name getSimpleName() {
        Name name = Name.identifier(StringsKt.substringAfterLast$default((String)this.className.getInternalName(), (char)'/', null, (int)2, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(classNam\u2026.substringAfterLast('/'))");
        return name;
    }

    @NotNull
    public final ClassId getClassId() {
        return new ClassId(this.className.getPackageFqName(), this.getSimpleName());
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.className;
    }

    @Override
    @NotNull
    public SourceFile getContainingFile() {
        SourceFile sourceFile = SourceFile.NO_SOURCE_FILE;
        Intrinsics.checkExpressionValueIsNotNull((Object)sourceFile, (String)"SourceFile.NO_SOURCE_FILE");
        return sourceFile;
    }

    @NotNull
    public final JvmClassName getClassName() {
        return this.className;
    }

    @Nullable
    public final JvmClassName getFacadeClassName() {
        return this.facadeClassName;
    }

    public JvmPackagePartSource(@NotNull JvmClassName className, @Nullable JvmClassName facadeClassName) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        this.className = className;
        this.facadeClassName = facadeClassName;
    }

    public JvmPackagePartSource(@NotNull KotlinJvmBinaryClass kotlinClass) {
        JvmClassName jvmClassName;
        Intrinsics.checkParameterIsNotNull((Object)kotlinClass, (String)"kotlinClass");
        JvmPackagePartSource jvmPackagePartSource = this;
        JvmClassName jvmClassName2 = JvmClassName.byClassId(kotlinClass.getClassId());
        JvmClassName jvmClassName3 = jvmClassName2;
        Intrinsics.checkExpressionValueIsNotNull((Object)jvmClassName2, (String)"JvmClassName.byClassId(kotlinClass.classId)");
        String string = kotlinClass.getClassHeader().getMultifileClassName();
        if (string != null) {
            String string2 = string;
            JvmClassName jvmClassName4 = jvmClassName3;
            JvmPackagePartSource jvmPackagePartSource2 = jvmPackagePartSource;
            String it = string2;
            CharSequence charSequence = it;
            JvmClassName jvmClassName5 = charSequence.length() > 0 ? JvmClassName.byInternalName(it) : (JvmClassName)null;
            jvmPackagePartSource = jvmPackagePartSource2;
            jvmClassName3 = jvmClassName4;
            jvmClassName = jvmClassName5;
        } else {
            jvmClassName = null;
        }
        jvmPackagePartSource(jvmClassName3, jvmClassName);
    }
}

