/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.queue;

import java.util.concurrent.LinkedBlockingQueue;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionQueue<R extends Request> {
    private final Logger logger = Logging.getLogger(ExecutionQueue.class);
    private volatile LinkedBlockingQueue<R> requests = new LinkedBlockingQueue();
    private Thread executionThread;

    public ExecutionQueue(ExecutionInteraction<R> executeInteraction) {
        this.executionThread = new Thread(new ExecutionThread(executeInteraction));
        this.executionThread.setContextClassLoader(this.getClass().getClassLoader());
        this.executionThread.start();
    }

    public void addRequestToQueue(R request) {
        this.requests.offer(request);
    }

    public boolean removeRequestFromQueue(Request request) {
        return this.requests.remove(request);
    }

    private R getNextAvailableRequest() {
        try {
            return (R)((Request)this.requests.take());
        }
        catch (InterruptedException e) {
            this.logger.error("Getting next available request", (Throwable)e);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecutionThread
    implements Runnable {
        private ExecutionInteraction<R> executeInteraction;

        private ExecutionThread(ExecutionInteraction<R> executeInteraction) {
            this.executeInteraction = executeInteraction;
        }

        @Override
        public void run() {
            Request request;
            while ((request = ExecutionQueue.this.getNextAvailableRequest()) != null) {
                this.executeInteraction.execute(request);
            }
            return;
        }
    }

    public static interface RequestCancellation {
        public void onCancel(Request var1);
    }

    public static interface Request {
        public Type getType();

        public static interface Type {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExecutionInteraction<R> {
        public void execute(R var1);
    }
}

