/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.publisher;

import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishException;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ArtifactPublisher;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ConfigurationComponentMetaDataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.publisher.IvyDependencyPublisher;
import org.gradle.api.internal.artifacts.ivyservice.publisher.IvyModuleDescriptorWriter;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.internal.component.external.model.BuildableIvyModulePublishMetadata;
import org.gradle.internal.component.external.model.DefaultIvyModulePublishMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;

public class IvyBackedArtifactPublisher
implements ArtifactPublisher {
    private final ConfigurationComponentMetaDataBuilder configurationComponentMetaDataBuilder;
    private final IvyDependencyPublisher dependencyPublisher;
    private final IvyModuleDescriptorWriter ivyModuleDescriptorWriter;

    public IvyBackedArtifactPublisher(ConfigurationComponentMetaDataBuilder configurationComponentMetaDataBuilder, IvyDependencyPublisher dependencyPublisher, IvyModuleDescriptorWriter ivyModuleDescriptorWriter) {
        this.configurationComponentMetaDataBuilder = configurationComponentMetaDataBuilder;
        this.dependencyPublisher = dependencyPublisher;
        this.ivyModuleDescriptorWriter = ivyModuleDescriptorWriter;
    }

    @Override
    public void publish(Iterable<? extends PublicationAwareRepository> repositories, Module module, Configuration configuration, File descriptor) throws PublishException {
        BuildableIvyModulePublishMetadata publishMetaData;
        Set allConfigurations = configuration.getAll();
        Set configurationsToPublish = configuration.getHierarchy();
        if (descriptor != null) {
            publishMetaData = this.toPublishMetaData(module, allConfigurations);
            this.ivyModuleDescriptorWriter.write(publishMetaData, descriptor);
        }
        publishMetaData = this.toPublishMetaData(module, configurationsToPublish);
        if (descriptor != null) {
            DefaultIvyArtifactName artifact = new DefaultIvyArtifactName("ivy", "ivy", "xml");
            publishMetaData.addArtifact(artifact, descriptor);
        }
        ArrayList<ModuleVersionPublisher> publishResolvers = new ArrayList<ModuleVersionPublisher>();
        for (PublicationAwareRepository publicationAwareRepository : repositories) {
            ModuleVersionPublisher publisher = publicationAwareRepository.createPublisher();
            publishResolvers.add(publisher);
        }
        this.dependencyPublisher.publish(publishResolvers, publishMetaData);
    }

    private BuildableIvyModulePublishMetadata toPublishMetaData(Module module, Set<? extends Configuration> configurations) {
        ModuleComponentIdentifier id = DefaultModuleComponentIdentifier.newId(module.getGroup(), module.getName(), module.getVersion());
        DefaultIvyModulePublishMetadata publishMetaData = new DefaultIvyModulePublishMetadata(id, module.getStatus());
        this.configurationComponentMetaDataBuilder.addConfigurations(publishMetaData, configurations);
        return publishMetaData;
    }
}

