/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactResults;

public class DefaultResolvedArtifactResults
implements ResolvedArtifactResults {
    private Map<Long, ArtifactSet> artifactSets = Maps.newLinkedHashMap();
    private Set<ResolvedArtifact> artifacts;
    private Map<Long, Set<ResolvedArtifact>> resolvedArtifactsById;

    @Override
    public Set<ResolvedArtifact> getArtifacts() {
        this.assertArtifactsResolved();
        return Sets.newLinkedHashSet(this.artifacts);
    }

    @Override
    public Set<ResolvedArtifact> getArtifacts(long id) {
        this.assertArtifactsResolved();
        Set<ResolvedArtifact> a = this.resolvedArtifactsById.get(id);
        assert (a != null) : "Unable to find artifacts for id: " + id;
        return a;
    }

    public void addArtifactSet(ArtifactSet artifactSet) {
        this.artifactSets.put(artifactSet.getId(), artifactSet);
    }

    public void resolveNow() {
        if (this.artifacts == null) {
            this.artifacts = Sets.newLinkedHashSet();
            this.resolvedArtifactsById = Maps.newLinkedHashMap();
            for (Map.Entry<Long, ArtifactSet> entry : this.artifactSets.entrySet()) {
                Set<ResolvedArtifact> resolvedArtifacts = entry.getValue().getArtifacts();
                this.artifacts.addAll(resolvedArtifacts);
                this.resolvedArtifactsById.put(entry.getKey(), resolvedArtifacts);
            }
            this.artifactSets = null;
        }
    }

    private void assertArtifactsResolved() {
        if (this.artifacts == null) {
            throw new IllegalStateException("Cannot access artifacts before they are explicitly resolved.");
        }
    }
}

