/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import java.util.Map;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.DefaultDependencyResult;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class DependencyResultSerializer {
    private static final byte SUCCESSFUL = 0;
    private static final byte FAILED = 1;
    private final ComponentSelectorSerializer componentSelectorSerializer = new ComponentSelectorSerializer();
    private final ComponentSelectionReasonSerializer componentSelectionReasonSerializer = new ComponentSelectionReasonSerializer();

    public DependencyResult read(Decoder decoder, Map<ComponentSelector, ModuleVersionResolveException> failures) throws IOException {
        ComponentSelector requested = this.componentSelectorSerializer.read(decoder);
        byte resultByte = decoder.readByte();
        if (resultByte == 0) {
            Long selectedId = decoder.readSmallLong();
            return new DefaultDependencyResult(requested, selectedId, null, null);
        }
        if (resultByte == 1) {
            ComponentSelectionReason reason = this.componentSelectionReasonSerializer.read(decoder);
            ModuleVersionResolveException failure = failures.get(requested);
            return new DefaultDependencyResult(requested, null, reason, failure);
        }
        throw new IllegalArgumentException("Unknown result byte: " + resultByte);
    }

    public void write(Encoder encoder, DependencyResult value) throws IOException {
        this.componentSelectorSerializer.write(encoder, value.getRequested());
        if (value.getFailure() == null) {
            encoder.writeByte((byte)0);
            encoder.writeSmallLong(value.getSelected().longValue());
        } else {
            encoder.writeByte((byte)1);
            this.componentSelectionReasonSerializer.write(encoder, value.getReason());
        }
    }
}

