/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.BuildableComponentSelectionResult;

public class DefaultBuildableComponentSelectionResult
implements BuildableComponentSelectionResult {
    private BuildableComponentSelectionResult.State state = BuildableComponentSelectionResult.State.Unknown;
    private ModuleComponentIdentifier moduleComponentIdentifier;
    private ModuleVersionResolveException failure;
    private final Set<String> unmatchedVersions = new LinkedHashSet<String>();
    private final Set<String> rejectedVersions = new LinkedHashSet<String>();

    @Override
    public void matches(ModuleComponentIdentifier moduleComponentIdentifier) {
        this.setChosenComponentWithReason(BuildableComponentSelectionResult.State.Match, moduleComponentIdentifier);
    }

    @Override
    public void noMatchFound() {
        this.setChosenComponentWithReason(BuildableComponentSelectionResult.State.NoMatch, null);
    }

    private void setChosenComponentWithReason(BuildableComponentSelectionResult.State state, ModuleComponentIdentifier moduleComponentIdentifier) {
        this.state = state;
        this.moduleComponentIdentifier = moduleComponentIdentifier;
        this.failure = null;
    }

    @Override
    public BuildableComponentSelectionResult.State getState() {
        return this.state;
    }

    @Override
    public ModuleComponentIdentifier getMatch() {
        if (this.state != BuildableComponentSelectionResult.State.Match) {
            throw new IllegalStateException("This result has not been resolved.");
        }
        return this.moduleComponentIdentifier;
    }

    @Override
    public boolean hasResult() {
        return this.state != BuildableComponentSelectionResult.State.Unknown;
    }

    @Override
    @Nullable
    public ModuleVersionResolveException getFailure() {
        if (this.state == BuildableComponentSelectionResult.State.Unknown) {
            throw new IllegalStateException("This result has not been resolved.");
        }
        return this.failure;
    }

    @Override
    public void failed(ModuleVersionResolveException failure) {
        this.moduleComponentIdentifier = null;
        this.failure = failure;
        this.state = BuildableComponentSelectionResult.State.Failed;
    }

    public Set<String> getUnmatchedVersions() {
        return this.unmatchedVersions;
    }

    @Override
    public void notMatched(String candidateVersion) {
        this.unmatchedVersions.add(candidateVersion);
    }

    public Set<String> getRejectedVersions() {
        return this.rejectedVersions;
    }

    @Override
    public void rejected(String version) {
        this.rejectedVersions.add(version);
    }
}

