/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiBinaryExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;

public abstract class JavaRecursiveElementVisitor
extends JavaElementVisitor {
    private final Stack<PsiReferenceExpression> myRefExprsInVisit = new Stack();
    private final Stack<PsiBinaryExpression> myBinaryExpressions = new Stack();

    @Override
    public void visitElement(PsiElement element) {
        if (!this.myRefExprsInVisit.isEmpty() && this.myRefExprsInVisit.peek() == element) {
            this.myRefExprsInVisit.pop();
            this.myRefExprsInVisit.push(null);
        } else if (element instanceof PsiBinaryExpression) {
            if (!this.myBinaryExpressions.isEmpty() && this.myBinaryExpressions.peek() == element) {
                return;
            }
            PsiElement child = element.getFirstChild();
            while (child != null) {
                if (child instanceof PsiBinaryExpression) {
                    this.myBinaryExpressions.push((PsiBinaryExpression)child);
                }
                child.accept(this);
                if ((child = child.getNextSibling()) != null || (child = this.myBinaryExpressions.isEmpty() ? null : this.myBinaryExpressions.pop()) == null) continue;
                child = child.getFirstChild();
            }
        } else {
            element.acceptChildren(this);
        }
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression) {
        this.myRefExprsInVisit.push(expression);
        try {
            this.visitExpression(expression);
            this.visitReferenceElement(expression);
        }
        finally {
            this.myRefExprsInVisit.pop();
        }
    }
}

