/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public interface PsiReference {
    public static final PsiReference[] EMPTY_ARRAY = new PsiReference[0];
    public static final ArrayFactory<PsiReference> ARRAY_FACTORY = new ArrayFactory<PsiReference>(){

        @NotNull
        public PsiReference[] create(int count) {
            PsiReference[] psiReferenceArray = count == 0 ? EMPTY_ARRAY : new PsiReference[count];
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/PsiReference$1", "create"));
            }
            return psiReferenceArray;
        }
    };

    public PsiElement getElement();

    public TextRange getRangeInElement();

    @Nullable
    public PsiElement resolve();

    @NotNull
    public String getCanonicalText();

    public PsiElement handleElementRename(String var1) throws IncorrectOperationException;

    public PsiElement bindToElement(@NotNull PsiElement var1) throws IncorrectOperationException;

    public boolean isReferenceTo(PsiElement var1);

    @NotNull
    public Object[] getVariants();

    public boolean isSoft();
}

