/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc;

import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaDocTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameIdentifierOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.JavadocTagInfo;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocTagValue;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocToken;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

class SeeDocTagInfo
implements JavadocTagInfo {
    private final String myName;
    private final boolean myInline;

    public SeeDocTagInfo(@NonNls String name, boolean isInline) {
        this.myName = name;
        this.myInline = isInline;
    }

    @Override
    public String checkTagValue(PsiDocTagValue value) {
        return null;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public Object[] getPossibleValues(PsiElement context, PsiElement place, String prefix) {
        if (place instanceof PsiDocToken) {
            PsiDocToken token = (PsiDocToken)place;
            if (token.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
                return this.getPossibleMethodsAndFields(context, place, prefix);
            }
            if (token.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_LPAREN) {
                PsiMethod[] methods2;
                if (token.getPrevSibling() == null) {
                    return ArrayUtil.EMPTY_OBJECT_ARRAY;
                }
                String methodName = token.getPrevSibling().getText();
                PsiElement targetContext = this.getTargetContext(context, place);
                ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>();
                for (PsiMethod method : methods2 = PsiDocMethodOrFieldRef.getAllMethods(targetContext, place)) {
                    if (!method.getName().equals(methodName)) continue;
                    result2.add(method);
                }
                return ArrayUtil.toObjectArray(result2);
            }
            if (token.getTokenType() == JavaDocTokenType.DOC_TAG_VALUE_TOKEN && place.getParent() instanceof PsiDocMethodOrFieldRef) {
                return this.getPossibleMethodsAndFields(context, place, prefix);
            }
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private Object[] getPossibleMethodsAndFields(PsiElement context, PsiElement place, String prefix) {
        PsiVariable[] variables;
        PsiMethod[] methods2;
        ArrayList<PsiNameIdentifierOwner> result2 = new ArrayList<PsiNameIdentifierOwner>();
        PsiElement targetContext = this.getTargetContext(context, place);
        for (PsiMethod method : methods2 = PsiDocMethodOrFieldRef.getAllMethods(targetContext, place)) {
            result2.add(method);
        }
        for (PsiVariable variable : variables = PsiDocMethodOrFieldRef.getAllVariables(targetContext, place)) {
            result2.add(variable);
        }
        return ArrayUtil.toObjectArray(result2);
    }

    private PsiElement getTargetContext(PsiElement context, PsiElement place) {
        PsiJavaCodeReferenceElement referenceElement;
        PsiElement element;
        PsiDocMethodOrFieldRef methodRef;
        IElementType firstChildType;
        PsiElement targetContext = context;
        if (place.getParent() instanceof PsiDocMethodOrFieldRef && ((firstChildType = (methodRef = (PsiDocMethodOrFieldRef)place.getParent()).getFirstChildNode().getElementType()) == JavaElementType.JAVA_CODE_REFERENCE || firstChildType == JavaElementType.REFERENCE_EXPRESSION) && (element = (referenceElement = (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(methodRef.getFirstChildNode())).resolve()) instanceof PsiClass) {
            targetContext = element.getFirstChild();
        }
        return targetContext;
    }

    @Override
    public boolean isValidInContext(PsiElement element) {
        if (this.myInline && this.myName.equals("linkplain") && element != null) {
            return PsiUtil.getLanguageLevel(element).compareTo(LanguageLevel.JDK_1_4) >= 0;
        }
        return true;
    }

    @Override
    public PsiReference getReference(PsiDocTagValue value) {
        return null;
    }

    @Override
    public boolean isInline() {
        return this.myInline;
    }
}

