/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiInstanceOfExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public class PsiInstanceOfExpressionImpl
extends ExpressionPsiElement
implements PsiInstanceOfExpression,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiInstanceOfExpressionImpl");

    public PsiInstanceOfExpressionImpl() {
        super(INSTANCE_OF_EXPRESSION);
    }

    @Override
    @NotNull
    public PsiExpression getOperand() {
        PsiExpression psiExpression = (PsiExpression)this.findChildByRoleAsPsiElement(67);
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiInstanceOfExpressionImpl", "getOperand"));
        }
        return psiExpression;
    }

    @Override
    public PsiTypeElement getCheckType() {
        return (PsiTypeElement)this.findChildByRoleAsPsiElement(10);
    }

    @Override
    public PsiType getType() {
        return PsiType.BOOLEAN;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 67: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 68: {
                return this.findChildByType(INSTANCEOF_KEYWORD);
            }
            case 10: 
        }
        return this.findChildByType(TYPE);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == TYPE) {
            return 10;
        }
        if (i == INSTANCEOF_KEYWORD) {
            return 68;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 67;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiInstanceOfExpressionImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitInstanceOfExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiInstanceofExpression:" + this.getText();
    }
}

