/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.io.AbstractStringEnumerator;
import org.jetbrains.kotlin.com.intellij.util.io.DataInputOutputUtil;
import org.jetbrains.kotlin.com.intellij.util.io.IOUtil;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;

public class StubInputStream
extends DataInputStream {
    private final AbstractStringEnumerator myNameStorage;
    private final byte[] myStringIOBuffer;

    public StubInputStream(@NotNull InputStream in, @NotNull AbstractStringEnumerator nameStorage) {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubInputStream", "<init>"));
        }
        if (nameStorage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameStorage", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubInputStream", "<init>"));
        }
        super(in);
        this.myStringIOBuffer = IOUtil.allocReadWriteUTFBuffer();
        this.myNameStorage = nameStorage;
    }

    @NotNull
    public String readUTFFast() throws IOException {
        String string = IOUtil.readUTFFast(this.myStringIOBuffer, this);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/stubs/StubInputStream", "readUTFFast"));
        }
        return string;
    }

    @Nullable
    public StringRef readName() throws IOException {
        return DataInputOutputUtil.readNAME(this, this.myNameStorage);
    }

    public int readVarInt() throws IOException {
        return DataInputOutputUtil.readINT(this);
    }

    public String stringFromId(int id) throws IOException {
        return (String)this.myNameStorage.valueOf(id);
    }
}

