/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.ProjectRootModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullComputable;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayAccessExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpressionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaClassSupers;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.psi.util.TypesDistinctProver;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.gnu.trove.THashMap;
import org.jetbrains.kotlin.gnu.trove.THashSet;
import org.jetbrains.kotlin.gnu.trove.TObjectIntHashMap;

public class TypeConversionUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.TypeConversionUtil");
    private static final boolean[][] IS_ASSIGNABLE_BIT_SET = new boolean[][]{{true, true, false, true, true, true, true}, {false, true, false, true, true, true, true}, {false, false, true, true, true, true, true}, {false, false, false, true, true, true, true}, {false, false, false, false, true, true, true}, {false, false, false, false, false, true, true}, {false, false, false, false, false, false, true}};
    private static final TObjectIntHashMap<PsiType> TYPE_TO_RANK_MAP = new TObjectIntHashMap();
    public static final int BYTE_RANK = 1;
    public static final int SHORT_RANK = 2;
    public static final int CHAR_RANK = 3;
    public static final int INT_RANK = 4;
    public static final int LONG_RANK = 5;
    public static final PsiType NULL_TYPE = new PsiEllipsisType(PsiType.NULL){

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        @NotNull
        @NonNls
        public String getPresentableText() {
            if ("FAKE TYPE" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$1", "getPresentableText"));
            }
            return "FAKE TYPE";
        }
    };
    private static final Key<PsiElement> ORIGINAL_CONTEXT = Key.create("ORIGINAL_CONTEXT");
    private static final Key<CachedValue<Set<String>>> POSSIBLE_BOXED_HOLDER_TYPES;
    private static final RecursionGuard ourGuard;
    private static final Set<String> ourReportedSuperClassSubstitutorExceptions;
    private static final Set<String> INTEGER_NUMBER_TYPES;
    private static final Set<String> PRIMITIVE_TYPES;
    private static final Set<String> PRIMITIVE_WRAPPER_TYPES;
    private static final Caster[][] caster;
    private static final Map<Class, PsiType> WRAPPER_TO_PRIMITIVE;

    private TypeConversionUtil() {
    }

    public static boolean areTypesConvertible(@NotNull PsiType fromType, @NotNull PsiType toType) {
        if (fromType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromType", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "areTypesConvertible"));
        }
        if (toType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "areTypesConvertible"));
        }
        return TypeConversionUtil.areTypesConvertible(fromType, toType, null);
    }

    public static boolean areTypesConvertible(@NotNull PsiType fromType, @NotNull PsiType toType, @Nullable LanguageLevel languageLevel) {
        if (fromType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromType", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "areTypesConvertible"));
        }
        if (toType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "areTypesConvertible"));
        }
        if (fromType == toType) {
            return true;
        }
        boolean fromIsPrimitive = TypeConversionUtil.isPrimitiveAndNotNull(fromType);
        boolean toIsPrimitive = TypeConversionUtil.isPrimitiveAndNotNull(toType);
        if (fromIsPrimitive || toIsPrimitive) {
            if (TypeConversionUtil.isVoidType(fromType) || TypeConversionUtil.isVoidType(toType)) {
                return false;
            }
            int fromTypeRank = TypeConversionUtil.getTypeRank(fromType);
            int toTypeRank = TypeConversionUtil.getTypeRank(toType);
            if (!toIsPrimitive) {
                if (fromTypeRank == toTypeRank) {
                    return true;
                }
                if (toType instanceof PsiIntersectionType) {
                    for (PsiType type2 : ((PsiIntersectionType)toType).getConjuncts()) {
                        if (TypeConversionUtil.areTypesConvertible(fromType, type2)) continue;
                        return false;
                    }
                    return true;
                }
                if (!(toType instanceof PsiClassType)) {
                    return false;
                }
                PsiClass toClass = ((PsiClassType)toType).resolve();
                if (toClass == null || toClass instanceof PsiTypeParameter) {
                    return false;
                }
                PsiClassType boxedType = ((PsiPrimitiveType)fromType).getBoxedType(toClass.getManager(), toType.getResolveScope());
                return boxedType != null && TypeConversionUtil.areTypesConvertible(boxedType, toType);
            }
            if (!fromIsPrimitive) {
                if ((fromTypeRank == 2 || fromTypeRank == 1) && toTypeRank == 3) {
                    return false;
                }
                if (fromType instanceof PsiClassType) {
                    if (languageLevel == null) {
                        languageLevel = ((PsiClassType)fromType).getLanguageLevel();
                    }
                    if (languageLevel.isAtLeast(LanguageLevel.JDK_1_7)) {
                        PsiClassType classType = (PsiClassType)fromType;
                        PsiClass psiClass = classType.resolve();
                        if (psiClass == null) {
                            return false;
                        }
                        PsiClassType boxedType = ((PsiPrimitiveType)toType).getBoxedType(psiClass.getManager(), psiClass.getResolveScope());
                        if (boxedType != null && TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, boxedType)) {
                            return true;
                        }
                    }
                }
                return fromTypeRank == toTypeRank || fromTypeRank <= 7 && toTypeRank <= 7 && fromTypeRank < toTypeRank;
            }
            return fromTypeRank == toTypeRank || fromTypeRank <= 7 && toTypeRank <= 7;
        }
        if (TypeConversionUtil.isAssignable(toType, fromType)) {
            return true;
        }
        if (TypeConversionUtil.isNullType(fromType) || TypeConversionUtil.isNullType(toType)) {
            return true;
        }
        return TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, toType);
    }

    private static boolean isNarrowingReferenceConversionAllowed(@NotNull PsiType fromType, @NotNull PsiType toType) {
        PsiSubstitutor derivedSubstitutor;
        PsiClass derived;
        PsiClassType.ClassResolveResult baseResult;
        if (fromType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromType", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isNarrowingReferenceConversionAllowed"));
        }
        if (toType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isNarrowingReferenceConversionAllowed"));
        }
        if (toType instanceof PsiPrimitiveType || fromType instanceof PsiPrimitiveType) {
            return fromType.equals(toType);
        }
        if (toType instanceof PsiDiamondType || fromType instanceof PsiDiamondType) {
            return false;
        }
        if (toType instanceof PsiArrayType && !(fromType instanceof PsiArrayType)) {
            PsiClass resolved;
            if (fromType instanceof PsiClassType && (resolved = ((PsiClassType)fromType).resolve()) instanceof PsiTypeParameter) {
                for (PsiClassType boundType : resolved.getExtendsListTypes()) {
                    if (TypeConversionUtil.isNarrowingReferenceConversionAllowed(boundType, toType)) continue;
                    return false;
                }
                return true;
            }
            if (fromType instanceof PsiCapturedWildcardType) {
                return TypeConversionUtil.isNarrowingReferenceConversionAllowed(((PsiCapturedWildcardType)fromType).getUpperBound(), toType);
            }
            return TypeConversionUtil.isAssignable(fromType, toType);
        }
        if (fromType instanceof PsiArrayType) {
            PsiClass resolved;
            if (toType instanceof PsiClassType && (resolved = ((PsiClassType)toType).resolve()) instanceof PsiTypeParameter) {
                for (PsiClassType boundType : resolved.getExtendsListTypes()) {
                    if (TypeConversionUtil.areTypesConvertible(fromType, boundType)) continue;
                    return false;
                }
                return true;
            }
            return toType instanceof PsiArrayType && TypeConversionUtil.isNarrowingReferenceConversionAllowed(((PsiArrayType)fromType).getComponentType(), ((PsiArrayType)toType).getComponentType());
        }
        if (fromType instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)fromType).getConjuncts()) {
                if (!TypeConversionUtil.isNarrowingReferenceConversionAllowed(conjunct, toType)) continue;
                return true;
            }
            return false;
        }
        if (toType instanceof PsiIntersectionType) {
            if (fromType instanceof PsiClassType && ((PsiClassType)fromType).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_8)) {
                for (PsiType conjunct : ((PsiIntersectionType)toType).getConjuncts()) {
                    if (TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, conjunct)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (fromType instanceof PsiDisjunctionType) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(((PsiDisjunctionType)fromType).getLeastUpperBound(), toType);
        }
        if (toType instanceof PsiDisjunctionType) {
            return false;
        }
        if (fromType instanceof PsiWildcardType) {
            PsiWildcardType fromWildcard = (PsiWildcardType)fromType;
            PsiType bound = fromWildcard.getBound();
            if (bound == null) {
                return true;
            }
            if (fromWildcard.isSuper()) {
                return TypeConversionUtil.isAssignable(toType, bound);
            }
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(bound, toType);
        }
        if (toType instanceof PsiWildcardType) {
            PsiWildcardType toWildcard = (PsiWildcardType)toType;
            if (toWildcard.isSuper()) {
                return false;
            }
            PsiType bound = toWildcard.getBound();
            return bound == null || TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, bound);
        }
        if (toType instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, ((PsiCapturedWildcardType)toType).getUpperBound());
        }
        if (fromType instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(((PsiCapturedWildcardType)fromType).getUpperBound(), toType);
        }
        if (TypeConversionUtil.isAssignable(fromType, toType)) {
            return true;
        }
        if (!(fromType instanceof PsiClassType) || !(toType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType fromClassType = (PsiClassType)fromType;
        PsiClassType toClassType = (PsiClassType)toType;
        PsiClassType.ClassResolveResult fromResult = fromClassType.resolveGenerics();
        PsiClass fromClass = fromResult.getElement();
        if (fromClass == null) {
            return false;
        }
        if (fromClass instanceof PsiTypeParameter) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(TypeConversionUtil.obtainSafeSuperType((PsiTypeParameter)fromClass), toType);
        }
        PsiClassType.ClassResolveResult toResult = toClassType.resolveGenerics();
        PsiClass toClass = toResult.getElement();
        if (toClass == null) {
            return false;
        }
        if (toClass instanceof PsiTypeParameter) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, TypeConversionUtil.obtainSafeSuperType((PsiTypeParameter)toClass));
        }
        PsiManager manager = fromClass.getManager();
        LanguageLevel languageLevel = toClassType.getLanguageLevel();
        if (!fromClass.isInterface()) {
            if (toClass.isInterface()) {
                return (!fromClass.hasModifierProperty("final") || fromClass.isInheritor(toClass, true)) && TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(toResult, fromClass, manager, fromResult.getSubstitutor(), null, languageLevel);
            }
            if (manager.areElementsEquivalent(fromClass, toClass)) {
                return TypeConversionUtil.areSameParameterTypes(fromClassType, toClassType);
            }
            if (toClass.isInheritor(fromClass, true)) {
                return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(fromResult, toClass, manager, toResult.getSubstitutor(), null, languageLevel);
            }
            if (fromClass.isInheritor(toClass, true)) {
                return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(toResult, fromClass, manager, fromResult.getSubstitutor(), null, languageLevel);
            }
            return false;
        }
        if (!toClass.isInterface()) {
            if (!toClass.hasModifierProperty("final")) {
                return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(fromResult, toClass, manager, toResult.getSubstitutor(), null, languageLevel);
            }
            PsiSubstitutor toSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(fromClass, toClass, toResult.getSubstitutor(), null);
            return toSubstitutor != null && TypeConversionUtil.areSameArgumentTypes(fromClass, fromResult.getSubstitutor(), toSubstitutor);
        }
        if (languageLevel.compareTo(LanguageLevel.JDK_1_5) < 0) {
            Collection<HierarchicalMethodSignature> fromClassMethodSignatures = fromClass.getVisibleSignatures();
            Collection<HierarchicalMethodSignature> toClassMethodSignatures = toClass.getVisibleSignatures();
            for (HierarchicalMethodSignature fromMethodSignature : fromClassMethodSignatures) {
                for (HierarchicalMethodSignature toMethodSignature : toClassMethodSignatures) {
                    if (!fromMethodSignature.equals(toMethodSignature)) continue;
                    PsiType fromClassReturnType = fromMethodSignature.getMethod().getReturnType();
                    PsiType toClassReturnType = toMethodSignature.getMethod().getReturnType();
                    if (fromClassReturnType == null || toClassReturnType == null || fromClassReturnType.equals(toClassReturnType)) continue;
                    return false;
                }
            }
            return true;
        }
        if (toClass.isInheritor(fromClass, true)) {
            baseResult = fromResult;
            derived = toClass;
            derivedSubstitutor = toResult.getSubstitutor();
        } else {
            baseResult = toResult;
            derived = fromClass;
            derivedSubstitutor = fromResult.getSubstitutor();
        }
        return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(baseResult, derived, manager, derivedSubstitutor, null, languageLevel);
    }

    @NotNull
    private static PsiClassType obtainSafeSuperType(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "obtainSafeSuperType"));
        }
        PsiClassType superType = typeParameter.getSuperTypes()[0];
        PsiClassType.ClassResolveResult result2 = superType.resolveGenerics();
        PsiClass superClass = result2.getElement();
        if (superClass != null) {
            PsiSubstitutor substitutor2 = result2.getSubstitutor().put(typeParameter, null);
            PsiClassType psiClassType = JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(superClass, substitutor2);
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "obtainSafeSuperType"));
            }
            return psiClassType;
        }
        PsiClassType psiClassType = superType;
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "obtainSafeSuperType"));
        }
        return psiClassType;
    }

    private static boolean checkSuperTypesWithDifferentTypeArguments(@NotNull PsiClassType.ClassResolveResult baseResult, @NotNull PsiClass derived, @NotNull PsiManager manager, @NotNull PsiSubstitutor derivedSubstitutor, Set<PsiClass> visited2, @NotNull LanguageLevel languageLevel) {
        if (baseResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseResult", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "checkSuperTypesWithDifferentTypeArguments"));
        }
        if (derived == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derived", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "checkSuperTypesWithDifferentTypeArguments"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "checkSuperTypesWithDifferentTypeArguments"));
        }
        if (derivedSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "checkSuperTypesWithDifferentTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "checkSuperTypesWithDifferentTypeArguments"));
        }
        if (visited2 != null && visited2.contains(derived)) {
            return true;
        }
        if (languageLevel.compareTo(LanguageLevel.JDK_1_5) < 0) {
            return true;
        }
        PsiClass base = baseResult.getElement();
        PsiClass[] supers = derived.getSupers();
        if (manager.areElementsEquivalent(base, derived)) {
            derivedSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(derived, derived, derivedSubstitutor);
            return TypeConversionUtil.areSameArgumentTypes(derived, baseResult.getSubstitutor(), derivedSubstitutor, 1);
        }
        PsiSubstitutor baseSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(derived, base, baseResult.getSubstitutor(), null);
        if (baseSubstitutor != null && !TypeConversionUtil.areSameArgumentTypes(derived, baseSubstitutor, derivedSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(derived, derived, derivedSubstitutor))) {
            return false;
        }
        if (visited2 == null) {
            visited2 = new THashSet<PsiClass>();
        }
        visited2.add(derived);
        for (PsiClass aSuper : supers) {
            PsiSubstitutor s = TypeConversionUtil.getSuperClassSubstitutor(aSuper, derived, derivedSubstitutor);
            if (TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(baseResult, aSuper, manager, s, visited2, languageLevel)) continue;
            return false;
        }
        return true;
    }

    private static boolean areSameParameterTypes(@NotNull PsiClassType type1, @NotNull PsiClassType type2) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "areSameParameterTypes"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "areSameParameterTypes"));
        }
        PsiClassType.ClassResolveResult resolveResult1 = type1.resolveGenerics();
        PsiClassType.ClassResolveResult resolveResult2 = type2.resolveGenerics();
        PsiClass aClass2 = resolveResult1.getElement();
        PsiClass bClass = resolveResult2.getElement();
        return aClass2 != null && bClass != null && aClass2.getManager().areElementsEquivalent(aClass2, bClass) && TypeConversionUtil.areSameArgumentTypes(aClass2, resolveResult1.getSubstitutor(), resolveResult2.getSubstitutor(), 1);
    }

    private static boolean areSameArgumentTypes(@NotNull PsiClass aClass2, @NotNull PsiSubstitutor substitutor1, @NotNull PsiSubstitutor substitutor2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "areSameArgumentTypes"));
        }
        if (substitutor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor1", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "areSameArgumentTypes"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor2", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "areSameArgumentTypes"));
        }
        return TypeConversionUtil.areSameArgumentTypes(aClass2, substitutor1, substitutor2, 0);
    }

    private static boolean areSameArgumentTypes(@NotNull PsiClass aClass2, @NotNull PsiSubstitutor substitutor1, @NotNull PsiSubstitutor substitutor2, int level) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "areSameArgumentTypes"));
        }
        if (substitutor1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor1", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "areSameArgumentTypes"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor2", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "areSameArgumentTypes"));
        }
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass2)) {
            PsiType typeArg1 = substitutor1.substitute(typeParameter);
            PsiType typeArg2 = substitutor2.substitute(typeParameter);
            if (typeArg1 == null || typeArg2 == null) {
                return true;
            }
            if (!TypesDistinctProver.provablyDistinct(typeArg1, typeArg2, level)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrimitiveAndNotNull(PsiType type2) {
        if (type2 instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isPrimitiveAndNotNull(((PsiCapturedWildcardType)type2).getUpperBound());
        }
        return type2 instanceof PsiPrimitiveType && !TypeConversionUtil.isNullType(type2);
    }

    public static boolean isEnumType(PsiType type2) {
        if (type2 instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isEnumType(((PsiCapturedWildcardType)type2).getUpperBound());
        }
        if (type2 instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type2).resolve();
            return psiClass != null && psiClass.isEnum();
        }
        return false;
    }

    public static boolean isNullType(PsiType type2) {
        return PsiType.NULL.equals(type2);
    }

    public static boolean isFloatOrDoubleType(PsiType type2) {
        return TypeConversionUtil.isFloatType(type2) || TypeConversionUtil.isDoubleType(type2);
    }

    public static boolean isDoubleType(PsiType type2) {
        if (type2 instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isDoubleType(((PsiCapturedWildcardType)type2).getUpperBound());
        }
        return PsiType.DOUBLE.equals(type2) || PsiType.DOUBLE.equals(PsiPrimitiveType.getUnboxedType(type2));
    }

    public static boolean isFloatType(PsiType type2) {
        if (type2 instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isFloatType(((PsiCapturedWildcardType)type2).getUpperBound());
        }
        return PsiType.FLOAT.equals(type2) || PsiType.FLOAT.equals(PsiPrimitiveType.getUnboxedType(type2));
    }

    public static boolean isLongType(PsiType type2) {
        if (type2 instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isLongType(((PsiCapturedWildcardType)type2).getUpperBound());
        }
        return PsiType.LONG.equals(type2) || PsiType.LONG.equals(PsiPrimitiveType.getUnboxedType(type2));
    }

    public static boolean isVoidType(PsiType type2) {
        return PsiType.VOID.equals(type2);
    }

    public static boolean isBooleanType(@Nullable PsiType type2) {
        if (type2 instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isBooleanType(((PsiCapturedWildcardType)type2).getUpperBound());
        }
        return PsiType.BOOLEAN.equals(type2) || PsiType.BOOLEAN.equals(PsiPrimitiveType.getUnboxedType(type2));
    }

    public static boolean isNumericType(int typeRank) {
        return typeRank <= 7;
    }

    public static boolean isNumericType(PsiType type2) {
        return type2 != null && TypeConversionUtil.isNumericType(TypeConversionUtil.getTypeRank(type2));
    }

    public static int getTypeRank(@NotNull PsiType type2) {
        int rank;
        PsiPrimitiveType unboxedType;
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getTypeRank"));
        }
        if (type2 instanceof PsiCapturedWildcardType) {
            type2 = ((PsiCapturedWildcardType)type2).getUpperBound();
        }
        if ((unboxedType = PsiPrimitiveType.getUnboxedType(type2)) != null) {
            type2 = unboxedType;
        }
        if ((rank = TYPE_TO_RANK_MAP.get(type2)) != 0) {
            return rank;
        }
        if (type2.equalsToText("java.lang.String")) {
            return 100;
        }
        return Integer.MAX_VALUE;
    }

    public static boolean isBinaryOperatorApplicable(IElementType tokenType, PsiExpression lOperand, PsiExpression rOperand, boolean strict) {
        if (lOperand == null || rOperand == null) {
            return true;
        }
        PsiType ltype = lOperand.getType();
        PsiType rtype = rOperand.getType();
        return TypeConversionUtil.isBinaryOperatorApplicable(tokenType, ltype, rtype, strict);
    }

    public static boolean isBinaryOperatorApplicable(IElementType tokenType, PsiType ltype, PsiType rtype, boolean strict) {
        if (ltype == null || rtype == null) {
            return true;
        }
        int resultTypeRank = 10;
        boolean isApplicable = false;
        int ltypeRank = TypeConversionUtil.getTypeRank(ltype);
        int rtypeRank = TypeConversionUtil.getTypeRank(rtype);
        if (tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE || tokenType == JavaTokenType.GT || tokenType == JavaTokenType.GE) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7;
            }
        } else if (tokenType == JavaTokenType.EQEQ || tokenType == JavaTokenType.NE) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype) && (TypeConversionUtil.isPrimitiveAndNotNull(ltype) || TypeConversionUtil.isPrimitiveAndNotNull(rtype))) {
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7 || ltypeRank == 10 && rtypeRank == 10;
            } else {
                if (TypeConversionUtil.isPrimitiveAndNotNull(ltype)) {
                    LanguageLevel languageLevel;
                    return rtype instanceof PsiClassType && (languageLevel = ((PsiClassType)rtype).getLanguageLevel()).isAtLeast(LanguageLevel.JDK_1_5) && !languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && TypeConversionUtil.areTypesConvertible(ltype, rtype);
                }
                if (TypeConversionUtil.isPrimitiveAndNotNull(rtype)) {
                    LanguageLevel level;
                    return ltype instanceof PsiClassType && (level = ((PsiClassType)ltype).getLanguageLevel()).isAtLeast(LanguageLevel.JDK_1_7) && !level.isAtLeast(LanguageLevel.JDK_1_8) && TypeConversionUtil.areTypesConvertible(rtype, ltype);
                }
                isApplicable = TypeConversionUtil.areTypesConvertible(ltype, rtype) || TypeConversionUtil.areTypesConvertible(rtype, ltype);
            }
        } else if (tokenType == JavaTokenType.PLUS) {
            if (ltype.equalsToText("java.lang.String")) {
                isApplicable = !TypeConversionUtil.isVoidType(rtype);
                resultTypeRank = 100;
            } else if (rtype.equalsToText("java.lang.String")) {
                isApplicable = !TypeConversionUtil.isVoidType(ltype);
                resultTypeRank = 100;
            } else if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                resultTypeRank = Math.max(ltypeRank, rtypeRank);
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7;
            }
        } else if (tokenType == JavaTokenType.ASTERISK || tokenType == JavaTokenType.DIV || tokenType == JavaTokenType.PERC || tokenType == JavaTokenType.MINUS) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                resultTypeRank = Math.max(ltypeRank, rtypeRank);
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7;
            }
        } else if (tokenType == JavaTokenType.LTLT || tokenType == JavaTokenType.GTGT || tokenType == JavaTokenType.GTGTGT) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                isApplicable = ltypeRank <= 5 && rtypeRank <= 5;
                resultTypeRank = 4;
            }
        } else if (tokenType == JavaTokenType.AND || tokenType == JavaTokenType.OR || tokenType == JavaTokenType.XOR) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                isApplicable = ltypeRank <= 5 && rtypeRank <= 5 || TypeConversionUtil.isBooleanType(ltype) && TypeConversionUtil.isBooleanType(rtype);
                resultTypeRank = ltypeRank <= 5 ? 4 : 10;
            }
        } else if ((tokenType == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
            boolean bl = isApplicable = TypeConversionUtil.isBooleanType(ltype) && TypeConversionUtil.isBooleanType(rtype);
        }
        if (isApplicable && strict) {
            isApplicable = resultTypeRank > 7 ? ltypeRank == resultTypeRank || ltype.equalsToText("java.lang.Object") : ltypeRank <= 7;
        }
        return isApplicable;
    }

    public static boolean isPrimitiveAndNotNullOrWrapper(PsiType type2) {
        if (type2 instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(((PsiCapturedWildcardType)type2).getUpperBound());
        }
        if (type2 instanceof PsiClassType) {
            return PsiPrimitiveType.getUnboxedType(type2) != null;
        }
        return TypeConversionUtil.isPrimitiveAndNotNull(type2);
    }

    public static boolean isUnaryOperatorApplicable(@NotNull PsiJavaToken token, PsiExpression operand) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isUnaryOperatorApplicable"));
        }
        if (operand == null) {
            return false;
        }
        PsiType type2 = operand.getType();
        return type2 != null && TypeConversionUtil.isUnaryOperatorApplicable(token, type2);
    }

    public static boolean isUnaryOperatorApplicable(@NotNull PsiJavaToken token, @NotNull PsiType type2) {
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isUnaryOperatorApplicable"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isUnaryOperatorApplicable"));
        }
        IElementType i = token.getTokenType();
        int typeRank = TypeConversionUtil.getTypeRank(type2);
        if (i == JavaTokenType.MINUSMINUS || i == JavaTokenType.PLUSPLUS) {
            return typeRank <= 7;
        }
        if (i == JavaTokenType.MINUS || i == JavaTokenType.PLUS) {
            return typeRank <= 7;
        }
        if (i == JavaTokenType.TILDE) {
            return typeRank <= 5;
        }
        if (i == JavaTokenType.EXCL) {
            return typeRank == 10;
        }
        LOG.error("unknown token: " + token);
        return true;
    }

    public static boolean isLValue(PsiExpression element) {
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression expression = (PsiReferenceExpression)element;
            PsiElement resolved = expression.resolve();
            return resolved instanceof PsiVariable;
        }
        if (element instanceof PsiParenthesizedExpression) {
            return TypeConversionUtil.isLValue(((PsiParenthesizedExpression)element).getExpression());
        }
        if (element instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)element;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            PsiType type2 = arrayExpression.getType();
            if (type2 == null || !(type2 instanceof PsiArrayType)) {
                return false;
            }
            PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
            if (indexExpression == null) {
                return false;
            }
            PsiType indexType = indexExpression.getType();
            if (indexType == null) {
                return false;
            }
            if (TypeConversionUtil.getTypeRank(indexType) <= 4) {
                return true;
            }
        }
        return false;
    }

    public static boolean areTypesAssignmentCompatible(PsiType lType, PsiExpression rExpr) {
        if (lType == null || rExpr == null) {
            return true;
        }
        PsiType rType = rExpr.getType();
        if (rType == null) {
            return false;
        }
        if (TypeConversionUtil.isAssignable(lType, rType)) {
            return true;
        }
        if (lType instanceof PsiClassType && (lType = PsiPrimitiveType.getUnboxedType(lType)) == null) {
            return false;
        }
        int rTypeRank = TypeConversionUtil.getTypeRank(rType);
        if (lType instanceof PsiPrimitiveType && rType instanceof PsiPrimitiveType && rTypeRank >= 1 && rTypeRank <= 4) {
            long value;
            Object rValue = JavaPsiFacade.getInstance(rExpr.getProject()).getConstantEvaluationHelper().computeConstantExpression(rExpr);
            if (rValue instanceof Number) {
                value = ((Number)rValue).longValue();
            } else if (rValue instanceof Character) {
                value = ((Character)rValue).charValue();
            } else {
                return false;
            }
            if (PsiType.BYTE.equals(lType)) {
                return -128L <= value && value <= 127L;
            }
            if (PsiType.SHORT.equals(lType)) {
                return -32768L <= value && value <= 32767L;
            }
            if (PsiType.CHAR.equals(lType)) {
                return 0L <= value && value <= 65535L;
            }
        }
        return false;
    }

    public static boolean isAssignable(@NotNull PsiType left, @NotNull PsiType right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isAssignable"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isAssignable"));
        }
        return TypeConversionUtil.isAssignable(left, right, true);
    }

    public static boolean isAssignable(@NotNull PsiType left, @NotNull PsiType right, boolean allowUncheckedConversion) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isAssignable"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isAssignable"));
        }
        return TypeConversionUtil.isAssignable(left, right, allowUncheckedConversion, true);
    }

    private static boolean isAssignable(@NotNull PsiType left, @NotNull PsiType right, boolean allowUncheckedConversion, boolean capture) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isAssignable"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isAssignable"));
        }
        if (left == right || left.equals(right)) {
            return true;
        }
        if (TypeConversionUtil.isNullType(right)) {
            return !(left instanceof PsiPrimitiveType) || TypeConversionUtil.isNullType(left);
        }
        if (right instanceof PsiMethodReferenceType) {
            PsiMethodReferenceExpression methodReferenceExpression = ((PsiMethodReferenceType)right).getExpression();
            if (left instanceof PsiLambdaExpressionType) {
                PsiType rType = methodReferenceExpression.getFunctionalInterfaceType();
                PsiType lType = ((PsiLambdaExpressionType)left).getExpression().getFunctionalInterfaceType();
                return Comparing.equal(rType, lType);
            }
            if (left instanceof PsiMethodReferenceType) {
                PsiType rType = methodReferenceExpression.getFunctionalInterfaceType();
                PsiType lType = ((PsiMethodReferenceType)left).getExpression().getFunctionalInterfaceType();
                return Comparing.equal(rType, lType);
            }
            return !(left instanceof PsiArrayType) && methodReferenceExpression.isAcceptable(left);
        }
        if (right instanceof PsiLambdaExpressionType) {
            PsiLambdaExpression rLambdaExpression = ((PsiLambdaExpressionType)right).getExpression();
            if (left instanceof PsiLambdaExpressionType) {
                PsiLambdaExpression lLambdaExpression = ((PsiLambdaExpressionType)left).getExpression();
                PsiType rType = rLambdaExpression.getFunctionalInterfaceType();
                PsiType lType = lLambdaExpression.getFunctionalInterfaceType();
                return Comparing.equal(rType, lType);
            }
            return !(left instanceof PsiArrayType) && rLambdaExpression.isAcceptable(left);
        }
        if (left instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)left).getConjuncts()) {
                if (TypeConversionUtil.isAssignable(conjunct, right, allowUncheckedConversion, capture)) continue;
                return false;
            }
            return true;
        }
        if (right instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)right).getConjuncts()) {
                if (!TypeConversionUtil.isAssignable(left, conjunct, allowUncheckedConversion, capture)) continue;
                return true;
            }
            return false;
        }
        if (right instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isAssignable(left, ((PsiCapturedWildcardType)right).getUpperBound(), allowUncheckedConversion, capture);
        }
        if (left instanceof PsiCapturedWildcardType) {
            return left.equals(right) || TypeConversionUtil.isAssignable(((PsiCapturedWildcardType)left).getLowerBound(), right, allowUncheckedConversion, capture);
        }
        if (left instanceof PsiWildcardType) {
            return TypeConversionUtil.isAssignableToWildcard((PsiWildcardType)left, right);
        }
        if (right instanceof PsiWildcardType) {
            return TypeConversionUtil.isAssignableFromWildcard(left, (PsiWildcardType)right);
        }
        if (right instanceof PsiArrayType) {
            if (!(left instanceof PsiArrayType)) {
                if (left instanceof PsiPrimitiveType || PsiUtil.resolveClassInType(left) == null) {
                    return false;
                }
                PsiClass lClass = PsiUtil.resolveClassInType(left);
                if (lClass == null) {
                    return false;
                }
                if (lClass.isInterface()) {
                    String qualifiedName = lClass.getQualifiedName();
                    return "java.io.Serializable".equals(qualifiedName) || "java.lang.Cloneable".equals(qualifiedName);
                }
                return left.equalsToText("java.lang.Object");
            }
            PsiType lCompType = ((PsiArrayType)left).getComponentType();
            PsiType rCompType = ((PsiArrayType)right).getComponentType();
            if (lCompType instanceof PsiPrimitiveType) {
                return lCompType.equals(rCompType);
            }
            return !(rCompType instanceof PsiPrimitiveType) && TypeConversionUtil.isAssignable(lCompType, rCompType, allowUncheckedConversion, capture);
        }
        if (left instanceof PsiDisjunctionType) {
            for (PsiType type2 : ((PsiDisjunctionType)left).getDisjunctions()) {
                if (!TypeConversionUtil.isAssignable(type2, right, allowUncheckedConversion, capture)) continue;
                return true;
            }
            return false;
        }
        if (right instanceof PsiDisjunctionType) {
            return TypeConversionUtil.isAssignable(left, ((PsiDisjunctionType)right).getLeastUpperBound(), allowUncheckedConversion, capture);
        }
        if (left instanceof PsiArrayType) {
            return false;
        }
        if (right instanceof PsiPrimitiveType) {
            if (TypeConversionUtil.isVoidType(right)) {
                return false;
            }
            if (!(left instanceof PsiPrimitiveType)) {
                return left instanceof PsiClassType && TypeConversionUtil.isBoxable((PsiClassType)left, (PsiPrimitiveType)right);
            }
            int leftTypeIndex = TYPE_TO_RANK_MAP.get(left) - 1;
            int rightTypeIndex = TYPE_TO_RANK_MAP.get(right) - 1;
            return leftTypeIndex >= 0 && rightTypeIndex >= 0 && rightTypeIndex < IS_ASSIGNABLE_BIT_SET.length && leftTypeIndex < IS_ASSIGNABLE_BIT_SET.length && IS_ASSIGNABLE_BIT_SET[rightTypeIndex][leftTypeIndex];
        }
        if (!(right instanceof PsiClassType)) {
            return false;
        }
        if (left instanceof PsiPrimitiveType) {
            return TypeConversionUtil.isUnboxable((PsiPrimitiveType)left, (PsiClassType)right);
        }
        PsiClassType.ClassResolveResult leftResult = PsiUtil.resolveGenericsClassInType(left);
        PsiClassType.ClassResolveResult rightResult = PsiUtil.resolveGenericsClassInType(right);
        if (leftResult.getElement() == null || rightResult.getElement() == null) {
            String rText;
            if (leftResult.getElement() != rightResult.getElement()) {
                return false;
            }
            String lText = left.getPresentableText();
            if (lText.equals(rText = right.getPresentableText())) {
                return true;
            }
            if (lText.length() > rText.length() && lText.endsWith(rText) && lText.charAt(lText.length() - rText.length() - 1) == '.') {
                return true;
            }
            return rText.length() > lText.length() && rText.endsWith(lText) && rText.charAt(rText.length() - lText.length() - 1) == '.';
        }
        return TypeConversionUtil.isClassAssignable(leftResult, rightResult, allowUncheckedConversion, left.getResolveScope(), capture);
    }

    private static boolean isAssignableFromWildcard(@NotNull PsiType left, @NotNull PsiWildcardType rightWildcardType) {
        PsiClass aClass2;
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isAssignableFromWildcard"));
        }
        if (rightWildcardType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightWildcardType", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isAssignableFromWildcard"));
        }
        if (rightWildcardType.isSuper() && (aClass2 = PsiUtil.resolveClassInType(rightWildcardType.getSuperBound())) instanceof PsiTypeParameter) {
            PsiClassType[] types;
            for (PsiClassType type2 : types = aClass2.getExtendsListTypes()) {
                if (!TypeConversionUtil.isAssignable(left, type2)) continue;
                return true;
            }
        }
        return TypeConversionUtil.isAssignable(left, rightWildcardType.getExtendsBound());
    }

    private static boolean isAssignableToWildcard(@NotNull PsiWildcardType wildcardType, @NotNull PsiType right) {
        if (wildcardType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wildcardType", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isAssignableToWildcard"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isAssignableToWildcard"));
        }
        if (wildcardType.isSuper()) {
            return TypeConversionUtil.isAssignable(wildcardType.getSuperBound(), right);
        }
        return TypeConversionUtil.isAssignable(wildcardType.getExtendsBound(), right);
    }

    private static boolean isUnboxable(@NotNull PsiPrimitiveType left, @NotNull PsiClassType right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isUnboxable"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isUnboxable"));
        }
        PsiPrimitiveType rightUnboxedType = PsiPrimitiveType.getUnboxedType(right);
        return rightUnboxedType != null && TypeConversionUtil.isAssignable(left, rightUnboxedType);
    }

    public static boolean boxingConversionApplicable(PsiType left, PsiType right) {
        if (left instanceof PsiPrimitiveType && !PsiType.NULL.equals(left)) {
            return right instanceof PsiClassType && TypeConversionUtil.isAssignable(left, right);
        }
        if (left instanceof PsiIntersectionType) {
            for (PsiType lConjunct : ((PsiIntersectionType)left).getConjuncts()) {
                if (TypeConversionUtil.boxingConversionApplicable(lConjunct, right)) continue;
                return false;
            }
            return true;
        }
        return left instanceof PsiClassType && right instanceof PsiPrimitiveType && !PsiType.NULL.equals(right) && TypeConversionUtil.isAssignable(left, right);
    }

    private static boolean isBoxable(@NotNull PsiClassType left, @NotNull PsiPrimitiveType right) {
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isBoxable"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isBoxable"));
        }
        if (!left.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_5)) {
            return false;
        }
        PsiClass psiClass = left.resolve();
        if (psiClass == null) {
            return false;
        }
        String qname = psiClass.getQualifiedName();
        if (qname == null || !(psiClass instanceof PsiTypeParameter) && !TypeConversionUtil.getAllBoxedTypeSupers(psiClass).contains(qname)) {
            return false;
        }
        PsiClassType rightBoxed = right.getBoxedType(psiClass.getManager(), left.getResolveScope());
        return rightBoxed != null && TypeConversionUtil.isAssignable(left, rightBoxed);
    }

    @NotNull
    private static Set<String> getAllBoxedTypeSupers(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getAllBoxedTypeSupers"));
        }
        PsiManager manager = psiClass.getManager();
        final Project project = psiClass.getProject();
        CachedValue<Set<String>> boxedHolderTypes = project.getUserData(POSSIBLE_BOXED_HOLDER_TYPES);
        if (boxedHolderTypes == null) {
            boxedHolderTypes = CachedValuesManager.getManager(manager.getProject()).createCachedValue(new CachedValueProvider<Set<String>>(){

                @Override
                public CachedValueProvider.Result<Set<String>> compute() {
                    JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
                    final THashSet set = new THashSet();
                    for (String qname : PsiPrimitiveType.getAllBoxedTypeNames()) {
                        PsiClass boxedClass = facade.findClass(qname, GlobalSearchScope.allScope(project));
                        InheritanceUtil.processSupers(boxedClass, true, new Processor<PsiClass>(){

                            @Override
                            public boolean process(PsiClass psiClass) {
                                ContainerUtil.addIfNotNull(psiClass.getQualifiedName(), set);
                                return true;
                            }
                        });
                    }
                    return CachedValueProvider.Result.create(set, ProjectRootModificationTracker.getInstance(project));
                }
            }, false);
            project.putUserData(POSSIBLE_BOXED_HOLDER_TYPES, boxedHolderTypes);
        }
        Set<String> set = boxedHolderTypes.getValue();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getAllBoxedTypeSupers"));
        }
        return set;
    }

    private static boolean isClassAssignable(@NotNull PsiClassType.ClassResolveResult leftResult, @NotNull PsiClassType.ClassResolveResult rightResult, boolean allowUncheckedConversion, GlobalSearchScope resolveScope, boolean capture) {
        if (leftResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftResult", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isClassAssignable"));
        }
        if (rightResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightResult", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isClassAssignable"));
        }
        PsiClass leftClass = leftResult.getElement();
        PsiClass rightClass = rightResult.getElement();
        if (leftClass == null || rightClass == null) {
            return false;
        }
        PsiSubstitutor superSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(leftClass, rightClass, resolveScope, rightResult.getSubstitutor());
        return superSubstitutor != null && TypeConversionUtil.typeParametersAgree(leftResult, rightResult, allowUncheckedConversion, superSubstitutor, capture);
    }

    private static boolean typeParametersAgree(@NotNull PsiClassType.ClassResolveResult leftResult, @NotNull PsiClassType.ClassResolveResult rightResult, boolean allowUncheckedConversion, PsiSubstitutor superSubstitutor, boolean capture) {
        if (leftResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftResult", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "typeParametersAgree"));
        }
        if (rightResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightResult", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "typeParametersAgree"));
        }
        PsiSubstitutor rightSubstitutor = rightResult.getSubstitutor();
        PsiClass leftClass = leftResult.getElement();
        PsiClass rightClass = rightResult.getElement();
        Iterator<PsiTypeParameter> li = PsiUtil.typeParametersIterator(leftClass);
        if (!li.hasNext()) {
            return true;
        }
        PsiSubstitutor leftSubstitutor = leftResult.getSubstitutor();
        if (!leftClass.getManager().areElementsEquivalent(leftClass, rightClass)) {
            rightSubstitutor = superSubstitutor;
            rightClass = leftClass;
        } else if (!PsiUtil.typeParametersIterator(rightClass).hasNext()) {
            return true;
        }
        Iterator<PsiTypeParameter> ri = PsiUtil.typeParametersIterator(rightClass);
        while (li.hasNext()) {
            PsiType typeRight;
            if (!ri.hasNext()) {
                return false;
            }
            PsiTypeParameter lp = li.next();
            PsiTypeParameter rp = ri.next();
            PsiType typeLeft = leftSubstitutor.substitute(lp);
            if (typeLeft == null) continue;
            PsiType psiType = typeRight = PsiCapturedWildcardType.isCapture() && capture ? rightSubstitutor.substituteWithBoundsPromotion(rp) : rightSubstitutor.substitute(rp);
            if (typeRight == null) {
                return allowUncheckedConversion;
            }
            if (TypeConversionUtil.typesAgree(typeLeft, typeRight, allowUncheckedConversion)) continue;
            return false;
        }
        return true;
    }

    public static boolean typesAgree(@NotNull PsiType typeLeft, final @NotNull PsiType typeRight, final boolean allowUncheckedConversion) {
        if (typeLeft == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeLeft", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "typesAgree"));
        }
        if (typeRight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeRight", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "typesAgree"));
        }
        if (typeLeft instanceof PsiWildcardType) {
            PsiWildcardType leftWildcard = (PsiWildcardType)typeLeft;
            final PsiType leftBound = leftWildcard.getBound();
            if (leftBound == null) {
                return true;
            }
            if (leftBound.equalsToText("java.lang.Object")) {
                if (!leftWildcard.isSuper()) {
                    return true;
                }
                if (typeRight.equalsToText("java.lang.Object")) {
                    return true;
                }
            }
            if (typeRight instanceof PsiWildcardType) {
                Boolean assignable;
                final PsiWildcardType rightWildcard = (PsiWildcardType)typeRight;
                if (leftWildcard.isExtends()) {
                    return rightWildcard.isExtends() && TypeConversionUtil.isAssignable(leftBound, rightWildcard.getBound(), allowUncheckedConversion, false);
                }
                return rightWildcard.isSuper() && (assignable = (Boolean)ourGuard.doPreventingRecursion(rightWildcard, true, new NotNullComputable<Boolean>(){

                    @NotNull
                    public Boolean compute() {
                        Boolean bl = TypeConversionUtil.isAssignable(rightWildcard.getBound(), leftBound, allowUncheckedConversion, false);
                        if (bl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$3", "compute"));
                        }
                        return bl;
                    }
                })) != null && assignable != false;
            }
            if (leftWildcard.isExtends()) {
                return TypeConversionUtil.isAssignable(leftBound, typeRight, false, false);
            }
            Boolean assignable = (Boolean)ourGuard.doPreventingRecursion(leftWildcard, true, new NotNullComputable<Boolean>(){

                @NotNull
                public Boolean compute() {
                    Boolean bl = TypeConversionUtil.isAssignable(typeRight, leftBound, false, false);
                    if (bl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$4", "compute"));
                    }
                    return bl;
                }
            });
            return assignable == null || assignable != false;
        }
        return typeLeft.equals(typeRight);
    }

    @Nullable
    public static PsiSubstitutor getClassSubstitutor(@NotNull PsiClass superClassCandidate, @NotNull PsiClass derivedClassCandidate, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClassCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClassCandidate", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getClassSubstitutor"));
        }
        if (derivedClassCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClassCandidate", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getClassSubstitutor"));
        }
        if (derivedSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getClassSubstitutor"));
        }
        if (superClassCandidate.getManager().areElementsEquivalent(superClassCandidate, derivedClassCandidate)) {
            PsiTypeParameter[] baseParams = superClassCandidate.getTypeParameters();
            PsiTypeParameter[] derivedParams = derivedClassCandidate.getTypeParameters();
            if (baseParams.length > 0 && derivedParams.length == 0) {
                return JavaPsiFacade.getInstance(superClassCandidate.getProject()).getElementFactory().createRawSubstitutor(superClassCandidate);
            }
            return derivedSubstitutor;
        }
        return TypeConversionUtil.getMaybeSuperClassSubstitutor(superClassCandidate, derivedClassCandidate, derivedSubstitutor, null);
    }

    @NotNull
    public static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
        }
        if (derivedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClass", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
        }
        if (derivedSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
        }
        if (!superClass.hasTypeParameters() && superClass.getContainingClass() == null) {
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
            }
            return psiSubstitutor;
        }
        THashSet<PsiClass> visited2 = new THashSet<PsiClass>();
        PsiSubstitutor substitutor2 = TypeConversionUtil.getMaybeSuperClassSubstitutor(superClass, derivedClass, derivedSubstitutor, visited2);
        if (substitutor2 == null) {
            if (ourReportedSuperClassSubstitutorExceptions.add(derivedClass.getQualifiedName() + "/" + superClass.getQualifiedName())) {
                TypeConversionUtil.reportHierarchyInconsistency(superClass, derivedClass, visited2);
            }
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
        }
        return psiSubstitutor;
    }

    @Nullable
    public static PsiSubstitutor getMaybeSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull PsiSubstitutor derivedSubstitutor, @Nullable Set<PsiClass> visited2) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getMaybeSuperClassSubstitutor"));
        }
        if (derivedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClass", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getMaybeSuperClassSubstitutor"));
        }
        if (derivedSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getMaybeSuperClassSubstitutor"));
        }
        return JavaClassSupers.getInstance().getSuperClassSubstitutor(superClass, derivedClass, derivedClass.getResolveScope(), derivedSubstitutor);
    }

    private static void reportHierarchyInconsistency(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull Set<PsiClass> visited2) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "reportHierarchyInconsistency"));
        }
        if (derivedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClass", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "reportHierarchyInconsistency"));
        }
        if (visited2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "reportHierarchyInconsistency"));
        }
        final StringBuilder msg2 = new StringBuilder("Super: " + TypeConversionUtil.classInfo(superClass));
        msg2.append("visited:\n");
        for (PsiClass aClass2 : visited2) {
            msg2.append("  each: " + TypeConversionUtil.classInfo(aClass2));
        }
        msg2.append("isInheritor: " + InheritanceUtil.isInheritorOrSelf(derivedClass, superClass, true) + " " + derivedClass.isInheritor(superClass, true));
        msg2.append("\nhierarchy:\n");
        InheritanceUtil.processSupers(derivedClass, true, new Processor<PsiClass>(){

            @Override
            public boolean process(PsiClass psiClass) {
                msg2.append("each: " + TypeConversionUtil.classInfo(psiClass));
                return true;
            }
        });
        LOG.error(msg2.toString());
    }

    @NotNull
    private static String classInfo(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "classInfo"));
        }
        String s = aClass2.getQualifiedName() + "(" + aClass2.getClass().getName() + "; " + PsiUtilCore.getVirtualFile(aClass2) + ");\n";
        s = s + "extends: ";
        for (PsiClassType type2 : aClass2.getExtendsListTypes()) {
            s = s + type2 + " (" + type2.getClass().getName() + "; " + type2.resolve() + ") ";
        }
        s = s + "\nimplements: ";
        for (PsiClassType type2 : aClass2.getImplementsListTypes()) {
            s = s + type2 + " (" + type2.getClass().getName() + "; " + type2.resolve() + ") ";
        }
        String string = s + "\n";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "classInfo"));
        }
        return string;
    }

    @NotNull
    public static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClassType classType) {
        if (superClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superClass", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
        }
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        PsiSubstitutor psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, classResolveResult.getElement(), classResolveResult.getSubstitutor());
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "getSuperClassSubstitutor"));
        }
        return psiSubstitutor;
    }

    @NotNull
    public static PsiType binaryNumericPromotion(PsiType type1, PsiType type2) {
        if (TypeConversionUtil.isDoubleType(type1)) {
            PsiType psiType = TypeConversionUtil.unbox(type1);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "binaryNumericPromotion"));
            }
            return psiType;
        }
        if (TypeConversionUtil.isDoubleType(type2)) {
            PsiType psiType = TypeConversionUtil.unbox(type2);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "binaryNumericPromotion"));
            }
            return psiType;
        }
        if (TypeConversionUtil.isFloatType(type1)) {
            PsiType psiType = TypeConversionUtil.unbox(type1);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "binaryNumericPromotion"));
            }
            return psiType;
        }
        if (TypeConversionUtil.isFloatType(type2)) {
            PsiType psiType = TypeConversionUtil.unbox(type2);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "binaryNumericPromotion"));
            }
            return psiType;
        }
        if (TypeConversionUtil.isLongType(type1)) {
            PsiType psiType = TypeConversionUtil.unbox(type1);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "binaryNumericPromotion"));
            }
            return psiType;
        }
        if (TypeConversionUtil.isLongType(type2)) {
            PsiType psiType = TypeConversionUtil.unbox(type2);
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "binaryNumericPromotion"));
            }
            return psiType;
        }
        PsiPrimitiveType psiPrimitiveType = PsiType.INT;
        if (psiPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "binaryNumericPromotion"));
        }
        return psiPrimitiveType;
    }

    @NotNull
    private static PsiType unbox(@NotNull PsiType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "unbox"));
        }
        if (type2 instanceof PsiPrimitiveType) {
            PsiType psiType = type2;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "unbox"));
            }
            return psiType;
        }
        if (type2 instanceof PsiClassType) {
            LOG.assertTrue((type2 = PsiPrimitiveType.getUnboxedType(type2)) != null);
            PsiType psiType = type2;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "unbox"));
            }
            return psiType;
        }
        LOG.error("Invalid type for unboxing " + type2);
        PsiType psiType = type2;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "unbox"));
        }
        return psiType;
    }

    public static boolean isIntegerNumber(String typeName) {
        return INTEGER_NUMBER_TYPES.contains(typeName);
    }

    public static boolean isPrimitive(String typeName) {
        return PRIMITIVE_TYPES.contains(typeName);
    }

    public static boolean isPrimitiveWrapper(String typeName) {
        return PRIMITIVE_WRAPPER_TYPES.contains(typeName);
    }

    @Contract(value="null -> false")
    public static boolean isAssignableFromPrimitiveWrapper(PsiType type2) {
        if (type2 == null) {
            return false;
        }
        return TypeConversionUtil.isPrimitiveWrapper(type2) || type2.equalsToText("java.lang.Object") || type2.equalsToText("java.lang.Number");
    }

    @Contract(value="null -> false")
    public static boolean isPrimitiveWrapper(PsiType type2) {
        return type2 != null && TypeConversionUtil.isPrimitiveWrapper(type2.getCanonicalText());
    }

    @Contract(value="null -> false")
    public static boolean isComposite(PsiType type2) {
        return type2 instanceof PsiDisjunctionType || type2 instanceof PsiIntersectionType;
    }

    public static PsiType typeParameterErasure(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "typeParameterErasure"));
        }
        return TypeConversionUtil.typeParameterErasure(typeParameter, PsiSubstitutor.EMPTY);
    }

    private static PsiType typeParameterErasure(@NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor beforeSubstitutor) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "typeParameterErasure"));
        }
        if (beforeSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "typeParameterErasure"));
        }
        PsiClassType[] extendsList = typeParameter.getExtendsList().getReferencedTypes();
        if (extendsList.length > 0) {
            PsiClass psiClass = extendsList[0].resolve();
            if (psiClass instanceof PsiTypeParameter) {
                THashSet<PsiClass> visited2 = new THashSet<PsiClass>();
                visited2.add(psiClass);
                PsiTypeParameter boundTypeParameter = (PsiTypeParameter)psiClass;
                if (beforeSubstitutor.getSubstitutionMap().containsKey(boundTypeParameter)) {
                    return TypeConversionUtil.erasure(beforeSubstitutor.substitute(boundTypeParameter));
                }
                return TypeConversionUtil.typeParameterErasureInner(boundTypeParameter, visited2, beforeSubstitutor);
            }
            if (psiClass != null) {
                return JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(psiClass);
            }
        }
        return PsiType.getJavaLangObject(typeParameter.getManager(), typeParameter.getResolveScope());
    }

    private static PsiClassType typeParameterErasureInner(PsiTypeParameter typeParameter, Set<PsiClass> visited2, PsiSubstitutor beforeSubstitutor) {
        PsiClassType[] extendsList = typeParameter.getExtendsList().getReferencedTypes();
        if (extendsList.length > 0) {
            PsiClass psiClass = extendsList[0].resolve();
            if (psiClass instanceof PsiTypeParameter) {
                if (!visited2.contains(psiClass)) {
                    visited2.add(psiClass);
                    if (beforeSubstitutor.getSubstitutionMap().containsKey(psiClass)) {
                        return (PsiClassType)TypeConversionUtil.erasure(beforeSubstitutor.substitute((PsiTypeParameter)psiClass));
                    }
                    return TypeConversionUtil.typeParameterErasureInner((PsiTypeParameter)psiClass, visited2, beforeSubstitutor);
                }
            } else if (psiClass != null) {
                return JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(psiClass);
            }
        }
        return PsiType.getJavaLangObject(typeParameter.getManager(), typeParameter.getResolveScope());
    }

    @Contract(value="null -> null")
    public static PsiType erasure(@Nullable PsiType type2) {
        return TypeConversionUtil.erasure(type2, PsiSubstitutor.EMPTY);
    }

    @Contract(value="null, _ -> null")
    public static PsiType erasure(@Nullable PsiType type2, final @NotNull PsiSubstitutor beforeSubstitutor) {
        if (beforeSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeSubstitutor", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "erasure"));
        }
        if (type2 == null) {
            return null;
        }
        return type2.accept(new PsiTypeVisitor<PsiType>(){

            @Override
            @Nullable
            public PsiType visitType(PsiType type2) {
                return type2;
            }

            @Override
            public PsiType visitClassType(PsiClassType classType) {
                PsiClass aClass2 = classType.resolve();
                if (aClass2 instanceof PsiTypeParameter && !TypeConversionUtil.isFreshVariable((PsiTypeParameter)aClass2)) {
                    return TypeConversionUtil.typeParameterErasure((PsiTypeParameter)aClass2, beforeSubstitutor);
                }
                return classType.rawType();
            }

            @Override
            public PsiType visitWildcardType(PsiWildcardType wildcardType) {
                return wildcardType;
            }

            @Override
            @Nullable
            public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                return capturedWildcardType.getUpperBound().accept(this);
            }

            @Override
            public PsiType visitPrimitiveType(PsiPrimitiveType primitiveType) {
                return primitiveType;
            }

            @Override
            public PsiType visitEllipsisType(PsiEllipsisType ellipsisType) {
                PsiType componentType = ellipsisType.getComponentType();
                PsiType newComponentType = componentType.accept(this);
                if (newComponentType == componentType) {
                    return ellipsisType;
                }
                return newComponentType != null ? newComponentType.createArrayType() : null;
            }

            @Override
            public PsiType visitArrayType(PsiArrayType arrayType) {
                PsiType componentType = arrayType.getComponentType();
                PsiType newComponentType = componentType.accept(this);
                if (newComponentType == componentType) {
                    return arrayType;
                }
                return newComponentType != null ? newComponentType.createArrayType() : null;
            }

            @Override
            public PsiType visitDisjunctionType(PsiDisjunctionType disjunctionType) {
                PsiClassType lub = PsiTypesUtil.getLowestUpperBoundClassType(disjunctionType);
                return lub != null ? TypeConversionUtil.erasure(lub, beforeSubstitutor) : disjunctionType;
            }
        });
    }

    public static Object computeCastTo(Object operand, PsiType castType) {
        Object value;
        if (operand == null || castType == null) {
            return null;
        }
        if (operand instanceof String && castType.equalsToText("java.lang.String")) {
            value = operand;
        } else if (operand instanceof Boolean && PsiType.BOOLEAN.equals(castType)) {
            value = operand;
        } else {
            PsiType primitiveType = TypeConversionUtil.wrapperToPrimitive(operand);
            if (primitiveType == null) {
                return null;
            }
            if (castType.equals(primitiveType)) {
                return operand;
            }
            int rankFrom = TypeConversionUtil.getTypeRank(primitiveType);
            if (rankFrom > caster.length) {
                return null;
            }
            int rankTo = TypeConversionUtil.getTypeRank(castType);
            if (rankTo > caster.length) {
                return null;
            }
            value = caster[rankFrom - 1][rankTo - 1].cast(operand);
        }
        return value;
    }

    @NotNull
    public static PsiType unboxAndBalanceTypes(PsiType type1, PsiType type2) {
        if (type1 instanceof PsiClassType) {
            type1 = PsiPrimitiveType.getUnboxedType(type1);
        }
        if (type2 instanceof PsiClassType) {
            type2 = PsiPrimitiveType.getUnboxedType(type2);
        }
        if (PsiType.DOUBLE.equals(type1) || PsiType.DOUBLE.equals(type2)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.DOUBLE;
            if (psiPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "unboxAndBalanceTypes"));
            }
            return psiPrimitiveType;
        }
        if (PsiType.FLOAT.equals(type1) || PsiType.FLOAT.equals(type2)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.FLOAT;
            if (psiPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "unboxAndBalanceTypes"));
            }
            return psiPrimitiveType;
        }
        if (PsiType.LONG.equals(type1) || PsiType.LONG.equals(type2)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.LONG;
            if (psiPrimitiveType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "unboxAndBalanceTypes"));
            }
            return psiPrimitiveType;
        }
        PsiPrimitiveType psiPrimitiveType = PsiType.INT;
        if (psiPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "unboxAndBalanceTypes"));
        }
        return psiPrimitiveType;
    }

    public static IElementType convertEQtoOperation(IElementType eqOpSign) {
        IElementType opSign = null;
        if (eqOpSign == JavaTokenType.ANDEQ) {
            opSign = JavaTokenType.AND;
        } else if (eqOpSign == JavaTokenType.ASTERISKEQ) {
            opSign = JavaTokenType.ASTERISK;
        } else if (eqOpSign == JavaTokenType.DIVEQ) {
            opSign = JavaTokenType.DIV;
        } else if (eqOpSign == JavaTokenType.GTGTEQ) {
            opSign = JavaTokenType.GTGT;
        } else if (eqOpSign == JavaTokenType.GTGTGTEQ) {
            opSign = JavaTokenType.GTGTGT;
        } else if (eqOpSign == JavaTokenType.LTLTEQ) {
            opSign = JavaTokenType.LTLT;
        } else if (eqOpSign == JavaTokenType.MINUSEQ) {
            opSign = JavaTokenType.MINUS;
        } else if (eqOpSign == JavaTokenType.OREQ) {
            opSign = JavaTokenType.OR;
        } else if (eqOpSign == JavaTokenType.PERCEQ) {
            opSign = JavaTokenType.PERC;
        } else if (eqOpSign == JavaTokenType.PLUSEQ) {
            opSign = JavaTokenType.PLUS;
        } else if (eqOpSign == JavaTokenType.XOREQ) {
            opSign = JavaTokenType.XOR;
        }
        return opSign;
    }

    @Nullable
    public static PsiType calcTypeForBinaryExpression(PsiType lType, PsiType rType, @NotNull IElementType sign, boolean accessLType) {
        if (sign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sign", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "calcTypeForBinaryExpression"));
        }
        if (sign == JavaTokenType.PLUS) {
            if (rType == null) {
                return null;
            }
            if (rType.equalsToText("java.lang.String")) {
                return rType;
            }
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            if (lType.equalsToText("java.lang.String")) {
                return lType;
            }
            return TypeConversionUtil.unboxAndBalanceTypes(lType, rType);
        }
        if (sign == JavaTokenType.MINUS || sign == JavaTokenType.ASTERISK || sign == JavaTokenType.DIV || sign == JavaTokenType.PERC) {
            if (rType == null) {
                return null;
            }
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            return TypeConversionUtil.unboxAndBalanceTypes(lType, rType);
        }
        if (sign == JavaTokenType.LTLT || sign == JavaTokenType.GTGT || sign == JavaTokenType.GTGTGT) {
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (PsiType.BYTE.equals(lType) || PsiType.CHAR.equals(lType) || PsiType.SHORT.equals(lType)) {
                return PsiType.INT;
            }
            if (lType instanceof PsiClassType) {
                lType = PsiPrimitiveType.getUnboxedType(lType);
            }
            return lType;
        }
        if (sign == JavaTokenType.EQEQ || sign == JavaTokenType.NE || sign == JavaTokenType.LT || sign == JavaTokenType.GT || sign == JavaTokenType.LE || sign == JavaTokenType.GE || sign == JavaTokenType.OROR || sign == JavaTokenType.ANDAND) {
            return PsiType.BOOLEAN;
        }
        if (sign == JavaTokenType.OR || sign == JavaTokenType.XOR || sign == JavaTokenType.AND) {
            if (rType instanceof PsiClassType) {
                rType = PsiPrimitiveType.getUnboxedType(rType);
            }
            if (lType instanceof PsiClassType) {
                lType = PsiPrimitiveType.getUnboxedType(lType);
            }
            if (rType == null) {
                return null;
            }
            if (PsiType.BOOLEAN.equals(rType)) {
                return PsiType.BOOLEAN;
            }
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            if (PsiType.BOOLEAN.equals(lType)) {
                return PsiType.BOOLEAN;
            }
            if (PsiType.LONG.equals(lType) || PsiType.LONG.equals(rType)) {
                return PsiType.LONG;
            }
            return PsiType.INT;
        }
        LOG.error("Unknown token: " + sign);
        return null;
    }

    public static boolean isFPZero(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "isFPZero"));
        }
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (Character.isDigit(c) && c != '0') {
                return false;
            }
            char d = Character.toUpperCase(c);
            if (d == 'E' || d == 'P') break;
        }
        return true;
    }

    public static boolean areSameFreshVariables(PsiTypeParameter p1, PsiTypeParameter p2) {
        PsiElement originalContext = p1.getUserData(ORIGINAL_CONTEXT);
        return originalContext != null && originalContext == p2.getUserData(ORIGINAL_CONTEXT);
    }

    public static boolean isFreshVariable(PsiTypeParameter typeParameter) {
        return typeParameter.getUserData(ORIGINAL_CONTEXT) != null;
    }

    public static void markAsFreshVariable(PsiTypeParameter parameter, PsiElement context) {
        parameter.putUserData(ORIGINAL_CONTEXT, context);
    }

    private static PsiType wrapperToPrimitive(@NotNull Object o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil", "wrapperToPrimitive"));
        }
        return WRAPPER_TO_PRIMITIVE.get(o.getClass());
    }

    static {
        TYPE_TO_RANK_MAP.put(PsiType.BYTE, 1);
        TYPE_TO_RANK_MAP.put(PsiType.SHORT, 2);
        TYPE_TO_RANK_MAP.put(PsiType.CHAR, 3);
        TYPE_TO_RANK_MAP.put(PsiType.INT, 4);
        TYPE_TO_RANK_MAP.put(PsiType.LONG, 5);
        TYPE_TO_RANK_MAP.put(PsiType.FLOAT, 6);
        TYPE_TO_RANK_MAP.put(PsiType.DOUBLE, 7);
        TYPE_TO_RANK_MAP.put(PsiType.BOOLEAN, 10);
        POSSIBLE_BOXED_HOLDER_TYPES = Key.create("Types that may be possibly assigned from primitive ones");
        ourGuard = RecursionManager.createGuard("isAssignable");
        ourReportedSuperClassSubstitutorExceptions = ContainerUtil.newConcurrentSet();
        INTEGER_NUMBER_TYPES = new THashSet<String>(5);
        INTEGER_NUMBER_TYPES.add(PsiType.BYTE.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.CHAR.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.LONG.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.INT.getCanonicalText());
        INTEGER_NUMBER_TYPES.add(PsiType.SHORT.getCanonicalText());
        PRIMITIVE_TYPES = new THashSet<String>(9);
        PRIMITIVE_TYPES.add(PsiType.VOID.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.BYTE.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.CHAR.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.DOUBLE.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.FLOAT.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.LONG.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.INT.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.SHORT.getCanonicalText());
        PRIMITIVE_TYPES.add(PsiType.BOOLEAN.getCanonicalText());
        PRIMITIVE_WRAPPER_TYPES = new THashSet<String>(8);
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Byte");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Character");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Double");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Float");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Long");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Integer");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Short");
        PRIMITIVE_WRAPPER_TYPES.add("java.lang.Boolean");
        caster = new Caster[][]{{new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$7", "cast"));
                }
                Object object = operand;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$7", "cast"));
                }
                return object;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$8", "cast"));
                }
                Short s = (short)((Number)operand).intValue();
                if (s == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$8", "cast"));
                }
                return s;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$9", "cast"));
                }
                Character c = Character.valueOf((char)((Number)operand).intValue());
                if (c == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$9", "cast"));
                }
                return c;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$10", "cast"));
                }
                Integer n = ((Number)operand).intValue();
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$10", "cast"));
                }
                return n;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$11", "cast"));
                }
                Long l = ((Number)operand).intValue();
                if (l == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$11", "cast"));
                }
                return l;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$12", "cast"));
                }
                Float f = Float.valueOf(((Number)operand).intValue());
                if (f == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$12", "cast"));
                }
                return f;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$13", "cast"));
                }
                Double d = ((Number)operand).intValue();
                if (d == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$13", "cast"));
                }
                return d;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$14", "cast"));
                }
                Byte by = (byte)((Short)operand).shortValue();
                if (by == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$14", "cast"));
                }
                return by;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$15", "cast"));
                }
                Object object = operand;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$15", "cast"));
                }
                return object;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$16", "cast"));
                }
                Character c = Character.valueOf((char)((Short)operand).shortValue());
                if (c == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$16", "cast"));
                }
                return c;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$17", "cast"));
                }
                Integer n = (int)((Short)operand);
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$17", "cast"));
                }
                return n;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$18", "cast"));
                }
                Long l = (long)((Short)operand);
                if (l == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$18", "cast"));
                }
                return l;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$19", "cast"));
                }
                Float f = Float.valueOf(((Short)operand).shortValue());
                if (f == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$19", "cast"));
                }
                return f;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$20", "cast"));
                }
                Double d = (double)((Short)operand);
                if (d == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$20", "cast"));
                }
                return d;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$21", "cast"));
                }
                Byte by = (byte)((Character)operand).charValue();
                if (by == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$21", "cast"));
                }
                return by;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$22", "cast"));
                }
                Short s = (short)((Character)operand).charValue();
                if (s == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$22", "cast"));
                }
                return s;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$23", "cast"));
                }
                Object object = operand;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$23", "cast"));
                }
                return object;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$24", "cast"));
                }
                Integer n = ((Character)operand).charValue();
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$24", "cast"));
                }
                return n;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$25", "cast"));
                }
                Long l = ((Character)operand).charValue();
                if (l == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$25", "cast"));
                }
                return l;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$26", "cast"));
                }
                Float f = Float.valueOf(((Character)operand).charValue());
                if (f == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$26", "cast"));
                }
                return f;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$27", "cast"));
                }
                Double d = ((Character)operand).charValue();
                if (d == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$27", "cast"));
                }
                return d;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$28", "cast"));
                }
                Byte by = (byte)((Integer)operand).intValue();
                if (by == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$28", "cast"));
                }
                return by;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$29", "cast"));
                }
                Short s = (short)((Integer)operand).intValue();
                if (s == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$29", "cast"));
                }
                return s;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$30", "cast"));
                }
                Character c = Character.valueOf((char)((Integer)operand).intValue());
                if (c == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$30", "cast"));
                }
                return c;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$31", "cast"));
                }
                Object object = operand;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$31", "cast"));
                }
                return object;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$32", "cast"));
                }
                Long l = (long)((Integer)operand);
                if (l == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$32", "cast"));
                }
                return l;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$33", "cast"));
                }
                Float f = Float.valueOf(((Integer)operand).intValue());
                if (f == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$33", "cast"));
                }
                return f;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$34", "cast"));
                }
                Double d = (double)((Integer)operand);
                if (d == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$34", "cast"));
                }
                return d;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$35", "cast"));
                }
                Byte by = (byte)((Long)operand).longValue();
                if (by == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$35", "cast"));
                }
                return by;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$36", "cast"));
                }
                Short s = (short)((Long)operand).longValue();
                if (s == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$36", "cast"));
                }
                return s;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$37", "cast"));
                }
                Character c = Character.valueOf((char)((Long)operand).longValue());
                if (c == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$37", "cast"));
                }
                return c;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$38", "cast"));
                }
                Integer n = (int)((Long)operand).longValue();
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$38", "cast"));
                }
                return n;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$39", "cast"));
                }
                Object object = operand;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$39", "cast"));
                }
                return object;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$40", "cast"));
                }
                Float f = Float.valueOf(((Long)operand).longValue());
                if (f == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$40", "cast"));
                }
                return f;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$41", "cast"));
                }
                Double d = (double)((Long)operand);
                if (d == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$41", "cast"));
                }
                return d;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$42", "cast"));
                }
                Byte by = (byte)((Float)operand).floatValue();
                if (by == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$42", "cast"));
                }
                return by;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$43", "cast"));
                }
                Short s = (short)((Float)operand).floatValue();
                if (s == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$43", "cast"));
                }
                return s;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$44", "cast"));
                }
                Character c = Character.valueOf((char)((Float)operand).floatValue());
                if (c == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$44", "cast"));
                }
                return c;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$45", "cast"));
                }
                Integer n = (int)((Float)operand).floatValue();
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$45", "cast"));
                }
                return n;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$46", "cast"));
                }
                Long l = (long)((Float)operand).floatValue();
                if (l == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$46", "cast"));
                }
                return l;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$47", "cast"));
                }
                Object object = operand;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$47", "cast"));
                }
                return object;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$48", "cast"));
                }
                Double d = ((Float)operand).floatValue();
                if (d == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$48", "cast"));
                }
                return d;
            }
        }}, {new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$49", "cast"));
                }
                Byte by = (byte)((Double)operand).doubleValue();
                if (by == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$49", "cast"));
                }
                return by;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$50", "cast"));
                }
                Short s = (short)((Double)operand).doubleValue();
                if (s == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$50", "cast"));
                }
                return s;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$51", "cast"));
                }
                Character c = Character.valueOf((char)((Double)operand).doubleValue());
                if (c == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$51", "cast"));
                }
                return c;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$52", "cast"));
                }
                Integer n = (int)((Double)operand).doubleValue();
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$52", "cast"));
                }
                return n;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$53", "cast"));
                }
                Long l = (long)((Double)operand).doubleValue();
                if (l == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$53", "cast"));
                }
                return l;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$54", "cast"));
                }
                Float f = new Float((Double)operand);
                if (f == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$54", "cast"));
                }
                return f;
            }
        }, new Caster(){

            @Override
            @NotNull
            public Object cast(@NotNull Object operand) {
                if (operand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operand", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$55", "cast"));
                }
                Object object = operand;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$55", "cast"));
                }
                return object;
            }
        }}};
        WRAPPER_TO_PRIMITIVE = new THashMap<Class, PsiType>(8);
        WRAPPER_TO_PRIMITIVE.put(Boolean.class, PsiType.BOOLEAN);
        WRAPPER_TO_PRIMITIVE.put(Byte.class, PsiType.BYTE);
        WRAPPER_TO_PRIMITIVE.put(Character.class, PsiType.CHAR);
        WRAPPER_TO_PRIMITIVE.put(Short.class, PsiType.SHORT);
        WRAPPER_TO_PRIMITIVE.put(Integer.class, PsiType.INT);
        WRAPPER_TO_PRIMITIVE.put(Long.class, PsiType.LONG);
        WRAPPER_TO_PRIMITIVE.put(Float.class, PsiType.FLOAT);
        WRAPPER_TO_PRIMITIVE.put(Double.class, PsiType.DOUBLE);
    }

    private static interface Caster {
        @NotNull
        public Object cast(@NotNull Object var1);
    }
}

