/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.containers.SLRUMap;
import org.jetbrains.kotlin.com.intellij.util.containers.hash.EqualityPolicy;

public abstract class SLRUCache<K, V>
extends SLRUMap<K, V> {
    protected SLRUCache(int protectedQueueSize, int probationalQueueSize) {
        super(protectedQueueSize, probationalQueueSize);
    }

    protected SLRUCache(int protectedQueueSize, int probationalQueueSize, EqualityPolicy<K> hashingStrategy) {
        super(protectedQueueSize, probationalQueueSize, hashingStrategy);
    }

    @NotNull
    public abstract V createValue(K var1);

    @Override
    @NotNull
    public V get(K key) {
        Object value = super.get(key);
        if (value != null) {
            Object v = value;
            if (v == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/SLRUCache", "get"));
            }
            return v;
        }
        value = this.createValue(key);
        this.put(key, value);
        Object v = value;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/SLRUCache", "get"));
        }
        return v;
    }

    @Nullable
    public V getIfCached(K key) {
        return super.get(key);
    }
}

