/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.sam;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.load.java.components.SamConversionResolver;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaConstructorDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamAdapterDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaClassDescriptor;
import org.jetbrains.kotlin.load.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J!\u0010\u0007\u001a\u0004\u0018\u0001H\b\"\b\b\u0000\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u0002H\bH\u0017\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/load/java/sam/SamConversionResolverImpl;", "Lorg/jetbrains/kotlin/load/java/components/SamConversionResolver;", "()V", "resolveFunctionTypeIfSamInterface", "Lorg/jetbrains/kotlin/types/SimpleType;", "classDescriptor", "Lorg/jetbrains/kotlin/load/java/descriptors/JavaClassDescriptor;", "resolveSamAdapter", "D", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "original", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "resolveSamConstructor", "Lorg/jetbrains/kotlin/load/java/descriptors/SamConstructorDescriptor;", "constructorOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "classifier", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "kotlin-compiler"})
public final class SamConversionResolverImpl
implements SamConversionResolver {
    public static final SamConversionResolverImpl INSTANCE;

    @Override
    @Nullable
    public SamConstructorDescriptor resolveSamConstructor(@NotNull DeclarationDescriptor constructorOwner, @NotNull Function0<? extends ClassifierDescriptor> classifier) {
        Intrinsics.checkParameterIsNotNull(constructorOwner, "constructorOwner");
        Intrinsics.checkParameterIsNotNull(classifier, "classifier");
        ClassifierDescriptor classifierDescriptor = classifier.invoke();
        if (!(classifierDescriptor instanceof LazyJavaClassDescriptor) || ((LazyJavaClassDescriptor)classifierDescriptor).getFunctionTypeForSamInterface() == null) {
            return null;
        }
        return SingleAbstractMethodUtils.createSamConstructorFunction(constructorOwner, (JavaClassDescriptor)classifierDescriptor);
    }

    @Override
    @Nullable
    public <D extends FunctionDescriptor> D resolveSamAdapter(@NotNull D original) {
        FunctionDescriptor functionDescriptor;
        Intrinsics.checkParameterIsNotNull(original, "original");
        if (!SingleAbstractMethodUtils.isSamAdapterNecessary(original)) {
            functionDescriptor = null;
        } else if (original instanceof JavaConstructorDescriptor) {
            SamAdapterDescriptor<JavaConstructorDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.createSamAdapterConstructor((JavaConstructorDescriptor)original);
            if (samAdapterDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type D");
            }
            functionDescriptor = samAdapterDescriptor;
        } else if (original instanceof JavaMethodDescriptor) {
            SamAdapterDescriptor<JavaMethodDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.createSamAdapterFunction((JavaMethodDescriptor)original);
            if (samAdapterDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type D");
            }
            functionDescriptor = samAdapterDescriptor;
        } else {
            functionDescriptor = null;
        }
        return (D)functionDescriptor;
    }

    @Override
    @Nullable
    public SimpleType resolveFunctionTypeIfSamInterface(@NotNull JavaClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        FunctionDescriptor functionDescriptor = SingleAbstractMethodUtils.getSingleAbstractMethodOrNull(classDescriptor);
        if (functionDescriptor == null) {
            return null;
        }
        FunctionDescriptor abstractMethod = functionDescriptor;
        return SingleAbstractMethodUtils.getFunctionTypeForAbstractMethod(abstractMethod);
    }

    private SamConversionResolverImpl() {
        INSTANCE = this;
    }

    static {
        new SamConversionResolverImpl();
    }
}

