/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtPackageDirective
extends KtModifierListOwnerStub<KotlinPlaceHolderStub<KtPackageDirective>> {
    private String qualifiedNameCache;

    public KtPackageDirective(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/KtPackageDirective", "<init>"));
        }
        super(node);
        this.qualifiedNameCache = null;
    }

    public KtPackageDirective(@NotNull KotlinPlaceHolderStub<KtPackageDirective> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/KtPackageDirective", "<init>"));
        }
        super(stub, KtStubElementTypes.PACKAGE_DIRECTIVE);
        this.qualifiedNameCache = null;
    }

    @Nullable
    public KtExpression getPackageNameExpression() {
        return KtStubbedPsiUtil.getStubOrPsiChild(this, KtStubElementTypes.INSIDE_DIRECTIVE_EXPRESSIONS, KtExpression.ARRAY_FACTORY);
    }

    @NotNull
    public List<KtSimpleNameExpression> getPackageNames() {
        KtExpression nameExpression = this.getPackageNameExpression();
        if (nameExpression == null) {
            List<KtSimpleNameExpression> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPackageDirective", "getPackageNames"));
            }
            return list2;
        }
        ArrayList<KtSimpleNameExpression> packageNames = ContainerUtil.newArrayList();
        while (nameExpression instanceof KtQualifiedExpression) {
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)nameExpression;
            KtExpression selector = qualifiedExpression.getSelectorExpression();
            if (selector instanceof KtSimpleNameExpression) {
                packageNames.add((KtSimpleNameExpression)selector);
            }
            nameExpression = qualifiedExpression.getReceiverExpression();
        }
        if (nameExpression instanceof KtSimpleNameExpression) {
            packageNames.add((KtSimpleNameExpression)nameExpression);
        }
        Collections.reverse(packageNames);
        ArrayList<KtSimpleNameExpression> arrayList = packageNames;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPackageDirective", "getPackageNames"));
        }
        return arrayList;
    }

    @Nullable
    public KtSimpleNameExpression getLastReferenceExpression() {
        KtExpression nameExpression = this.getPackageNameExpression();
        if (nameExpression == null) {
            return null;
        }
        return (KtSimpleNameExpression)KtPsiUtilKt.getQualifiedElementSelector(nameExpression);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        KtSimpleNameExpression lastPart = this.getLastReferenceExpression();
        return lastPart != null ? lastPart.getIdentifier() : null;
    }

    @Override
    @NotNull
    public String getName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        String string = nameIdentifier == null ? "" : nameIdentifier.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPackageDirective", "getName"));
        }
        return string;
    }

    @NotNull
    public Name getNameAsName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        Name name = nameIdentifier == null ? SpecialNames.ROOT_PACKAGE : Name.identifier(nameIdentifier.getText());
        if (name == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPackageDirective", "getNameAsName"));
        }
        return name;
    }

    public boolean isRoot() {
        return this.getName().length() == 0;
    }

    @NotNull
    public FqName getFqName() {
        String qualifiedName = this.getQualifiedName();
        FqName fqName2 = qualifiedName.isEmpty() ? FqName.ROOT : new FqName(qualifiedName);
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPackageDirective", "getFqName"));
        }
        return fqName2;
    }

    @NotNull
    public FqName getFqName(KtSimpleNameExpression nameExpression) {
        FqName fqName2 = new FqName(this.getQualifiedNameOf(nameExpression));
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPackageDirective", "getFqName"));
        }
        return fqName2;
    }

    public void setFqName(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/psi/KtPackageDirective", "setFqName"));
        }
        if (fqName2.isRoot()) {
            this.delete();
            return;
        }
        KtPsiFactory psiFactory = new KtPsiFactory(this.getProject());
        KtExpression newExpression = psiFactory.createExpression(fqName2.asString());
        KtExpression currentExpression = this.getPackageNameExpression();
        if (currentExpression != null) {
            currentExpression.replace(newExpression);
            return;
        }
        PsiElement keyword = this.getPackageKeyword();
        if (keyword != null) {
            this.addAfter(newExpression, keyword);
            return;
        }
        this.replace(psiFactory.createPackageDirective(fqName2));
    }

    @NotNull
    public String getQualifiedName() {
        if (this.qualifiedNameCache == null) {
            this.qualifiedNameCache = this.getQualifiedNameOf(null);
        }
        String string = this.qualifiedNameCache;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPackageDirective", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    private String getQualifiedNameOf(@Nullable KtSimpleNameExpression nameExpression) {
        StringBuilder builder = new StringBuilder();
        for (KtSimpleNameExpression e : this.getPackageNames()) {
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(e.getReferencedName());
            if (e != nameExpression) continue;
            break;
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/KtPackageDirective", "getQualifiedNameOf"));
        }
        return string;
    }

    @Nullable
    public PsiElement getPackageKeyword() {
        return this.findChildByType(KtTokens.PACKAGE_KEYWORD);
    }

    @Override
    public void subtreeChanged() {
        this.qualifiedNameCache = null;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/KtPackageDirective", "accept"));
        }
        return visitor2.visitPackageDirective(this, data);
    }
}

