/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.maven;

import java.io.IOException;
import java.util.Set;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.gradle.internal.io.StreamByteBuffer;

public class MavenProjectXmlWriter {
    String toXml(Set<MavenProject> projects) {
        assert (!projects.isEmpty()) : "Cannot prepare the Maven projects effective XML because provided projects set is empty.";
        if (projects.size() == 1) {
            return this.toXml(projects.iterator().next());
        }
        StringBuilder out = new StringBuilder("<projects>");
        for (MavenProject project : projects) {
            out.append(this.toXml(project));
        }
        return out.append("</projects>").toString();
    }

    private String toXml(MavenProject project) {
        StreamByteBuffer out = new StreamByteBuffer();
        try {
            new MavenXpp3Writer().write(out.getOutputStream(), project.getModel());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize Maven model to XML. Maven project: " + project, e);
        }
        return this.prepareXml(out.readAsString());
    }

    String prepareXml(String xml) {
        return xml.replaceFirst("^<\\?xml.+?\\?>", "");
    }
}

