/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.testing.DefaultTestClassDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestDescriptor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionListener;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.id.IdGenerator;

public class TestClassExecutionEventGenerator
implements TestResultProcessor,
TestClassExecutionListener {
    private final TestResultProcessor resultProcessor;
    private final IdGenerator<?> idGenerator;
    private final TimeProvider timeProvider;
    private final Set<Object> currentTests = new LinkedHashSet<Object>();
    private boolean testsStarted;
    private TestDescriptorInternal currentTestClass;

    public TestClassExecutionEventGenerator(TestResultProcessor resultProcessor, IdGenerator<?> idGenerator, TimeProvider timeProvider) {
        this.resultProcessor = resultProcessor;
        this.idGenerator = idGenerator;
        this.timeProvider = timeProvider;
    }

    @Override
    public void testClassStarted(String testClassName) {
        this.currentTestClass = new DefaultTestClassDescriptor(this.idGenerator.generateId(), testClassName);
        this.resultProcessor.started(this.currentTestClass, new TestStartEvent(this.timeProvider.getCurrentTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testClassFinished(Throwable failure) {
        long now = this.timeProvider.getCurrentTime();
        try {
            if (failure != null) {
                if (this.currentTests.isEmpty()) {
                    String testName = this.testsStarted ? "executionError" : "initializationError";
                    DefaultTestDescriptor initializationError = new DefaultTestDescriptor(this.idGenerator.generateId(), this.currentTestClass.getClassName(), testName);
                    this.resultProcessor.started((TestDescriptorInternal)initializationError, new TestStartEvent(now));
                    this.resultProcessor.failure(initializationError.getId(), failure);
                    this.resultProcessor.completed(initializationError.getId(), new TestCompleteEvent(now));
                } else {
                    for (Object test : this.currentTests) {
                        this.resultProcessor.failure(test, failure);
                        this.resultProcessor.completed(test, new TestCompleteEvent(now));
                    }
                }
            }
            this.resultProcessor.completed(this.currentTestClass.getId(), new TestCompleteEvent(now));
        }
        finally {
            this.testsStarted = false;
            this.currentTests.clear();
            this.currentTestClass = null;
        }
    }

    public void started(TestDescriptorInternal test, TestStartEvent event) {
        this.resultProcessor.started(test, event);
        this.testsStarted = true;
        this.currentTests.add(test.getId());
    }

    public void completed(Object testId, TestCompleteEvent event) {
        this.currentTests.remove(testId);
        this.resultProcessor.completed(testId, event);
    }

    public void output(Object testId, TestOutputEvent event) {
        this.resultProcessor.output(testId, event);
    }

    public void failure(Object testId, Throwable result) {
        this.resultProcessor.failure(testId, result);
    }
}

