/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.payloads;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;
import org.owasp.jbrofuzz.fuzz.io.LoadFuzzers;
import org.owasp.jbrofuzz.payloads.CategoriesRowListener;
import org.owasp.jbrofuzz.payloads.FuzzersRowListener;
import org.owasp.jbrofuzz.payloads.PayloadsRowListener;
import org.owasp.jbrofuzz.ui.AbstractPanel;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.ui.menu.JBroFuzzMenuBar;
import org.owasp.jbrofuzz.ui.tablemodels.SingleColumnModel;
import org.owasp.jbrofuzz.ui.viewers.PropertiesViewer;
import org.owasp.jbrofuzz.util.NonWrappingTextPane;
import org.owasp.jbrofuzz.version.JBroFuzzFormat;

public class PayloadsPanel
extends AbstractPanel {
    private static final long serialVersionUID = 1234567890L;
    private final JSplitPane mainSplitPanel;
    private final JSplitPane rightSplitPanel;
    private final JPanel categoriesPanel;
    protected final JPanel payloadsPanel;
    protected final JPanel fuzzersPanel;
    protected final JTable payloadsTable;
    protected final JTable fuzzersTable;
    protected final JTable categoriesTable;
    protected final SingleColumnModel payloadsTableModel;
    protected final SingleColumnModel fuzzersTableModel;
    protected final SingleColumnModel categoriesTableModel;
    private TableRowSorter<SingleColumnModel> sorter;
    protected TableRowSorter<SingleColumnModel> sorter2;
    protected final NonWrappingTextPane payloadInfoTextArea;
    protected final NonWrappingTextPane fuzzerInfoTextArea;

    public PayloadsPanel(JBroFuzzWindow m) {
        super(" Payloads ", m);
        this.setLayout(new BorderLayout());
        this.setOptionsAvailable(true, false, false, false, false);
        this.categoriesPanel = new JPanel(new BorderLayout());
        this.categoriesPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Categories "), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.categoriesTableModel = new SingleColumnModel(" Category Name ");
        this.categoriesTableModel.setData(m.getJBroFuzz().getDatabase().getAllCategories());
        this.categoriesTable = new JTable(this.categoriesTableModel);
        this.sorter = new TableRowSorter<SingleColumnModel>(this.categoriesTableModel);
        this.categoriesTable.setRowSorter(this.sorter);
        this.categoriesTable.getTableHeader().setToolTipText("Click to sort by row");
        this.categoriesTable.setSelectionMode(0);
        this.categoriesTable.setFont(new Font("Lucida Sans Typewriter", 1, 14));
        this.categoriesTable.setRowHeight(30);
        this.categoriesTable.getSelectionModel().addListSelectionListener(new CategoriesRowListener(this));
        this.categoriesTable.setBackground(Color.BLACK);
        this.categoriesTable.setForeground(Color.WHITE);
        this.popupTable(this.categoriesTable, false, false, true, false, false, false);
        JScrollPane categoryTableScrollPane = new JScrollPane(this.categoriesTable);
        categoryTableScrollPane.setVerticalScrollBarPolicy(20);
        categoryTableScrollPane.setHorizontalScrollBarPolicy(30);
        this.categoriesPanel.add(categoryTableScrollPane);
        this.fuzzersPanel = new JPanel(new BorderLayout());
        this.fuzzersPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Select a Category "), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.fuzzersTableModel = new SingleColumnModel(" Fuzzer Name ");
        this.fuzzersTable = new JTable(this.fuzzersTableModel);
        this.sorter2 = new TableRowSorter<SingleColumnModel>(this.fuzzersTableModel);
        this.fuzzersTable.setRowSorter(this.sorter2);
        this.fuzzersTable.getTableHeader().setToolTipText("Click to sort by row");
        this.fuzzersTable.setSelectionMode(0);
        this.fuzzersTable.setFont(new Font("Lucida Sans Typewriter", 1, 14));
        this.fuzzersTable.setRowHeight(30);
        this.fuzzersTable.getSelectionModel().addListSelectionListener(new FuzzersRowListener(this));
        this.fuzzersTable.setBackground(Color.BLACK);
        this.fuzzersTable.setForeground(Color.WHITE);
        this.popupTable(this.fuzzersTable, false, false, true, false, false, false);
        JScrollPane nameTextAreaTextScrollPane = new JScrollPane(this.fuzzersTable);
        nameTextAreaTextScrollPane.setVerticalScrollBarPolicy(20);
        nameTextAreaTextScrollPane.setHorizontalScrollBarPolicy(30);
        this.fuzzersPanel.add(Box.createRigidArea(new Dimension(0, 50)), "North");
        this.fuzzersPanel.add((Component)nameTextAreaTextScrollPane, "Center");
        this.payloadsTableModel = new SingleColumnModel(" Payloads ");
        this.payloadsTable = new JTable(this.payloadsTableModel);
        this.payloadsTable.setSelectionMode(0);
        this.payloadsTable.getTableHeader().setToolTipText("Click to specify sorting; Control-Click to specify secondary sorting");
        this.payloadsTable.setFont(new Font("Lucida Sans Typewriter", 1, 14));
        this.payloadsTable.setRowHeight(30);
        this.payloadsTable.getSelectionModel().addListSelectionListener(new PayloadsRowListener(this));
        this.payloadsTable.setBackground(Color.BLACK);
        this.payloadsTable.setForeground(Color.WHITE);
        this.payloadsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    String payload = (String)PayloadsPanel.this.payloadsTable.getModel().getValueAt(PayloadsPanel.this.payloadsTable.getSelectedRow(), 0);
                    new PropertiesViewer(PayloadsPanel.this, "Payload Information", payload);
                }
            }
        });
        this.popupTable(this.payloadsTable, false, false, true, false, false, true);
        JScrollPane payloadTableScrollPane = new JScrollPane(this.payloadsTable);
        payloadTableScrollPane.setVerticalScrollBarPolicy(20);
        payloadTableScrollPane.setHorizontalScrollBarPolicy(30);
        this.payloadsPanel = new JPanel(new BorderLayout());
        this.payloadsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Select a Fuzzer "), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.fuzzerInfoTextArea = new NonWrappingTextPane();
        this.fuzzerInfoTextArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Fuzzer Information "), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.fuzzerInfoTextArea.putClientProperty("charset", "UTF-8");
        this.fuzzerInfoTextArea.setEditable(false);
        this.fuzzerInfoTextArea.setVisible(true);
        this.fuzzerInfoTextArea.setFont(new Font("Verdana", 1, 10));
        this.fuzzerInfoTextArea.setMargin(new Insets(1, 1, 1, 1));
        this.fuzzerInfoTextArea.setBackground(Color.WHITE);
        this.fuzzerInfoTextArea.setForeground(Color.BLACK);
        AbstractPanel.popupText(this.fuzzerInfoTextArea, false, true, false, true);
        JScrollPane viewTextScrollPane = new JScrollPane(this.fuzzerInfoTextArea);
        viewTextScrollPane.setVerticalScrollBarPolicy(20);
        viewTextScrollPane.setHorizontalScrollBarPolicy(30);
        this.payloadInfoTextArea = new NonWrappingTextPane();
        this.payloadInfoTextArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" Payload Properties "), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.payloadInfoTextArea.setEditable(false);
        this.payloadInfoTextArea.setFont(new Font("Verdana", 1, 10));
        PayloadsPanel.popupText(this.payloadInfoTextArea, false, true, false, true);
        JScrollPane commentLabelScrollPane = new JScrollPane(this.payloadInfoTextArea);
        commentLabelScrollPane.setVerticalScrollBarPolicy(20);
        commentLabelScrollPane.setHorizontalScrollBarPolicy(30);
        JSplitPane bottomSplitPanel = new JSplitPane(1);
        bottomSplitPanel.setOneTouchExpandable(false);
        bottomSplitPanel.setRightComponent(commentLabelScrollPane);
        bottomSplitPanel.setLeftComponent(payloadTableScrollPane);
        JSplitPane payloadsSplitPanel = new JSplitPane(0);
        payloadsSplitPanel.setOneTouchExpandable(false);
        payloadsSplitPanel.setTopComponent(viewTextScrollPane);
        payloadsSplitPanel.setBottomComponent(bottomSplitPanel);
        this.payloadsPanel.add(Box.createRigidArea(new Dimension(0, 100)), "North");
        this.payloadsPanel.add((Component)payloadsSplitPanel, "Center");
        payloadsSplitPanel.setDividerLocation(100);
        bottomSplitPanel.setDividerLocation(300);
        this.rightSplitPanel = new JSplitPane(1);
        this.rightSplitPanel.setOneTouchExpandable(false);
        this.rightSplitPanel.setLeftComponent(this.fuzzersPanel);
        this.rightSplitPanel.setRightComponent(this.payloadsPanel);
        this.mainSplitPanel = new JSplitPane(1);
        this.mainSplitPanel.setOneTouchExpandable(false);
        this.mainSplitPanel.setLeftComponent(this.categoriesPanel);
        this.mainSplitPanel.setRightComponent(this.rightSplitPanel);
        this.mainSplitPanel.setDividerLocation(250);
        this.rightSplitPanel.setDividerLocation(250);
        viewTextScrollPane.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        bottomSplitPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        commentLabelScrollPane.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        payloadTableScrollPane.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.categoriesPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.rightSplitPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.payloadsPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.fuzzersPanel.setMinimumSize(JBroFuzzFormat.ZERO_DIM);
        this.add((Component)this.mainSplitPanel, "Center");
    }

    @Override
    public void add() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void remove() {
    }

    public void setCategoryDisplayed(String category) {
        int c = 0;
        String[] allRows = this.categoriesTableModel.getAllRows();
        int i = 0;
        while (i < allRows.length) {
            if (allRows[i].equalsIgnoreCase(category)) {
                c = i;
            }
            ++i;
        }
        this.categoriesTable.getSelectionModel().setSelectionInterval(this.categoriesTable.convertRowIndexToModel(c), this.categoriesTable.convertRowIndexToModel(c));
    }

    protected void setFuzzerDisplayed(String fuzzer, String category) {
        int c = 0;
        String[] allRows = this.categoriesTableModel.getAllRows();
        int i = 0;
        while (i < allRows.length) {
            if (allRows[i].equalsIgnoreCase(category)) {
                c = i;
            }
            ++i;
        }
        this.categoriesTable.getSelectionModel().setSelectionInterval(this.categoriesTable.convertRowIndexToModel(c), this.categoriesTable.convertRowIndexToModel(c));
        int d = 0;
        String[] allNames = this.fuzzersTableModel.getAllRows();
        int j = 0;
        while (j < allNames.length) {
            if (allNames[j].equalsIgnoreCase(fuzzer)) {
                d = j;
            }
            ++j;
        }
        this.fuzzersTable.getSelectionModel().setSelectionInterval(this.fuzzersTable.convertRowIndexToModel(d), this.fuzzersTable.convertRowIndexToModel(d));
    }

    protected void setPayloadDisplayed(String payload, String fuzzer, String category) {
        int c = 0;
        String[] allRows = this.categoriesTableModel.getAllRows();
        int i = 0;
        while (i < allRows.length) {
            if (allRows[i].equalsIgnoreCase(category)) {
                c = i;
            }
            ++i;
        }
        this.categoriesTable.getSelectionModel().setSelectionInterval(this.categoriesTable.convertRowIndexToModel(c), this.categoriesTable.convertRowIndexToModel(c));
        int d = 0;
        String[] allNames = this.fuzzersTableModel.getAllRows();
        int j = 0;
        while (j < allNames.length) {
            if (allNames[j].equalsIgnoreCase(fuzzer)) {
                d = j;
            }
            ++j;
        }
        this.fuzzersTable.getSelectionModel().setSelectionInterval(this.fuzzersTable.convertRowIndexToModel(d), this.fuzzersTable.convertRowIndexToModel(d));
        int e = 0;
        String[] allPayloads = this.payloadsTableModel.getAllRows();
        int k = 0;
        while (k < allPayloads.length) {
            if (allPayloads[k].equalsIgnoreCase(payload)) {
                e = k;
            }
            ++k;
        }
        this.payloadsTable.getSelectionModel().setSelectionInterval(e, e);
    }

    @Override
    public void start() {
        JBroFuzzWindow mFrameWindow = this.getFrame();
        JBroFuzzMenuBar mainMenuBar = mFrameWindow.getJBroMenuBar();
        if (mFrameWindow.getPanelFuzzing().isStopped()) {
            mainMenuBar.setSelectedPanelCheckBox(125);
            mFrameWindow.setTabShow(125);
            new LoadFuzzers(mFrameWindow);
        } else {
            mainMenuBar.setSelectedPanelCheckBox(124);
            mFrameWindow.setTabShow(124);
            int choice = JOptionPane.showConfirmDialog(mFrameWindow, "Fuzzing Session Running. Stop Fuzzing?", " JBroFuzz - Stop ", 0);
            if (choice == 0) {
                int c = mFrameWindow.getTp().getSelectedIndex();
                AbstractPanel p = (AbstractPanel)mFrameWindow.getTp().getComponent(c);
                p.stop();
                mainMenuBar.setSelectedPanelCheckBox(125);
                mFrameWindow.setTabShow(125);
                new LoadFuzzers(mFrameWindow);
            }
        }
    }

    @Override
    public void stop() {
    }

    public void updateFuzzers() {
        this.categoriesTable.setRowSorter(null);
        this.categoriesTableModel.setData(this.getFrame().getJBroFuzz().getDatabase().getAllCategories());
        this.sorter = new TableRowSorter<SingleColumnModel>(this.categoriesTableModel);
        this.categoriesTable.setRowSorter(this.sorter);
    }
}

